/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.spring;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bremersee.comparator.model.ComparatorField;
import org.springframework.data.domain.Sort;

public abstract class ComparatorSpringUtils {
    private ComparatorSpringUtils() {
    }

    public static Sort toSort(Collection<? extends ComparatorField> comparatorFields) {
        List orderList = comparatorFields.stream().map(ComparatorSpringUtils::toSortOrder).filter(Objects::nonNull).collect(Collectors.toList());
        if (orderList.isEmpty()) {
            return Sort.unsorted();
        }
        return Sort.by(orderList);
    }

    public static List<ComparatorField> fromSort(Sort sort) {
        if (sort == null) {
            return Collections.emptyList();
        }
        return sort.stream().map(ComparatorSpringUtils::fromSortOrder).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Sort.Order toSortOrder(ComparatorField comparatorField) {
        if (comparatorField == null || comparatorField.getField() == null || comparatorField.getField().trim().length() == 0) {
            return null;
        }
        Sort.Direction direction = comparatorField.isAsc() ? Sort.Direction.ASC : Sort.Direction.DESC;
        Sort.NullHandling nullHandlingHint = comparatorField.isNullIsFirst() ? Sort.NullHandling.NULLS_FIRST : Sort.NullHandling.NULLS_LAST;
        Sort.Order order = new Sort.Order(direction, comparatorField.getField(), nullHandlingHint);
        if (comparatorField.isIgnoreCase()) {
            return order.ignoreCase();
        }
        return order;
    }

    public static ComparatorField fromSortOrder(Sort.Order sortOrder) {
        if (sortOrder == null || sortOrder.getProperty() == null || sortOrder.getProperty().trim().length() == 0) {
            return null;
        }
        boolean nullIsFirst = Sort.NullHandling.NULLS_FIRST.equals((Object)sortOrder.getNullHandling());
        return new ComparatorField(sortOrder.getProperty(), sortOrder.isAscending(), sortOrder.isIgnoreCase(), nullIsFirst);
    }
}

