/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.bremersee.comparator.ValueExtractor;
import org.bremersee.comparator.ValueExtractorException;

public class DefaultValueExtractor
implements ValueExtractor {
    private final boolean throwingException;

    public DefaultValueExtractor() {
        this(true);
    }

    public DefaultValueExtractor(boolean throwingException) {
        this.throwingException = throwingException;
    }

    @Override
    public Object findValue(Object obj, String fieldPath) {
        Object value;
        String fieldName;
        String fieldIdentifier = DefaultValueExtractor.trimFieldPath(fieldPath);
        if (obj == null || fieldIdentifier == null || fieldIdentifier.length() == 0) {
            return obj;
        }
        int index = fieldIdentifier.indexOf(46);
        String string = fieldName = index < 0 ? fieldIdentifier : fieldIdentifier.substring(0, index);
        if (fieldName.length() == 0) {
            return this.findValue(obj, fieldIdentifier.substring(index + 1));
        }
        Optional<Field> field = this.findField(obj.getClass(), fieldName);
        if (field.isPresent()) {
            value = this.invoke(field.get(), obj);
        } else {
            Optional<Method> method = this.findMethod(obj.getClass(), fieldName);
            if (method.isPresent()) {
                value = this.invoke(method.get(), obj);
            } else {
                if (this.throwingException) {
                    throw new ValueExtractorException("Field [" + fieldName + "] was not found on object [" + obj + "].");
                }
                value = null;
            }
        }
        return index < 0 ? value : this.findValue(value, fieldIdentifier.substring(index + 1));
    }

    private static String trimFieldPath(String field) {
        if (field == null) {
            return null;
        }
        String tmp = field.replace("..", ".").trim();
        while (tmp.startsWith(".")) {
            tmp = tmp.substring(1).trim();
        }
        while (tmp.endsWith(".")) {
            tmp = tmp.substring(0, tmp.length() - 1).trim();
        }
        return tmp;
    }
}

