/*
 * Decompiled with CFR 0.152.
 */
package org.boomevents.hubspot.domain.task;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigInteger;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.boomevents.hubspot.Client;
import org.boomevents.hubspot.domain.task.Task;
import org.boomevents.hubspot.domain.task.TaskCreateRequest;
import org.boomevents.hubspot.domain.task.TaskUpdateRequest;
import org.boomevents.hubspot.domain.task.exceptions.TaskNotFoundException;
import org.boomevents.hubspot.model.http.RequestMethod;
import org.boomevents.hubspot.model.http.Requester;
import org.boomevents.hubspot.model.http.exceptions.HttpRequestException;
import org.boomevents.hubspot.model.mapper.Mapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/boomevents/hubspot/domain/task/TaskClient;", "", "hubSpotClient", "Lorg/boomevents/hubspot/Client;", "(Lorg/boomevents/hubspot/Client;)V", "changeTask", "Lorg/boomevents/hubspot/domain/task/Task;", "taskId", "Ljava/math/BigInteger;", "request", "Lorg/boomevents/hubspot/domain/task/TaskUpdateRequest;", "createTask", "Lorg/boomevents/hubspot/domain/task/TaskCreateRequest;", "findTask", "removeTask", "", "hubspot"})
public final class TaskClient {
    @NotNull
    private final Client hubSpotClient;

    public TaskClient(@NotNull Client hubSpotClient) {
        Intrinsics.checkNotNullParameter((Object)hubSpotClient, (String)"hubSpotClient");
        this.hubSpotClient = hubSpotClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Task createTask(@NotNull TaskCreateRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpResponse<JsonNode> response = Requester.INSTANCE.requestJson(this.hubSpotClient, RequestMethod.POST, "/crm/v3/objects/tasks", MapsKt.emptyMap(), request);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (Task)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Task>(){});
        }
        throw new RuntimeException(response.getStatusText());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Task findTask(@NotNull BigInteger taskId) throws TaskNotFoundException, HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        String string = taskId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/tasks/{taskId}", (String)"{taskId}", (String)string, (boolean)false, (int)4, null);
        HttpResponse response = Requester.requestJson$default(Requester.INSTANCE, this.hubSpotClient, RequestMethod.GET, requestUrl, null, null, 24, null);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (Task)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Task>(){});
        }
        if (response.getStatus() == 404) {
            throw new TaskNotFoundException(taskId, null, 2, null);
        }
        int n = response.getStatus();
        String string2 = response.getStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.statusText");
        throw new HttpRequestException(n, string2, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Task changeTask(@NotNull BigInteger taskId, @NotNull TaskUpdateRequest request) {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string = taskId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/tasks/{taskId}", (String)"{taskId}", (String)string, (boolean)false, (int)4, null);
        HttpResponse<JsonNode> response = Requester.INSTANCE.requestJson(this.hubSpotClient, RequestMethod.PATCH, requestUrl, MapsKt.emptyMap(), request);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (Task)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Task>(){});
        }
        if (response.getStatus() == 404) {
            throw new TaskNotFoundException(taskId, null, 2, null);
        }
        int n = response.getStatus();
        String string2 = response.getStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.statusText");
        throw new HttpRequestException(n, string2, null, 4, null);
    }

    public final void removeTask(@NotNull BigInteger taskId) throws HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)taskId, (String)"taskId");
        String string = taskId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"taskId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/tasks/{taskId}", (String)"{taskId}", (String)string, (boolean)false, (int)4, null);
        HttpResponse response = Requester.requestVoid$default(Requester.INSTANCE, this.hubSpotClient, RequestMethod.DELETE, requestUrl, null, null, 24, null);
        if (!response.isSuccess()) {
            response.getStatus();
            int n = response.getStatus();
            String string2 = response.getStatusText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.statusText");
            throw new HttpRequestException(n, string2, null, 4, null);
        }
    }
}

