/*
 * Decompiled with CFR 0.152.
 */
package org.boomevents.hubspot.model.http;

import java.util.Map;
import kong.unirest.HttpRequest;
import kong.unirest.HttpRequestWithBody;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kong.unirest.ObjectMapper;
import kong.unirest.Unirest;
import kong.unirest.jackson.JacksonObjectMapper;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.boomevents.hubspot.Client;
import org.boomevents.hubspot.model.http.RequestMethod;
import org.boomevents.hubspot.model.mapper.Mapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002JF\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0001JD\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0012"}, d2={"Lorg/boomevents/hubspot/model/http/Requester;", "", "()V", "builder", "Lkong/unirest/HttpRequest;", "client", "Lorg/boomevents/hubspot/Client;", "method", "Lorg/boomevents/hubspot/model/http/RequestMethod;", "path", "", "requestJson", "Lkong/unirest/HttpResponse;", "Lkong/unirest/JsonNode;", "query", "", "body", "requestVoid", "hubspot"})
public final class Requester {
    @NotNull
    public static final Requester INSTANCE = new Requester();

    private Requester() {
    }

    private final HttpRequest<?> builder(Client client, RequestMethod method, String path) {
        HttpRequest httpRequest;
        String apiPath = client.getApiBasePath() + path;
        switch (WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
            case 1: {
                httpRequest = (HttpRequest)Unirest.get((String)apiPath);
                break;
            }
            case 2: {
                httpRequest = (HttpRequest)Unirest.post((String)apiPath);
                break;
            }
            case 3: {
                httpRequest = (HttpRequest)Unirest.patch((String)apiPath);
                break;
            }
            case 4: {
                httpRequest = (HttpRequest)Unirest.delete((String)apiPath);
                break;
            }
            case 5: {
                httpRequest = (HttpRequest)Unirest.put((String)apiPath);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HttpRequest request = httpRequest;
        request.header("Authorization", "Bearer " + client.getApiKey()).withObjectMapper((ObjectMapper)new JacksonObjectMapper(Mapper.INSTANCE.getObjectMapper()));
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"request");
        return request;
    }

    @NotNull
    public final HttpResponse<JsonNode> requestJson(@NotNull Client client, @NotNull RequestMethod method, @NotNull String path, @NotNull Map<String, String> query, @Nullable Object body) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        HttpRequest request = this.builder(client, method, path).header("Content-Type", "application/json").queryString(query);
        if (request instanceof HttpRequestWithBody && body != null) {
            HttpResponse httpResponse = ((HttpRequestWithBody)request).body(body).asJson();
            Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"request.body(body).asJson()");
            return httpResponse;
        }
        HttpResponse httpResponse = request.asJson();
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"request.asJson()");
        return httpResponse;
    }

    public static /* synthetic */ HttpResponse requestJson$default(Requester requester, Client client, RequestMethod requestMethod, String string, Map map, Object object, int n, Object object2) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            object = null;
        }
        return requester.requestJson(client, requestMethod, string, map, object);
    }

    @NotNull
    public final HttpResponse<?> requestVoid(@NotNull Client client, @NotNull RequestMethod method, @NotNull String path, @NotNull Map<String, String> query, @Nullable Object body) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(query, (String)"query");
        HttpRequest request = this.builder(client, method, path).header("Content-Type", "application/json").queryString(query);
        if (request instanceof HttpRequestWithBody && body != null) {
            ((HttpRequestWithBody)request).body(body).asEmpty();
        }
        HttpResponse httpResponse = request.asEmpty();
        Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"request.asEmpty()");
        return httpResponse;
    }

    public static /* synthetic */ HttpResponse requestVoid$default(Requester requester, Client client, RequestMethod requestMethod, String string, Map map, Object object, int n, Object object2) {
        if ((n & 8) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            object = null;
        }
        return requester.requestVoid(client, requestMethod, string, map, object);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RequestMethod.values().length];
            nArray[RequestMethod.GET.ordinal()] = 1;
            nArray[RequestMethod.POST.ordinal()] = 2;
            nArray[RequestMethod.PATCH.ordinal()] = 3;
            nArray[RequestMethod.DELETE.ordinal()] = 4;
            nArray[RequestMethod.PUT.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

