/*
 * Decompiled with CFR 0.152.
 */
package org.boomevents.hubspot.domain.customobject;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigInteger;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.boomevents.hubspot.Client;
import org.boomevents.hubspot.domain.customobject.CustomObject;
import org.boomevents.hubspot.domain.customobject.CustomObjectRequest;
import org.boomevents.hubspot.domain.customobject.exceptions.CustomObjectNotFoundException;
import org.boomevents.hubspot.model.http.RequestMethod;
import org.boomevents.hubspot.model.http.Requester;
import org.boomevents.hubspot.model.http.exceptions.HttpRequestException;
import org.boomevents.hubspot.model.mapper.Mapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002J\"\u0010\n\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eJ\u001a\u0010\u000f\u001a\u00020\u000b\"\u0004\b\u0000\u0010\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\f0\u000eJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/boomevents/hubspot/domain/customobject/CustomObjectClient;", "", "hubSpotClient", "Lorg/boomevents/hubspot/Client;", "customObjectEntity", "", "(Lorg/boomevents/hubspot/Client;Ljava/lang/String;)V", "buildUrlForObjectRecord", "customObjectId", "Ljava/math/BigInteger;", "changeCustomObjectRecord", "Lorg/boomevents/hubspot/domain/customobject/CustomObject;", "P", "request", "Lorg/boomevents/hubspot/domain/customobject/CustomObjectRequest;", "createCustomObjectRecord", "findCustomObjectRecord", "removeCustomObjectRecord", "", "hubspot"})
public final class CustomObjectClient {
    @NotNull
    private final Client hubSpotClient;
    @NotNull
    private final String customObjectEntity;

    public CustomObjectClient(@NotNull Client hubSpotClient, @NotNull String customObjectEntity) {
        Intrinsics.checkNotNullParameter((Object)hubSpotClient, (String)"hubSpotClient");
        Intrinsics.checkNotNullParameter((Object)customObjectEntity, (String)"customObjectEntity");
        this.hubSpotClient = hubSpotClient;
        this.customObjectEntity = customObjectEntity;
    }

    private final String buildUrlForObjectRecord(BigInteger customObjectId) {
        String string = StringsKt.replace$default((String)"/crm/v3/objects/{customObjectEntity}/{customObjectId}", (String)"{customObjectEntity}", (String)this.customObjectEntity, (boolean)false, (int)4, null);
        String string2 = customObjectId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"customObjectId.toString()");
        return StringsKt.replace$default((String)string, (String)"{customObjectId}", (String)string2, (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <P> CustomObject createCustomObjectRecord(@NotNull CustomObjectRequest<P> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/{customObjectEntity}", (String)"{customObjectEntity}", (String)this.customObjectEntity, (boolean)false, (int)4, null);
        HttpResponse<JsonNode> response = Requester.INSTANCE.requestJson(this.hubSpotClient, RequestMethod.POST, requestUrl, MapsKt.emptyMap(), request);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (CustomObject)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<CustomObject>(){});
        }
        throw new RuntimeException(((JsonNode)response.getBody()).toPrettyString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CustomObject findCustomObjectRecord(@NotNull BigInteger customObjectId) throws CustomObjectNotFoundException, HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)customObjectId, (String)"customObjectId");
        String requestUrl = this.buildUrlForObjectRecord(customObjectId);
        HttpResponse response = Requester.requestJson$default(Requester.INSTANCE, this.hubSpotClient, RequestMethod.GET, requestUrl, null, null, 24, null);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (CustomObject)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<CustomObject>(){});
        }
        if (response.getStatus() == 404) {
            throw new CustomObjectNotFoundException(this.customObjectEntity, customObjectId, null, 4, null);
        }
        int n = response.getStatus();
        String string = response.getStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.statusText");
        throw new HttpRequestException(n, string, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <P> CustomObject changeCustomObjectRecord(@NotNull BigInteger customObjectId, @NotNull CustomObjectRequest<P> request) {
        Intrinsics.checkNotNullParameter((Object)customObjectId, (String)"customObjectId");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String requestUrl = this.buildUrlForObjectRecord(customObjectId);
        HttpResponse<JsonNode> response = Requester.INSTANCE.requestJson(this.hubSpotClient, RequestMethod.PATCH, requestUrl, MapsKt.emptyMap(), request);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (CustomObject)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<CustomObject>(){});
        }
        if (response.getStatus() == 404) {
            throw new CustomObjectNotFoundException(this.customObjectEntity, customObjectId, null, 4, null);
        }
        int n = response.getStatus();
        String string = response.getStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.statusText");
        throw new HttpRequestException(n, string, null, 4, null);
    }

    public final void removeCustomObjectRecord(@NotNull BigInteger customObjectId) throws HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)customObjectId, (String)"customObjectId");
        String requestUrl = this.buildUrlForObjectRecord(customObjectId);
        HttpResponse response = Requester.requestVoid$default(Requester.INSTANCE, this.hubSpotClient, RequestMethod.DELETE, requestUrl, null, null, 24, null);
        if (!response.isSuccess()) {
            response.getStatus();
            int n = response.getStatus();
            String string = response.getStatusText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.statusText");
            throw new HttpRequestException(n, string, null, 4, null);
        }
    }
}

