/*
 * Decompiled with CFR 0.152.
 */
package org.boomevents.hubspot.domain.contact;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Map;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.boomevents.hubspot.Client;
import org.boomevents.hubspot.domain.contact.Contact;
import org.boomevents.hubspot.domain.contact.ContactRequest;
import org.boomevents.hubspot.domain.contact.exception.ContactNotFoundException;
import org.boomevents.hubspot.model.http.RequestMethod;
import org.boomevents.hubspot.model.http.Requester;
import org.boomevents.hubspot.model.http.exceptions.HttpRequestException;
import org.boomevents.hubspot.model.mapper.Mapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bJ\u001a\u0010\f\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/boomevents/hubspot/domain/contact/ContactClient;", "", "hubSpotClient", "Lorg/boomevents/hubspot/Client;", "(Lorg/boomevents/hubspot/Client;)V", "changeContact", "Lorg/boomevents/hubspot/domain/contact/Contact;", "P", "contactId", "Ljava/math/BigInteger;", "request", "Lorg/boomevents/hubspot/domain/contact/ContactRequest;", "createContact", "findContact", "email", "", "makeRequestFindContact", "requestUrl", "removeContact", "", "hubspot"})
public final class ContactClient {
    @NotNull
    private final Client hubSpotClient;

    public ContactClient(@NotNull Client hubSpotClient) {
        Intrinsics.checkNotNullParameter((Object)hubSpotClient, (String)"hubSpotClient");
        this.hubSpotClient = hubSpotClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <P> Contact createContact(@NotNull ContactRequest<P> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Object object = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(object, (String)"emptyMap()");
        HttpResponse<JsonNode> response = Requester.INSTANCE.requestJson(this.hubSpotClient, RequestMethod.POST, "/crm/v3/objects/contacts", (Map<String, String>)object, request);
        if (response.isSuccess()) {
            void this_$iv;
            object = Mapper.INSTANCE;
            Object object2 = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object2;
            boolean $i$f$mapToObject = false;
            return (Contact)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Contact>(){});
        }
        throw new RuntimeException(response.getStatusText());
    }

    @NotNull
    public final Contact findContact(@NotNull BigInteger contactId) throws ContactNotFoundException, HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)contactId, (String)"contactId");
        String string = contactId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contactId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/contacts/{contactId}", (String)"{contactId}", (String)string, (boolean)false, (int)4, null);
        return this.makeRequestFindContact(requestUrl);
    }

    @NotNull
    public final Contact findContact(@NotNull String email) throws ContactNotFoundException, HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/contacts/{contactId}", (String)"{contactId}", (String)email, (boolean)false, (int)4, null) + "?idProperty=email";
        return this.makeRequestFindContact(requestUrl);
    }

    /*
     * WARNING - void declaration
     */
    private final Contact makeRequestFindContact(String requestUrl) {
        HttpResponse response = Requester.requestJson$default(Requester.INSTANCE, this.hubSpotClient, RequestMethod.GET, requestUrl, null, null, 24, null);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (Contact)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Contact>(){});
        }
        if (response.getStatus() == 404) {
            throw new ContactNotFoundException();
        }
        int n = response.getStatus();
        String string = response.getStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"response.statusText");
        throw new HttpRequestException(n, string, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <P> Contact changeContact(@NotNull BigInteger contactId, @NotNull ContactRequest<P> request) {
        Intrinsics.checkNotNullParameter((Object)contactId, (String)"contactId");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String string = contactId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contactId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/contacts/{contactId}", (String)"{contactId}", (String)string, (boolean)false, (int)4, null);
        Object object = Collections.emptyMap();
        Intrinsics.checkNotNullExpressionValue(object, (String)"emptyMap()");
        HttpResponse<JsonNode> response = Requester.INSTANCE.requestJson(this.hubSpotClient, RequestMethod.PATCH, requestUrl, (Map<String, String>)object, request);
        if (response.isSuccess()) {
            void this_$iv;
            object = Mapper.INSTANCE;
            Object object2 = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object2;
            boolean $i$f$mapToObject = false;
            return (Contact)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Contact>(){});
        }
        if (response.getStatus() == 404) {
            throw new ContactNotFoundException(contactId);
        }
        int n = response.getStatus();
        String string2 = response.getStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.statusText");
        throw new HttpRequestException(n, string2, null, 4, null);
    }

    public final void removeContact(@NotNull BigInteger contactId) throws HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)contactId, (String)"contactId");
        String string = contactId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"contactId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/contacts/{contactId}", (String)"{contactId}", (String)string, (boolean)false, (int)4, null);
        HttpResponse response = Requester.requestVoid$default(Requester.INSTANCE, this.hubSpotClient, RequestMethod.DELETE, requestUrl, null, null, 24, null);
        if (!response.isSuccess()) {
            response.getStatus();
            int n = response.getStatus();
            String string2 = response.getStatusText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.statusText");
            throw new HttpRequestException(n, string2, null, 4, null);
        }
    }
}

