/*
 * Decompiled with CFR 0.152.
 */
package org.boomevents.hubspot.domain.company;

import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigInteger;
import kong.unirest.HttpResponse;
import kong.unirest.JsonNode;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.boomevents.hubspot.Client;
import org.boomevents.hubspot.domain.company.Company;
import org.boomevents.hubspot.domain.company.CompanyRequest;
import org.boomevents.hubspot.domain.company.exceptions.CompanyNotFoundException;
import org.boomevents.hubspot.model.http.RequestMethod;
import org.boomevents.hubspot.model.http.Requester;
import org.boomevents.hubspot.model.http.exceptions.HttpRequestException;
import org.boomevents.hubspot.model.mapper.Mapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bJ\u001a\u0010\f\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000bJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/boomevents/hubspot/domain/company/CompanyClient;", "", "hubSpotClient", "Lorg/boomevents/hubspot/Client;", "(Lorg/boomevents/hubspot/Client;)V", "changeCompany", "Lorg/boomevents/hubspot/domain/company/Company;", "P", "companyId", "Ljava/math/BigInteger;", "request", "Lorg/boomevents/hubspot/domain/company/CompanyRequest;", "createCompany", "findCompany", "removeCompany", "", "hubspot"})
public final class CompanyClient {
    @NotNull
    private final Client hubSpotClient;

    public CompanyClient(@NotNull Client hubSpotClient) {
        Intrinsics.checkNotNullParameter((Object)hubSpotClient, (String)"hubSpotClient");
        this.hubSpotClient = hubSpotClient;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <P> Company createCompany(@NotNull CompanyRequest<P> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        HttpResponse<JsonNode> response = Requester.INSTANCE.requestJson(this.hubSpotClient, RequestMethod.POST, "/crm/v3/objects/companies", MapsKt.emptyMap(), request);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (Company)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Company>(){});
        }
        throw new RuntimeException(response.getStatusText());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Company findCompany(@NotNull BigInteger companyId) throws CompanyNotFoundException, HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)companyId, (String)"companyId");
        String string = companyId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"companyId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/companies/{companyId}", (String)"{companyId}", (String)string, (boolean)false, (int)4, null);
        HttpResponse response = Requester.requestJson$default(Requester.INSTANCE, this.hubSpotClient, RequestMethod.GET, requestUrl, null, null, 24, null);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (Company)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Company>(){});
        }
        if (response.getStatus() == 404) {
            throw new CompanyNotFoundException(companyId, null, 2, null);
        }
        int n = response.getStatus();
        String string2 = response.getStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.statusText");
        throw new HttpRequestException(n, string2, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <P> Company changeCompany(@NotNull BigInteger companyId, @NotNull CompanyRequest<P> request) {
        Intrinsics.checkNotNullParameter((Object)companyId, (String)"companyId");
        Intrinsics.checkNotNullParameter(request, (String)"request");
        String string = companyId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"companyId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/companies/{companyId}", (String)"{companyId}", (String)string, (boolean)false, (int)4, null);
        HttpResponse<JsonNode> response = Requester.INSTANCE.requestJson(this.hubSpotClient, RequestMethod.PATCH, requestUrl, MapsKt.emptyMap(), request);
        if (response.isSuccess()) {
            void this_$iv;
            Mapper mapper = Mapper.INSTANCE;
            Object object = response.getBody();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"response.body");
            JsonNode jsonNode$iv = (JsonNode)object;
            boolean $i$f$mapToObject = false;
            return (Company)this_$iv.getObjectMapper().readValue(jsonNode$iv.toString(), (TypeReference)new TypeReference<Company>(){});
        }
        if (response.getStatus() == 404) {
            throw new CompanyNotFoundException(companyId, null, 2, null);
        }
        int n = response.getStatus();
        String string2 = response.getStatusText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.statusText");
        throw new HttpRequestException(n, string2, null, 4, null);
    }

    public final void removeCompany(@NotNull BigInteger companyId) throws HttpRequestException {
        Intrinsics.checkNotNullParameter((Object)companyId, (String)"companyId");
        String string = companyId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"companyId.toString()");
        String requestUrl = StringsKt.replace$default((String)"/crm/v3/objects/companies/{companyId}", (String)"{companyId}", (String)string, (boolean)false, (int)4, null);
        HttpResponse response = Requester.requestVoid$default(Requester.INSTANCE, this.hubSpotClient, RequestMethod.DELETE, requestUrl, null, null, 24, null);
        if (!response.isSuccess()) {
            response.getStatus();
            int n = response.getStatus();
            String string2 = response.getStatusText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"response.statusText");
            throw new HttpRequestException(n, string2, null, 4, null);
        }
    }
}

