/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class CopyOnWriteArrayNavigableSet<E>
extends AbstractSet<E>
implements Serializable,
NavigableSet<E> {
    private static final long serialVersionUID = -3680134489612968105L;
    final Comparator<? super E> comparator;
    final CopyOnWriteArrayList<E> al;

    CopyOnWriteArrayNavigableSet(Comparator<? super E> comparator, CopyOnWriteArrayList<E> al) {
        this.comparator = Objects.requireNonNull(comparator, "comparator");
        this.al = al;
    }

    public CopyOnWriteArrayNavigableSet() {
        this(Comparator.naturalOrder());
    }

    public CopyOnWriteArrayNavigableSet(Comparator<? super E> comparator) {
        this(comparator, new CopyOnWriteArrayList());
    }

    public CopyOnWriteArrayNavigableSet(Iterable<? extends E> c) {
        if (c.getClass() == CopyOnWriteArrayNavigableSet.class) {
            this.comparator = ((CopyOnWriteArrayNavigableSet)c).comparator;
            this.al = new CopyOnWriteArrayList();
            this.al.setArray(((CopyOnWriteArrayNavigableSet)c).al.getArray());
        } else if (c instanceof SortedSet) {
            Comparator compare = ((SortedSet)c).comparator();
            this.comparator = compare == null ? Comparator.naturalOrder() : compare;
            this.al = new CopyOnWriteArrayList((SortedSet)c);
        } else {
            this.comparator = Comparator.naturalOrder();
            this.al = new CopyOnWriteArrayList();
            if (c instanceof Collection) {
                CopyOnWriteArrayNavigableSet.addAll(this, (Collection)c);
            } else {
                for (E e : c) {
                    CopyOnWriteArrayNavigableSet.add(this, e);
                }
            }
        }
    }

    public static <E extends Comparable<? super E>> CopyOnWriteArrayNavigableSet<E> create() {
        return new CopyOnWriteArrayNavigableSet<E>();
    }

    public static <E extends Comparable<? super E>> CopyOnWriteArrayNavigableSet<E> create(Iterable<E> contents) {
        return new CopyOnWriteArrayNavigableSet<E>(contents);
    }

    public static <E> CopyOnWriteArrayNavigableSet<E> create(Comparator<? super E> comparator) {
        return new CopyOnWriteArrayNavigableSet<E>(comparator);
    }

    @Override
    public boolean contains(Object o) {
        return Arrays.binarySearch(this.al.getArray(), o, this.comparator) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.al.lock;
        synchronized (object) {
            Object[] array = this.al.getArray();
            int loc = Arrays.binarySearch(array, o, this.comparator);
            if (loc >= 0) {
                this.al.remove(loc);
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean add(E e) {
        return CopyOnWriteArrayNavigableSet.add(this, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E> boolean add(CopyOnWriteArrayNavigableSet<E> cowans, E e) {
        Objects.requireNonNull(e, "e");
        Object object = cowans.al.lock;
        synchronized (object) {
            int loc;
            Object[] array = cowans.al.getArray();
            int n = array.length != 0 ? Arrays.binarySearch(array, e, cowans.comparator) : (loc = cowans.comparator().compare(e, e) == 0 ? -1 : Integer.MIN_VALUE);
            if (loc < 0) {
                if (loc == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("Comparison method violates its general contract!");
                }
                cowans.al.add(-1 - loc, e);
                return true;
            }
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Object[] array = this.al.getArray();
        for (Object each : c) {
            if (Arrays.binarySearch(array, each, this.comparator) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return CopyOnWriteArrayNavigableSet.addAll(this, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E> boolean addAll(CopyOnWriteArrayNavigableSet<E> cowans, Collection<? extends E> c) {
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        if (cs.length == 1) {
            return cowans.add(cs[0]);
        }
        Object object = cowans.al.lock;
        synchronized (object) {
            Object[] array = cowans.al.getArray();
            int len = array.length;
            int added = 0;
            for (int i = 0; i < cs.length; ++i) {
                int at;
                Object e = Objects.requireNonNull(cs[i]);
                if (Arrays.binarySearch(array, e, cowans.comparator) >= 0) continue;
                int n = len != 0 ? Arrays.binarySearch(cs, 0, added, e, cowans.comparator) : (at = cowans.comparator().compare(e, e) == 0 ? -1 : Integer.MIN_VALUE);
                if (at >= 0) continue;
                if (at == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("Comparison method violates its general contract!");
                }
                at = -at - 1;
                System.arraycopy(cs, at, cs, at + 1, added++ - at);
                cs[at] = e;
            }
            if (added > 0) {
                Object[] newElements = (Object[])Array.newInstance(array.getClass().getComponentType(), len + added);
                --len;
                --added;
                for (int i = newElements.length - 1; i >= 0; --i) {
                    newElements[i] = len >= 0 && (added < 0 || cowans.comparator.compare(array[len], cs[added]) > 0) ? array[len--] : cs[added--];
                }
                cowans.al.setArray(newElements);
                return true;
            }
            return false;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return this.al.iterator();
    }

    @Override
    public int size() {
        return this.al.size();
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.al.removeIf(filter);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.al.forEach(action);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.al.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.al.removeAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.al.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.al.toArray(a);
    }

    @Override
    public void clear() {
        this.al.clear();
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.al.getArray(), 1297);
    }

    @Override
    public E lower(E e) {
        Object[] array = this.al.getArray();
        int loc = Arrays.binarySearch(array, e, this.comparator);
        return (E)(loc > 0 ? array[loc - 1] : (loc < -1 ? array[-2 - loc] : null));
    }

    @Override
    public E floor(E e) {
        Object[] array = this.al.getArray();
        int loc = Arrays.binarySearch(array, e, this.comparator);
        return (E)(loc >= 0 ? array[loc] : (loc < -1 ? array[-2 - loc] : null));
    }

    @Override
    public E ceiling(E e) {
        Object[] array = this.al.getArray();
        int loc = Arrays.binarySearch(array, e, this.comparator);
        return (E)(loc >= 0 ? array[loc] : (-loc < array.length ? array[-1 - loc] : null));
    }

    @Override
    public E higher(E e) {
        Object[] array = this.al.getArray();
        int loc = Arrays.binarySearch(array, e, this.comparator);
        return (E)(loc >= 0 ? (loc < array.length - 1 ? array[loc + 1] : null) : (-loc < array.length ? array[-1 - loc] : null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst() {
        if (this.al.isEmpty()) {
            return null;
        }
        Object object = this.al.lock;
        synchronized (object) {
            if (this.al.isEmpty()) {
                return null;
            }
            E result = this.al.remove(0);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast() {
        if (this.al.isEmpty()) {
            return null;
        }
        Object object = this.al.lock;
        synchronized (object) {
            if (this.al.isEmpty()) {
                return null;
            }
            E result = this.al.remove(this.al.size() - 1);
            return result;
        }
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return new BoundedNavigableSet<Object>(this.comparator, this.al, false, null, false, false, null, false, true);
    }

    @Override
    public Iterator<E> descendingIterator() {
        final Object[] array = this.al.getArray();
        return array.length == 0 ? Collections.emptyIterator() : new Iterator<E>(){
            int index;
            {
                this.index = array.length - 1;
            }

            @Override
            public boolean hasNext() {
                return this.index >= 0;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return array[this.index--];
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        return new BoundedNavigableSet<E>(this.comparator, this.al, true, fromElement, fromInclusive, true, toElement, toInclusive, false);
    }

    @Override
    public NavigableSet<E> headSet(E toElement, boolean inclusive) {
        return new BoundedNavigableSet<Object>((Comparator<Object>)this.comparator, (CopyOnWriteArrayList<Object>)this.al, false, null, false, true, toElement, inclusive, false);
    }

    @Override
    public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
        return new BoundedNavigableSet<Object>((Comparator<Object>)this.comparator, (CopyOnWriteArrayList<Object>)this.al, true, fromElement, inclusive, false, null, false, false);
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        return this.subSet(fromElement, true, toElement, false);
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        return this.headSet(toElement, false);
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        return this.tailSet(fromElement, true);
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public E first() {
        if (this.al.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object[] array = this.al.getArray();
        if (array.length == 0) {
            throw new NoSuchElementException();
        }
        return (E)array[0];
    }

    @Override
    public E last() {
        if (this.al.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object[] array = this.al.getArray();
        if (array.length == 0) {
            throw new NoSuchElementException();
        }
        return (E)array[array.length - 1];
    }

    private static class BoundedNavigableSet<E>
    extends CopyOnWriteArrayNavigableSet<E> {
        private static final long serialVersionUID = 3830104881368453055L;
        final boolean descending;
        final boolean lowerBounded;
        final boolean upperBounded;
        final boolean lowerInclusive;
        final boolean upperInclusive;
        final E lowerBound;
        final E upperBound;

        public BoundedNavigableSet(Comparator<? super E> comparator, CopyOnWriteArrayList<E> al, boolean lowerBounded, E fromElement, boolean lowerInclusive, boolean upperBounded, E toElement, boolean upperInclusive, boolean descending) {
            super(comparator, al);
            this.descending = descending;
            if (lowerBounded && upperBounded) {
                int toCompared;
                int fromCompared = Integer.signum(comparator.compare(fromElement, toElement));
                if (fromCompared != -(toCompared = Integer.signum(comparator.compare(toElement, fromElement)))) {
                    throw new IllegalArgumentException("inconsistent comparator");
                }
                if (!descending ? fromCompared > 0 : fromCompared < 0) {
                    throw new IllegalArgumentException("upper < lower");
                }
            }
            this.lowerBounded = lowerBounded;
            this.lowerBound = fromElement;
            this.lowerInclusive = lowerInclusive;
            this.upperBounded = upperBounded;
            this.upperBound = toElement;
            this.upperInclusive = upperInclusive;
        }

        @Override
        public boolean add(E e) {
            return super.add(this.inBounds(e));
        }

        @Override
        public boolean contains(Object o) {
            return this.checkInBounds(o) && super.contains(o);
        }

        @Override
        public Comparator<E> comparator() {
            return this.descending ? this.comparator.reversed() : this.comparator;
        }

        @Override
        public NavigableSet<E> descendingSet() {
            return new BoundedNavigableSet<E>(this.comparator, this.al, this.upperBounded, this.upperBound, this.upperInclusive, this.lowerBounded, this.lowerBound, this.lowerInclusive, !this.descending);
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            return new BoundedNavigableSet<E>(this.comparator, this.al, true, this.inBounds(fromElement), fromInclusive, true, this.inBounds(toElement), toInclusive, this.descending);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            return new BoundedNavigableSet<E>(this.comparator, this.al, this.lowerBounded, this.lowerBound, this.lowerInclusive, true, this.inBounds(toElement), inclusive, this.descending);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            return new BoundedNavigableSet<E>(this.comparator, this.al, true, this.inBounds(fromElement), inclusive, this.upperBounded, this.upperBound, this.upperInclusive, this.descending);
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        private E inBounds(E element) {
            if (this.lowerBounded) {
                if (this.lowerInclusive) {
                    if (this.comparator.compare(this.lowerBound, element) > 0) {
                        throw new IllegalArgumentException("out of bounds: " + element + " < " + this.lowerBound);
                    }
                } else if (this.comparator.compare(this.lowerBound, element) >= 0) {
                    throw new IllegalArgumentException("out of bounds: " + element + " <= " + this.lowerBound);
                }
            }
            if (this.upperBounded) {
                if (this.upperInclusive) {
                    if (this.comparator.compare(this.upperBound, element) < 0) {
                        throw new IllegalArgumentException("out of bounds: " + element + " > " + this.upperBound);
                    }
                } else if (this.comparator.compare(this.upperBound, element) <= 0) {
                    throw new IllegalArgumentException("out of bounds: " + element + " >= " + this.upperBound);
                }
            }
            return element;
        }

        private boolean checkInBounds(E element) {
            if (this.lowerBounded && (this.lowerInclusive ? this.comparator.compare(this.lowerBound, element) > 0 : this.comparator.compare(this.lowerBound, element) >= 0)) {
                return false;
            }
            return !this.upperBounded || !(this.upperInclusive ? this.comparator.compare(this.upperBound, element) < 0 : this.comparator.compare(this.upperBound, element) <= 0);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.makeIterator(!this.descending);
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            Objects.requireNonNull(action, "action");
            Object[] array = this.al.getArray();
            int start = this.fromLoc(array);
            int end = this.toLoc(array);
            for (int each = start; each < end; ++each) {
                action.accept(array[each]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Objects.requireNonNull(filter, "filter");
            Object object = this.al.lock;
            synchronized (object) {
                Object[] array = this.al.getArray();
                int start = this.fromLoc(array);
                int end = this.toLoc(array);
                return this.al.subList(start, end).removeIf(filter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            Object object = this.al.lock;
            synchronized (object) {
                Object[] array = this.al.getArray();
                int start = this.fromLoc(array);
                int end = this.toLoc(array);
                return this.al.subList(start, end).retainAll(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            Object object = this.al.lock;
            synchronized (object) {
                Object[] array = this.al.getArray();
                int start = this.fromLoc(array);
                int end = this.toLoc(array);
                return this.al.subList(start, end).removeAll(c);
            }
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            for (E e : c) {
                this.inBounds(e);
            }
            return CopyOnWriteArrayNavigableSet.addAll((CopyOnWriteArrayNavigableSet)this, c);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            Object[] array = this.al.getArray();
            int start = this.fromLoc(array);
            int end = this.toLoc(array);
            for (Object each : c) {
                if (Arrays.binarySearch(array, start, end, each, this.comparator) >= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return this.checkInBounds(o) && super.remove(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.al.lock;
            synchronized (object) {
                Object[] array = this.al.getArray();
                int start = this.fromLoc(array);
                int end = this.toLoc(array);
                this.al.removeRange(start, end);
            }
        }

        private int fromLoc(E[] array) {
            int start;
            if (this.lowerBounded) {
                start = Arrays.binarySearch(array, this.lowerBound, this.comparator == null ? (this.descending ? Comparator.reverseOrder() : null) : (this.descending ? this.comparator.reversed() : this.comparator));
                start = start >= 0 ? (this.lowerInclusive ? start : start + 1) : -1 - start;
            } else {
                start = 0;
            }
            return start;
        }

        private int toLoc(E[] array) {
            int end;
            end = this.upperBounded ? ((end = Arrays.binarySearch(array, this.upperBound, this.descending ? this.comparator.reversed() : this.comparator)) >= 0 ? (this.upperInclusive ? end + 1 : end) : -1 - end) : array.length;
            return end;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.makeArray(a, this.descending);
        }

        public <T> T[] makeArray(T[] a, boolean inDescending) {
            Object[] array = this.al.getArray();
            int start = this.fromLoc(array);
            int end = this.toLoc(array);
            int len = end - start;
            if (a.length < len) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), len);
            }
            System.arraycopy(array, start, a, 0, len);
            if (len < a.length) {
                a[len] = null;
            }
            if (inDescending) {
                Collections.reverse(Arrays.asList(a).subList(0, len));
            }
            return a;
        }

        @Override
        public Object[] toArray() {
            return this.makeArray(new Object[0], this.descending);
        }

        @Override
        public Iterator<E> iterator() {
            return this.makeIterator(this.descending);
        }

        private Iterator<E> makeIterator(boolean inDescending) {
            List<Object> asList;
            if (inDescending) {
                asList = Arrays.asList(this.makeArray(new Object[0], inDescending));
            } else {
                Object[] array = this.al.getArray();
                int start = this.fromLoc(array);
                int end = this.toLoc(array);
                asList = Arrays.asList(array).subList(start, end);
            }
            return Collections.unmodifiableList(asList).iterator();
        }

        @Override
        public int size() {
            Object[] array = this.al.getArray();
            return this.toLoc(array) - this.fromLoc(array);
        }

        @Override
        public E lower(E e) {
            E result = this.descending ? super.higher(e) : super.lower(e);
            return result != null && this.checkInBounds(result) ? (E)result : null;
        }

        @Override
        public E floor(E e) {
            E result = this.descending ? super.ceiling(e) : super.floor(e);
            return result != null && this.checkInBounds(result) ? (E)result : null;
        }

        @Override
        public E ceiling(E e) {
            E result = this.descending ? super.floor(e) : super.ceiling(e);
            return result != null && this.checkInBounds(result) ? (E)result : null;
        }

        @Override
        public E higher(E e) {
            E result = this.descending ? super.lower(e) : super.higher(e);
            return result != null && this.checkInBounds(result) ? (E)result : null;
        }

        @Override
        public E pollFirst() {
            return this.descending ? this.doPollLast() : this.doPollFirst();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private E doPollFirst() {
            if (this.lowerBounded) {
                Object object = this.al.lock;
                synchronized (object) {
                    E remove;
                    E e = remove = this.lowerInclusive ? this.floor(this.lowerBound) : this.higher(this.lowerBound);
                    if (null != remove) {
                        super.remove(remove);
                    }
                    return remove;
                }
            }
            return super.pollFirst();
        }

        @Override
        public E pollLast() {
            return this.descending ? this.doPollFirst() : this.doPollLast();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private E doPollLast() {
            if (this.upperBounded) {
                Object object = this.al.lock;
                synchronized (object) {
                    E remove;
                    E e = remove = this.upperInclusive ? this.floor(this.upperBound) : this.lower(this.upperBound);
                    if (null != remove) {
                        super.remove(remove);
                    }
                    return remove;
                }
            }
            return super.pollLast();
        }

        @Override
        public E first() {
            return this.descending ? this.doLast() : this.doFirst();
        }

        private E doFirst() {
            E result;
            E e = result = this.lowerInclusive ? this.ceiling(this.lowerBound) : this.higher(this.lowerBound);
            if (null == result) {
                throw new NoSuchElementException();
            }
            return result;
        }

        @Override
        public E last() {
            return this.descending ? this.doFirst() : this.doLast();
        }

        private E doLast() {
            E result;
            E e = result = this.upperInclusive ? this.floor(this.upperBound) : this.lower(this.upperBound);
            if (null == result) {
                throw new NoSuchElementException();
            }
            return result;
        }

        @Override
        public Spliterator<E> spliterator() {
            Object[] array = this.al.getArray();
            return Spliterators.spliterator(array, this.fromLoc(array), this.toLoc(array), 1297);
        }
    }
}

