/*
 * Decompiled with CFR 0.152.
 */
package org.bkvm.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.bkvm.daemons.PidFileLocker;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;

public class ServerMain
implements AutoCloseable {
    private static ServerMain runningInstance;
    private static final Logger LOG;
    private static final CountDownLatch running;
    private final Properties configuration;
    private final PidFileLocker pidFileLocker;
    private Server httpserver;
    private boolean started;
    private String uiurl;

    public static void main(String ... args) {
        try {
            LOG.info("Starting BookKeeper Visual Manager");
            Properties configuration = new Properties();
            boolean configFileFromParameter = false;
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("-")) continue;
                File configFile = new File(args[i]).getAbsoluteFile();
                LOG.severe("Reading configuration from " + configFile);
                System.setProperty("bookkeeper.visual.manager.config.path", configFile.getAbsolutePath());
                try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                    configuration.load(reader);
                }
                configFileFromParameter = true;
            }
            if (!configFileFromParameter) {
                File configFile = new File("conf/server.properties").getAbsoluteFile();
                System.out.println("Reading configuration from " + configFile);
                System.setProperty("bookkeeper.visual.manager.config.path", configFile.getAbsolutePath());
                if (configFile.isFile()) {
                    try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8);){
                        configuration.load(reader);
                    }
                }
            }
            LogManager.getLogManager().readConfiguration();
            Runtime.getRuntime().addShutdownHook(new Thread("ctrlc-hook"){

                @Override
                public void run() {
                    System.out.println("Ctrl-C trapped. Shutting down");
                    ServerMain _brokerMain = runningInstance;
                    if (_brokerMain != null) {
                        _brokerMain.close();
                    }
                }
            });
            runningInstance = new ServerMain(configuration);
            runningInstance.start();
            runningInstance.join();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    public static ServerMain getRunningInstance() {
        return runningInstance;
    }

    public ServerMain(Properties configuration) {
        this.configuration = configuration;
        this.pidFileLocker = new PidFileLocker(Paths.get(System.getProperty("user.dir", "."), new String[0]).toAbsolutePath());
    }

    @Override
    public void close() {
        if (this.httpserver != null) {
            try {
                this.httpserver.stop();
            }
            catch (Exception ex) {
                Logger.getLogger(ServerMain.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                this.httpserver = null;
            }
        }
        this.pidFileLocker.close();
        running.countDown();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void join() {
        try {
            running.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.started = false;
    }

    public void start() throws Exception {
        this.pidFileLocker.lock();
        String httphost = this.configuration.getProperty("http.host", "localhost");
        int httpport = Integer.parseInt(this.configuration.getProperty("http.port", "4500"));
        this.httpserver = new Server(new InetSocketAddress(httphost, httpport));
        Configuration.ClassList classlist = Configuration.ClassList.setServerDefault((Server)this.httpserver);
        classlist.addAfter(FragmentConfiguration.class.getName(), new String[]{EnvConfiguration.class.getName(), PlusConfiguration.class.getName()});
        classlist.addBefore(JettyWebXmlConfiguration.class.getName(), new String[]{AnnotationConfiguration.class.getName()});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.httpserver.setHandler((Handler)contexts);
        WebAppContext webApp = new WebAppContext(new File("web").getAbsolutePath(), "/");
        contexts.addHandler((Handler)webApp);
        this.uiurl = "http://" + httphost + ":" + httpport + "/";
        System.out.println("Listening for client (http) connections on " + httphost + ":" + httpport);
        this.httpserver.start();
        System.out.println("Web Interface: " + this.uiurl);
        this.started = true;
    }

    public String getUiurl() {
        return this.uiurl;
    }

    static {
        LOG = Logger.getLogger(ServerMain.class.getName());
        running = new CountDownLatch(1);
    }
}

