/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.concurrent;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.bookkeeper.common.concurrent.FutureEventListener;
import org.apache.bookkeeper.common.stats.OpStatsListener;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FutureUtils {
    private static final Logger log = LoggerFactory.getLogger(FutureUtils.class);
    private static final Function<Throwable, Exception> DEFAULT_EXCEPTION_HANDLER = cause -> {
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        return new Exception((Throwable)cause);
    };

    private FutureUtils() {
    }

    public static CompletableFuture<Void> Void() {
        return FutureUtils.value(null);
    }

    public static <T> T result(CompletableFuture<T> future) throws Exception {
        return FutureUtils.result(future, DEFAULT_EXCEPTION_HANDLER);
    }

    public static <T> T result(CompletableFuture<T> future, long timeout, TimeUnit timeUnit) throws Exception {
        return FutureUtils.result(future, DEFAULT_EXCEPTION_HANDLER, timeout, timeUnit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, ExceptionT extends Throwable> T result(CompletableFuture<T> future, Function<Throwable, ExceptionT> exceptionHandler) throws ExceptionT {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
            catch (ExecutionException e2) {
                Throwable cause = (Throwable)exceptionHandler.apply(e2.getCause());
                if (null == cause) {
                    return null;
                }
                throw cause;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, ExceptionT extends Throwable> T result(CompletableFuture<T> future, Function<Throwable, ExceptionT> exceptionHandler, long timeout, TimeUnit timeUnit) throws ExceptionT, TimeoutException {
        try {
            return future.get(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
            catch (ExecutionException e2) {
                Throwable cause = (Throwable)exceptionHandler.apply(e2.getCause());
                if (null == cause) {
                    return null;
                }
                throw cause;
            }
        }
    }

    public static <T> CompletableFuture<T> createFuture() {
        return new CompletableFuture();
    }

    public static <T> CompletableFuture<T> value(T value) {
        return CompletableFuture.completedFuture(value);
    }

    public static <T> CompletableFuture<T> exception(Throwable cause) {
        CompletableFuture<T> future = FutureUtils.createFuture();
        future.completeExceptionally(cause);
        return future;
    }

    public static <T> void complete(CompletableFuture<T> result, T value) {
        if (null == result) {
            return;
        }
        result.complete(value);
    }

    public static <T> void completeExceptionally(CompletableFuture<T> result, Throwable cause) {
        if (null == result) {
            return;
        }
        result.completeExceptionally(cause);
    }

    public static <T> CompletableFuture<T> whenCompleteAsync(CompletableFuture<T> future, BiConsumer<? super T, ? super Throwable> action, OrderedScheduler scheduler, Object scheduleKey) {
        return future.whenCompleteAsync(action, (Executor)scheduler.chooseThread(scheduleKey));
    }

    public static <T> CompletableFuture<List<T>> collect(List<CompletableFuture<T>> futureList) {
        CompletableFuture<Void> finalFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()]));
        return finalFuture.thenApply(result -> futureList.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T> void proxyTo(CompletableFuture<T> src, CompletableFuture<T> target) {
        src.whenComplete((value, cause) -> {
            if (null == cause) {
                target.complete(value);
            } else {
                target.completeExceptionally((Throwable)cause);
            }
        });
    }

    public static <T, R> CompletableFuture<List<R>> processList(List<T> collection, Function<T, CompletableFuture<R>> processFunc, @Nullable ExecutorService callbackExecutor) {
        ListFutureProcessor<T, R> processor = new ListFutureProcessor<T, R>(collection, processFunc, callbackExecutor);
        if (null != callbackExecutor) {
            callbackExecutor.submit(processor);
        } else {
            processor.run();
        }
        return ((ListFutureProcessor)processor).promise;
    }

    public static <T> CompletableFuture<T> within(CompletableFuture<T> promise, long timeout, TimeUnit unit, Throwable cause, OrderedScheduler scheduler, Object key) {
        if (timeout < 0L || promise.isDone()) {
            return promise;
        }
        ScheduledFuture<?> task = scheduler.scheduleOrdered(key, () -> {
            if (!promise.isDone() && promise.completeExceptionally(cause)) {
                log.info("Raise exception", cause);
            }
        }, timeout, unit);
        promise.whenComplete((value, throwable) -> {
            if (!task.cancel(true)) {
                log.debug("Failed to cancel the timeout task");
            }
        });
        return promise;
    }

    public static <T> CompletableFuture<Void> ignore(CompletableFuture<T> future) {
        return FutureUtils.ignore(future, null);
    }

    public static <T> CompletableFuture<Void> ignore(CompletableFuture<T> future, final String errorMsg) {
        final CompletableFuture<Void> promise = new CompletableFuture<Void>();
        future.whenComplete((BiConsumer)new FutureEventListener<T>(){

            @Override
            public void onSuccess(T value) {
                promise.complete(null);
            }

            @Override
            public void onFailure(Throwable cause) {
                if (null != errorMsg) {
                    log.error(errorMsg, cause);
                }
                promise.complete(null);
            }
        });
        return promise;
    }

    public static <T> CompletableFuture<T> ensure(CompletableFuture<T> future, Runnable ensureBlock) {
        return future.whenComplete((value, cause) -> ensureBlock.run());
    }

    public static <T> CompletableFuture<T> rescue(CompletableFuture<T> future, Function<Throwable, CompletableFuture<T>> rescueFuc) {
        CompletableFuture result = FutureUtils.createFuture();
        future.whenComplete((value, cause) -> {
            if (null == cause) {
                result.complete(value);
                return;
            }
            FutureUtils.proxyTo((CompletableFuture)rescueFuc.apply((Throwable)cause), result);
        });
        return result;
    }

    public static <T> CompletableFuture<T> stats(CompletableFuture<T> result, OpStatsLogger opStatsLogger, Stopwatch stopwatch) {
        return result.whenComplete((BiConsumer)new OpStatsListener(opStatsLogger, stopwatch));
    }

    private static class ListFutureProcessor<T, R>
    implements FutureEventListener<R>,
    Runnable {
        private volatile boolean done = false;
        private final Iterator<T> itemsIter;
        private final Function<T, CompletableFuture<R>> processFunc;
        private final CompletableFuture<List<R>> promise;
        private final List<R> results;
        private final ExecutorService callbackExecutor;

        ListFutureProcessor(List<T> items, Function<T, CompletableFuture<R>> processFunc, ExecutorService callbackExecutor) {
            this.itemsIter = items.iterator();
            this.processFunc = processFunc;
            this.promise = new CompletableFuture();
            this.results = Lists.newArrayListWithExpectedSize((int)items.size());
            this.callbackExecutor = callbackExecutor;
        }

        @Override
        public void onSuccess(R value) {
            this.results.add(value);
            if (null == this.callbackExecutor) {
                this.run();
            } else {
                this.callbackExecutor.submit(this);
            }
        }

        @Override
        public void onFailure(Throwable cause) {
            this.done = true;
            if (null == this.callbackExecutor) {
                this.promise.completeExceptionally(cause);
            } else {
                this.callbackExecutor.submit(() -> this.promise.completeExceptionally(cause));
            }
        }

        @Override
        public void run() {
            if (this.done) {
                log.debug("ListFutureProcessor is interrupted.");
                return;
            }
            if (!this.itemsIter.hasNext()) {
                this.promise.complete(this.results);
                this.done = true;
                return;
            }
            this.processFunc.apply(this.itemsIter.next()).whenComplete((BiConsumer)this);
        }
    }
}

