/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import herddb.network.Channel;
import herddb.network.ChannelEventListener;
import herddb.network.netty.ClientInboundMessageHandler;
import herddb.network.netty.LocalServerRegistry;
import herddb.network.netty.LocalVMChannelAcceptor;
import herddb.network.netty.NettyChannel;
import herddb.network.netty.NetworkUtils;
import herddb.network.netty.ProtocolMessageDecoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;

public class NettyConnector {
    private static final Logger LOGGER = Logger.getLogger(NettyConnector.class.getName());

    public static Channel connect(String host, int port, boolean ssl, int connectTimeout, int socketTimeout, ChannelEventListener receiver, ExecutorService callbackExecutor, MultithreadEventLoopGroup networkGroup) throws IOException {
        try {
            InetSocketAddress inet = new InetSocketAddress(host, port);
            String hostAddress = NetworkUtils.getAddress(inet);
            LocalVMChannelAcceptor localVm = LocalServerRegistry.getLocalServer(hostAddress, port);
            if (localVm != null && socketTimeout <= 0) {
                return localVm.connect(host + ":" + port, receiver, callbackExecutor);
            }
            return NettyConnector.createNettyChannel(inet, host, port, ssl, connectTimeout, socketTimeout, receiver, callbackExecutor, networkGroup);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    public static Channel connectUsingNetwork(String host, int port, boolean ssl, int connectTimeout, int socketTimeout, ChannelEventListener receiver, ExecutorService callbackExecutor, MultithreadEventLoopGroup networkGroup) throws IOException, SSLException {
        try {
            InetSocketAddress inet = new InetSocketAddress(host, port);
            return NettyConnector.createNettyChannel(inet, host, port, ssl, connectTimeout, socketTimeout, receiver, callbackExecutor, networkGroup);
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    private static Channel createNettyChannel(SocketAddress address, final String host, final int port, final boolean ssl, int connectTimeout, final int socketTimeout, final ChannelEventListener receiver, final ExecutorService callbackExecutor, MultithreadEventLoopGroup networkGroup) throws IOException, SSLException, InterruptedException {
        if (networkGroup == null) {
            throw new IOException("Connection using network is disabled, cannot connect to " + host + ":" + port);
        }
        MultithreadEventLoopGroup group = networkGroup;
        final SslContext sslCtx = !ssl ? null : SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        Bootstrap b = new Bootstrap();
        final AtomicReference result = new AtomicReference();
        Class<? extends io.netty.channel.Channel> channelType = NettyConnector.detectChannelType(networkGroup);
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(channelType)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeout)).handler((ChannelHandler)new ChannelInitializer<io.netty.channel.Channel>(){

            public void initChannel(io.netty.channel.Channel ch) throws Exception {
                try {
                    NettyChannel channel = new NettyChannel(host + ":" + port, ch, callbackExecutor);
                    result.set(channel);
                    channel.setMessagesReceiver(receiver);
                    if (ssl) {
                        ch.pipeline().addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                    }
                    if (socketTimeout > 0) {
                        ch.pipeline().addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(socketTimeout));
                    }
                    ch.pipeline().addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
                    ch.pipeline().addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
                    ch.pipeline().addLast("messagedecoder", (ChannelHandler)new ProtocolMessageDecoder());
                    ch.pipeline().addLast(new ChannelHandler[]{new ClientInboundMessageHandler(channel)});
                }
                catch (Throwable t) {
                    LOGGER.log(Level.SEVERE, "error connecting", t);
                    ch.close();
                }
            }
        });
        LOGGER.log(Level.FINE, "connecting to {0}:{1} ssl={2} address={3}", new Object[]{host, port, ssl, address});
        b.connect(address).sync();
        NettyChannel nettyChannel = (NettyChannel)result.get();
        if (!nettyChannel.isValid()) {
            throw new IOException("returned channel is not valid");
        }
        return nettyChannel;
    }

    private static Class<? extends io.netty.channel.Channel> detectChannelType(MultithreadEventLoopGroup networkGroup) {
        if (networkGroup.getClass().getName().contains("EpollEventLoopGroup")) {
            return EpollSocketChannel.class;
        }
        return NioSocketChannel.class;
    }
}

