/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import herddb.network.SendResultCallback;
import herddb.network.netty.AbstractChannel;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NettyChannel
extends AbstractChannel {
    volatile Channel socket;
    protected final AtomicInteger unflushedWrites = new AtomicInteger();
    private static final Logger LOGGER = Logger.getLogger(NettyChannel.class.getName());

    public String toString() {
        return "NettyChannel{name=" + this.getName() + ", id=" + this.getId() + ", socket=" + this.socket + " pending " + this.pendingCallbacks() + " msgs}";
    }

    public NettyChannel(String name, Channel socket, ExecutorService callbackexecutor) {
        super(name, ((SocketChannel)socket).remoteAddress() + "", callbackexecutor);
        this.socket = socket;
    }

    @Override
    public void sendOneWayMessage(ByteBuf message, final SendResultCallback callback) {
        Channel _socket = this.socket;
        if (_socket == null || !_socket.isOpen()) {
            callback.messageSent(new Exception(this + " connection is closed"));
            return;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuilder dumper = new StringBuilder();
            ByteBufUtil.appendPrettyHexDump((StringBuilder)dumper, (ByteBuf)message);
            LOGGER.log(Level.FINEST, "Sending to {}: {}", new Object[]{_socket, dumper});
        }
        _socket.writeAndFlush((Object)message).addListener(new GenericFutureListener(){

            public void operationComplete(Future future) throws Exception {
                if (future.isSuccess()) {
                    callback.messageSent(null);
                } else {
                    LOGGER.log(Level.SEVERE, this + ": error " + future.cause(), future.cause());
                    callback.messageSent(future.cause());
                    NettyChannel.this.close();
                }
            }
        });
        this.unflushedWrites.incrementAndGet();
    }

    @Override
    public boolean isValid() {
        Channel _socket = this.socket;
        return _socket != null && _socket.isOpen() && !this.ioErrors;
    }

    @Override
    public boolean isLocalChannel() {
        return false;
    }

    @Override
    public void doClose() {
        if (this.socket != null) {
            try {
                this.socket.close().await();
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.socket = null;
            }
        }
    }

    public Channel getSocket() {
        return this.socket;
    }

    @Override
    protected String describeSocket() {
        return this.socket + "";
    }
}

