/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperClientStats;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerHandleAdv;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.client.api.CreateAdvBuilder;
import org.apache.bookkeeper.client.api.CreateBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.client.api.WriteAdvHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerCreateOp {
    static final Logger LOG = LoggerFactory.getLogger(LedgerCreateOp.class);
    final AsyncCallback.CreateCallback cb;
    LedgerMetadata metadata;
    LedgerHandle lh;
    long ledgerId = -1L;
    final Object ctx;
    final int ensembleSize;
    final int writeQuorumSize;
    final int ackQuorumSize;
    final Map<String, byte[]> customMetadata;
    final byte[] passwd;
    final BookKeeper bk;
    final BookKeeper.DigestType digestType;
    final EnumSet<WriteFlag> writeFlags;
    final long startTime;
    final OpStatsLogger createOpLogger;
    final BookKeeperClientStats clientStats;
    boolean adv = false;
    boolean generateLedgerId = true;

    LedgerCreateOp(BookKeeper bk, int ensembleSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx, Map<String, byte[]> customMetadata, EnumSet<WriteFlag> writeFlags, BookKeeperClientStats clientStats) {
        this.bk = bk;
        this.ensembleSize = ensembleSize;
        this.writeQuorumSize = writeQuorumSize;
        this.ackQuorumSize = ackQuorumSize;
        this.digestType = digestType;
        this.customMetadata = customMetadata;
        this.writeFlags = writeFlags;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
        this.startTime = MathUtils.nowInNano();
        this.createOpLogger = clientStats.getCreateOpLogger();
        this.clientStats = clientStats;
    }

    public void initiate() {
        LedgerMetadataBuilder metadataBuilder = LedgerMetadataBuilder.create().withEnsembleSize(this.ensembleSize).withWriteQuorumSize(this.writeQuorumSize).withAckQuorumSize(this.ackQuorumSize).withDigestType(this.digestType.toApiDigestType()).withPassword(this.passwd);
        if (this.customMetadata != null) {
            metadataBuilder.withCustomMetadata(this.customMetadata);
        }
        if (this.bk.getConf().getStoreSystemtimeAsLedgerCreationTime()) {
            metadataBuilder.withCreationTime(System.currentTimeMillis()).storingCreationTime(true);
        }
        try {
            List<BookieId> ensemble = this.bk.getBookieWatcher().newEnsemble(this.ensembleSize, this.writeQuorumSize, this.ackQuorumSize, this.customMetadata);
            metadataBuilder.newEnsembleEntry(0L, ensemble);
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            LOG.error("Not enough bookies to create ledger");
            this.createComplete(e.getCode(), null);
            return;
        }
        if (this.generateLedgerId) {
            this.generateLedgerIdAndCreateLedger(metadataBuilder);
        } else {
            this.metadata = metadataBuilder.withId(this.ledgerId).build();
            this.bk.getLedgerManager().createLedgerMetadata(this.ledgerId, this.metadata).whenComplete((written, exception) -> this.metadataCallback((Versioned<LedgerMetadata>)written, (Throwable)exception, metadataBuilder));
        }
    }

    void generateLedgerIdAndCreateLedger(final LedgerMetadataBuilder metadataBuilder) {
        LedgerIdGenerator ledgerIdGenerator = this.bk.getLedgerIdGenerator();
        ledgerIdGenerator.generateLedgerId(new BookkeeperInternalCallbacks.GenericCallback<Long>(){

            @Override
            public void operationComplete(int rc, Long ledgerId) {
                if (0 != rc) {
                    LedgerCreateOp.this.createComplete(rc, null);
                    return;
                }
                LedgerCreateOp.this.ledgerId = ledgerId;
                LedgerCreateOp.this.metadata = metadataBuilder.withId(ledgerId).build();
                LedgerCreateOp.this.bk.getLedgerManager().createLedgerMetadata(ledgerId, LedgerCreateOp.this.metadata).whenComplete((written, exception) -> LedgerCreateOp.this.metadataCallback(written, exception, metadataBuilder));
            }
        });
    }

    public void initiateAdv(long ledgerId) {
        this.adv = true;
        this.ledgerId = ledgerId;
        if (this.ledgerId != -1L) {
            this.generateLedgerId = false;
        }
        this.initiate();
    }

    private void metadataCallback(Versioned<LedgerMetadata> writtenMetadata, Throwable exception, LedgerMetadataBuilder metadataBuilder) {
        if (exception != null) {
            if (this.generateLedgerId && BKException.getExceptionCode(exception) == -20) {
                this.generateLedgerIdAndCreateLedger(metadataBuilder);
            } else {
                this.createComplete(BKException.getExceptionCode(exception), null);
            }
        } else {
            try {
                this.lh = this.adv ? new LedgerHandleAdv(this.bk.getClientCtx(), this.ledgerId, writtenMetadata, this.digestType, this.passwd, this.writeFlags) : new LedgerHandle(this.bk.getClientCtx(), this.ledgerId, writtenMetadata, this.digestType, this.passwd, this.writeFlags);
            }
            catch (GeneralSecurityException e) {
                LOG.error("Security exception while creating ledger: " + this.ledgerId, (Throwable)e);
                this.createComplete(-4, null);
                return;
            }
            catch (NumberFormatException e) {
                LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
                this.createComplete(-14, null);
                return;
            }
            List<BookieId> curEns = this.lh.getLedgerMetadata().getEnsembleAt(0L);
            LOG.info("Ensemble: {} for ledger: {}", curEns, (Object)this.lh.getId());
            for (BookieId bsa : curEns) {
                this.clientStats.getEnsembleBookieDistributionCounter(bsa.toString()).inc();
            }
            this.createComplete(0, this.lh);
        }
    }

    private void createComplete(int rc, LedgerHandle lh) {
        if (0 != rc) {
            this.createOpLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.startTime), TimeUnit.NANOSECONDS);
        } else {
            this.createOpLogger.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.startTime), TimeUnit.NANOSECONDS);
        }
        this.cb.createComplete(rc, lh, this.ctx);
    }

    private static class CreateAdvBuilderImpl
    implements CreateAdvBuilder {
        private Long builderLedgerId;
        private final CreateBuilderImpl parent;

        private CreateAdvBuilderImpl(CreateBuilderImpl parent) {
            this.parent = parent;
        }

        @Override
        public CreateAdvBuilder withLedgerId(long ledgerId) {
            this.builderLedgerId = ledgerId;
            return this;
        }

        @Override
        public CompletableFuture<WriteAdvHandle> execute() {
            CompletableFuture<WriteAdvHandle> future = new CompletableFuture<WriteAdvHandle>();
            SyncCallbackUtils.SyncCreateAdvCallback callback = new SyncCallbackUtils.SyncCreateAdvCallback(future);
            this.create(callback);
            return future;
        }

        private boolean validate() {
            if (!this.parent.validate()) {
                return false;
            }
            if (this.builderLedgerId != null && this.builderLedgerId < 0L) {
                LOG.error("invalid ledgerId {} < 0. Do not set en explicit value if you want automatic generation", (Object)this.builderLedgerId);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create(AsyncCallback.CreateCallback cb) {
            if (!this.validate()) {
                cb.createComplete(-14, null, null);
                return;
            }
            LedgerCreateOp op = new LedgerCreateOp(this.parent.bk, this.parent.builderEnsembleSize, this.parent.builderWriteQuorumSize, this.parent.builderAckQuorumSize, BookKeeper.DigestType.fromApiDigestType(this.parent.builderDigestType), this.parent.builderPassword, cb, null, this.parent.builderCustomMetadata, this.parent.builderWriteFlags, this.parent.bk.getClientCtx().getClientStats());
            ReentrantReadWriteLock closeLock = this.parent.bk.getCloseLock();
            closeLock.readLock().lock();
            try {
                if (this.parent.bk.isClosed()) {
                    cb.createComplete(-19, null, null);
                    return;
                }
                op.initiateAdv(this.builderLedgerId == null ? -1L : this.builderLedgerId);
            }
            finally {
                closeLock.readLock().unlock();
            }
        }
    }

    public static class CreateBuilderImpl
    implements CreateBuilder {
        private final BookKeeper bk;
        private int builderEnsembleSize = 3;
        private int builderAckQuorumSize = 2;
        private int builderWriteQuorumSize = 2;
        private byte[] builderPassword;
        private EnumSet<WriteFlag> builderWriteFlags = WriteFlag.NONE;
        private DigestType builderDigestType = DigestType.CRC32;
        private Map<String, byte[]> builderCustomMetadata = Collections.emptyMap();

        CreateBuilderImpl(BookKeeper bk) {
            this.bk = bk;
        }

        @Override
        public CreateBuilder withEnsembleSize(int ensembleSize) {
            this.builderEnsembleSize = ensembleSize;
            return this;
        }

        @Override
        public CreateBuilder withWriteFlags(EnumSet<WriteFlag> writeFlags) {
            this.builderWriteFlags = writeFlags;
            return this;
        }

        @Override
        public CreateBuilder withWriteQuorumSize(int writeQuorumSize) {
            this.builderWriteQuorumSize = writeQuorumSize;
            return this;
        }

        @Override
        public CreateBuilder withAckQuorumSize(int ackQuorumSize) {
            this.builderAckQuorumSize = ackQuorumSize;
            return this;
        }

        @Override
        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        public CreateBuilder withPassword(byte[] password) {
            this.builderPassword = password;
            return this;
        }

        @Override
        public CreateBuilder withCustomMetadata(Map<String, byte[]> customMetadata) {
            this.builderCustomMetadata = customMetadata;
            return this;
        }

        @Override
        public CreateBuilder withDigestType(DigestType digestType) {
            this.builderDigestType = digestType;
            return this;
        }

        @Override
        public CreateAdvBuilder makeAdv() {
            return new CreateAdvBuilderImpl(this);
        }

        private boolean validate() {
            if (this.builderWriteFlags == null) {
                LOG.error("invalid null writeFlags");
                return false;
            }
            if (this.builderWriteQuorumSize > this.builderEnsembleSize) {
                LOG.error("invalid writeQuorumSize {} > ensembleSize {}", (Object)this.builderWriteQuorumSize, (Object)this.builderEnsembleSize);
                return false;
            }
            if (this.builderAckQuorumSize > this.builderWriteQuorumSize) {
                LOG.error("invalid ackQuorumSize {} > writeQuorumSize {}", (Object)this.builderAckQuorumSize, (Object)this.builderWriteQuorumSize);
                return false;
            }
            if (this.builderAckQuorumSize <= 0) {
                LOG.error("invalid ackQuorumSize {} <= 0", (Object)this.builderAckQuorumSize);
                return false;
            }
            if (this.builderPassword == null) {
                LOG.error("invalid null password");
                return false;
            }
            if (this.builderDigestType == null) {
                LOG.error("invalid null digestType");
                return false;
            }
            if (this.builderCustomMetadata == null) {
                LOG.error("invalid null customMetadata");
                return false;
            }
            return true;
        }

        @Override
        public CompletableFuture<WriteHandle> execute() {
            CompletableFuture<WriteHandle> future = new CompletableFuture<WriteHandle>();
            SyncCallbackUtils.SyncCreateCallback callback = new SyncCallbackUtils.SyncCreateCallback(future);
            this.create(callback);
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create(AsyncCallback.CreateCallback cb) {
            if (!this.validate()) {
                cb.createComplete(-14, null, null);
                return;
            }
            LedgerCreateOp op = new LedgerCreateOp(this.bk, this.builderEnsembleSize, this.builderWriteQuorumSize, this.builderAckQuorumSize, BookKeeper.DigestType.fromApiDigestType(this.builderDigestType), this.builderPassword, cb, null, this.builderCustomMetadata, this.builderWriteFlags, this.bk.getClientCtx().getClientStats());
            ReentrantReadWriteLock closeLock = this.bk.getCloseLock();
            closeLock.readLock().lock();
            try {
                if (this.bk.isClosed()) {
                    cb.createComplete(-19, null, null);
                    return;
                }
                op.initiate();
            }
            finally {
                closeLock.readLock().unlock();
            }
        }
    }
}

