/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc.utils;

import herddb.client.HDBException;
import java.sql.SQLException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.concurrent.CompletionException;

public class SQLExceptionUtils {
    public static SQLException wrapException(Throwable exception) {
        SQLException res;
        while (exception instanceof CompletionException) {
            exception = exception.getCause();
        }
        if (exception instanceof HDBException && exception.getCause() instanceof SQLIntegrityConstraintViolationException) {
            res = new SQLIntegrityConstraintViolationException(exception.getMessage());
        } else if (exception instanceof HDBException) {
            HDBException ex = (HDBException)exception;
            res = new SQLException(ex.getMessage(), ex);
        } else {
            res = new SQLException(exception);
        }
        return res;
    }
}

