/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.client.ClientSideMetadataProviderException;
import herddb.client.DMLResult;
import herddb.client.HDBException;
import herddb.client.ScanResultSet;
import herddb.jdbc.HerdDBConnection;
import herddb.jdbc.HerdDBResultSet;
import herddb.jdbc.HerdDBStatement;
import herddb.jdbc.PreparedStatementAsync;
import herddb.jdbc.utils.SQLExceptionUtils;
import herddb.utils.FileUtils;
import herddb.utils.VisibleByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class HerdDBPreparedStatement
extends HerdDBStatement
implements PreparedStatementAsync {
    private final String sql;
    private final List<Object> parameters = new ArrayList<Object>();
    private final List<List<Object>> batch = new ArrayList<List<Object>>();
    private final boolean returnValues;

    public HerdDBPreparedStatement(HerdDBConnection parent, String sql, boolean returnValues) {
        super(parent);
        this.sql = sql;
        this.returnValues = returnValues;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            this.parent.discoverTableSpace(this.sql);
            ScanResultSet scanResult = this.parent.getConnection().executeScan(this.parent.getTableSpace(), this.sql, true, this.parameters, this.parent.ensureTransaction(), this.maxRows, this.fetchSize, this.parent.isKeepReadLocks());
            this.parent.bindToTransaction(scanResult.transactionId);
            this.lastResultSet = new HerdDBResultSet(scanResult, this);
            return this.lastResultSet;
        }
        catch (ClientSideMetadataProviderException | HDBException | InterruptedException ex) {
            throw SQLExceptionUtils.wrapException(ex);
        }
    }

    private void ensureParameterPos(int index) {
        while (this.parameters.size() < index) {
            this.parameters.add(null);
        }
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, null);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setInt(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, Float.valueOf(x));
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.setDouble(parameterIndex, x.doubleValue());
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            this.setTimestamp(parameterIndex, new Timestamp(x.getTime()));
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            this.setTimestamp(parameterIndex, new Timestamp(x.getTime()));
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(x, StandardCharsets.US_ASCII), length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(x, StandardCharsets.UTF_8), length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    public boolean execute() throws SQLException {
        if (EXPECTS_RESULTSET.matcher(this.sql).matches()) {
            this.executeQuery();
            this.moreResults = true;
            return true;
        }
        this.executeLargeUpdate();
        this.moreResults = false;
        return false;
    }

    @Override
    public void addBatch() throws SQLException {
        this.batch.add(new ArrayList<Object>(this.parameters));
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            int[] results = new int[this.batch.size()];
            int i = 0;
            this.lastUpdateCount = 0L;
            this.parent.discoverTableSpace(this.sql);
            List dmlresults = this.parent.getConnection().executeUpdates(this.parent.getTableSpace(), this.sql, this.parent.ensureTransaction(), false, true, this.batch);
            for (DMLResult dmlresult : dmlresults) {
                results[i++] = (int)dmlresult.updateCount;
                this.parent.bindToTransaction(dmlresult.transactionId);
                this.lastUpdateCount += dmlresult.updateCount;
                this.lastKey = dmlresult.key;
            }
            Object object = results;
            return object;
        }
        catch (ClientSideMetadataProviderException | HDBException err) {
            throw SQLExceptionUtils.wrapException(err);
        }
        finally {
            this.batch.clear();
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batch.clear();
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw new SQLException("setRef is not supported yet");
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setBinaryStream(parameterIndex, x.getBinaryStream());
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setCharacterStream(parameterIndex, x.getCharacterStream());
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        throw new SQLException("setArray is not supported yet");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("Not supported yet.");
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            this.setTimestamp(parameterIndex, new Timestamp(x.getTime()), cal);
        }
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, 93);
        } else {
            this.setTimestamp(parameterIndex, new Timestamp(x.getTime()), cal);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, null);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setString(parameterIndex, x.toString());
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new ParameterMetaData(){

            @Override
            public int getParameterCount() throws SQLException {
                return (int)HerdDBPreparedStatement.this.sql.chars().filter(ch -> ch == 63).count();
            }

            @Override
            public int isNullable(int param) throws SQLException {
                return 2;
            }

            @Override
            public boolean isSigned(int param) throws SQLException {
                return true;
            }

            @Override
            public int getPrecision(int param) throws SQLException {
                return 0;
            }

            @Override
            public int getScale(int param) throws SQLException {
                return 0;
            }

            @Override
            public int getParameterType(int param) throws SQLException {
                return 1111;
            }

            @Override
            public String getParameterTypeName(int param) throws SQLException {
                return "object";
            }

            @Override
            public String getParameterClassName(int param) throws SQLException {
                return Object.class.getName();
            }

            @Override
            public int getParameterMode(int param) throws SQLException {
                return 1;
            }

            @Override
            public <T> T unwrap(Class<T> iface) throws SQLException {
                return (T)this;
            }

            @Override
            public boolean isWrapperFor(Class<?> iface) throws SQLException {
                return false;
            }
        };
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw new SQLException("setRowId not supported yet.");
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setNCharacterStream(parameterIndex, value.getCharacterStream());
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setNCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setNCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setNCharacterStream(parameterIndex, xmlObject.getCharacterStream());
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureParameterPos(parameterIndex);
        this.parameters.set(parameterIndex - 1, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, (Reader)new InputStreamReader(x, StandardCharsets.US_ASCII), length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        if (length >= Integer.MAX_VALUE) {
            throw new SQLException("Cannot send a byte[] larger than 2147483647");
        }
        try {
            VisibleByteArrayOutputStream out = new VisibleByteArrayOutputStream((int)length);
            long writtenCount = FileUtils.copyStreams((InputStream)x, (OutputStream)out, (long)length);
            if (writtenCount != length) {
                throw new SQLException("The supplied inputstream returned only " + writtenCount + " bytes, exptected " + length);
            }
            this.setBytes(parameterIndex, out.toByteArrayNoCopy());
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        if (length >= Integer.MAX_VALUE) {
            throw new SQLException("Cannot handle a value larger that 2147483647 chars");
        }
        try {
            CharBuffer buffer = CharBuffer.allocate((int)length);
            int readCount = reader.read(buffer);
            if ((long)readCount != length) {
                throw new IOException("short read from " + reader + ", read " + readCount + " characters, expected " + length);
            }
            buffer.flip();
            this.setString(parameterIndex, buffer.toString());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setCharacterStream(parameterIndex, new InputStreamReader(x, StandardCharsets.US_ASCII));
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        try {
            VisibleByteArrayOutputStream out = new VisibleByteArrayOutputStream();
            FileUtils.copyStreams((InputStream)x, (OutputStream)out);
            this.setBytes(parameterIndex, out.toByteArray());
        }
        catch (IOException ex) {
            throw new SQLException(ex);
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        try {
            int numCharsRead;
            char[] arr = new char[8192];
            StringBuilder buffer = new StringBuilder();
            while ((numCharsRead = reader.read(arr, 0, arr.length)) != -1) {
                buffer.append(arr, 0, numCharsRead);
            }
            this.setString(parameterIndex, buffer.toString());
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public void close() throws SQLException {
        this.parameters.clear();
        super.close();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.doExecuteLargeUpdateWithParameters(this.parameters, this.returnValues);
    }

    private long doExecuteLargeUpdateWithParameters(List<Object> actualParameters, boolean returnValues) throws SQLException {
        try {
            this.parent.discoverTableSpace(this.sql);
            DMLResult result = this.parent.getConnection().executeUpdate(this.parent.getTableSpace(), this.sql, this.parent.ensureTransaction(), returnValues, true, actualParameters);
            this.parent.bindToTransaction(result.transactionId);
            this.lastUpdateCount = result.updateCount;
            this.lastKey = result.key;
            return this.lastUpdateCount;
        }
        catch (ClientSideMetadataProviderException | HDBException err) {
            throw SQLExceptionUtils.wrapException(err);
        }
    }

    @Override
    public CompletableFuture<Long> executeLargeUpdateAsync() {
        return this.doExecuteLargeUpdateWithParametersAsync(this.parameters, this.returnValues);
    }

    @Override
    public CompletableFuture<Integer> executeUpdateAsync() {
        return this.doExecuteLargeUpdateWithParametersAsync(this.parameters, this.returnValues).thenApply(Number::intValue);
    }

    private CompletableFuture<Long> doExecuteLargeUpdateWithParametersAsync(List<Object> actualParameters, boolean returnValues) {
        long tx;
        CompletableFuture<Long> res = new CompletableFuture<Long>();
        this.lastUpdateCount = 0L;
        try {
            this.parent.discoverTableSpace(this.sql);
            tx = this.parent.ensureTransaction();
        }
        catch (SQLException err) {
            res.completeExceptionally(err);
            return res;
        }
        this.parent.getConnection().executeUpdateAsync(this.parent.getTableSpace(), this.sql, tx, returnValues, true, actualParameters).whenComplete((dmlres, error) -> {
            if (error != null) {
                res.completeExceptionally(SQLExceptionUtils.wrapException(error));
                return;
            }
            this.parent.bindToTransaction(dmlres.transactionId);
            this.lastUpdateCount = dmlres.updateCount;
            this.lastKey = dmlres.key;
            res.complete(dmlres.updateCount);
        });
        return res;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(PreparedStatementAsync.class)) {
            return (T)this;
        }
        return super.unwrap(clazz);
    }

    @Override
    public CompletableFuture<int[]> executeBatchAsync() {
        long tx;
        CompletableFuture<int[]> res = new CompletableFuture<int[]>();
        this.lastUpdateCount = 0L;
        try {
            this.parent.discoverTableSpace(this.sql);
            tx = this.parent.ensureTransaction();
        }
        catch (SQLException err) {
            res.completeExceptionally(err);
            return res;
        }
        this.parent.getConnection().executeUpdatesAsync(this.parent.getTableSpace(), this.sql, tx, false, true, this.batch).whenComplete((dmsresults, error) -> {
            if (error != null) {
                res.completeExceptionally(SQLExceptionUtils.wrapException(error));
            } else {
                int[] results = new int[this.batch.size()];
                int i = 0;
                for (DMLResult dmlresult : dmsresults) {
                    results[i++] = (int)dmlresult.updateCount;
                    this.parent.bindToTransaction(dmlresult.transactionId);
                    this.lastUpdateCount += dmlresult.updateCount;
                    this.lastKey = dmlresult.key;
                }
                res.complete(results);
            }
            this.batch.clear();
        });
        return res;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return true;
    }
}

