/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import herddb.client.ClientSideMetadataProviderException;
import herddb.client.HDBConnection;
import herddb.client.HDBException;
import herddb.jdbc.BasicHerdDBDataSource;
import herddb.jdbc.HerdDBDatabaseMetadata;
import herddb.jdbc.HerdDBPreparedStatement;
import herddb.jdbc.HerdDBStatement;
import herddb.jdbc.utils.SQLExceptionUtils;
import herddb.utils.QueryUtils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HerdDBConnection
implements Connection {
    private final HDBConnection connection;
    private long transactionId;
    private boolean autocommit = true;
    private String tableSpace;
    private final BasicHerdDBDataSource datasource;
    private boolean closed;
    private final ConcurrentHashMap<Long, HerdDBStatement> openStatements = new ConcurrentHashMap();
    private int transactionIsolation = 2;
    private static final Logger LOGGER = Logger.getLogger(HerdDBConnection.class.getName());
    private Properties clientInfo = new Properties();

    HerdDBConnection(BasicHerdDBDataSource datasource, HDBConnection connection, String defaultTablespace) throws SQLException {
        if (connection == null) {
            throw new NullPointerException();
        }
        this.connection = connection;
        this.datasource = datasource;
        this.reset(defaultTablespace);
    }

    final void reset(String defaultTablespace) {
        if (!this.openStatements.isEmpty()) {
            throw new IllegalStateException("Found open statements " + this.openStatements);
        }
        this.autocommit = true;
        this.tableSpace = defaultTablespace;
        this.transactionId = 0L;
        this.closed = false;
    }

    long ensureTransaction() throws SQLException {
        if (!this.autocommit && this.transactionId == 0L) {
            this.transactionId = -1L;
        }
        return this.transactionId;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public HDBConnection getConnection() {
        return this.connection;
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new HerdDBStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new HerdDBPreparedStatement(this, sql, false);
    }

    private PreparedStatement prepareStatement(String sql, boolean returnValues) throws SQLException {
        return new HerdDBPreparedStatement(this, sql, returnValues);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.autocommit == autoCommit) {
            return;
        }
        if (this.autocommit && !autoCommit) {
            this.autocommit = false;
            return;
        }
        if (!this.autocommit && autoCommit) {
            this.commit();
            this.autocommit = true;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autocommit;
    }

    @Override
    public void commit() throws SQLException {
        if (this.autocommit) {
            throw new SQLException("connection is in autocommit mode");
        }
        if (this.transactionId == 0L || this.transactionId == -1L) {
            return;
        }
        this.ensureAllStatementClosed();
        try {
            this.connection.commitTransaction(this.tableSpace, this.transactionId);
        }
        catch (ClientSideMetadataProviderException | HDBException err) {
            throw SQLExceptionUtils.wrapException(err);
        }
        finally {
            this.transactionId = 0L;
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.autocommit) {
            throw new SQLException("connection is not in autocommit mode");
        }
        if (this.transactionId == 0L || this.transactionId == -1L) {
            return;
        }
        this.ensureAllStatementClosed();
        try {
            this.connection.rollbackTransaction(this.tableSpace, this.transactionId);
        }
        catch (ClientSideMetadataProviderException | HDBException err) {
            throw SQLExceptionUtils.wrapException(err);
        }
        finally {
            this.transactionId = 0L;
        }
    }

    private void ensureAllStatementClosed() throws SQLException {
        for (HerdDBStatement ps : this.openStatements.values()) {
            LOGGER.log(Level.FINE, "closing abandoned statement {0}", ps);
            try {
                ps.close();
            }
            catch (SQLException err) {
                LOGGER.log(Level.SEVERE, "Cannot close an open statement", err);
            }
        }
        this.openStatements.clear();
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.ensureAllStatementClosed();
        if (this.transactionId != 0L && this.transactionId != -1L) {
            this.rollback();
        }
        this.closed = true;
        this.datasource.releaseConnection(this);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed || this.connection.isClosed();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new HerdDBDatabaseMetadata(this, this.tableSpace, this.datasource.getUrl(), this.datasource.getUsername());
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level != 2 && level != 4) {
            LOGGER.log(Level.SEVERE, "Warning, ignoring setTransactionIsolation {0}, only TRANSACTION_READ_COMMITTED and TRANSACTION_REPEATABLE_READ are supported", level);
        }
        this.transactionIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.transactionIsolation;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Not supported yet.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql, autoGeneratedKeys == 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql, columnIndexes != null && columnIndexes.length > 0);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql, columnNames != null && columnNames.length > 0);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.clientInfo.put(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo.putAll((Map<?, ?>)properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (this.transactionId > 0L && !Objects.equals(schema, this.tableSpace)) {
            throw new SQLException("cannot switch to schema " + schema + ", transaction (ID " + this.transactionId + ") is already started on tableSpace " + this.tableSpace);
        }
        this.tableSpace = schema;
    }

    @Override
    public String getSchema() throws SQLException {
        return this.tableSpace;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String toString() {
        return "HerdDBConnection{connection=" + this.connection + ", transactionId=" + this.transactionId + ", autocommit=" + this.autocommit + ", tableSpace=" + this.tableSpace + '}';
    }

    void discoverTableSpace(String sql) throws SQLException {
        this.setSchema(QueryUtils.discoverTablespace((String)this.tableSpace, (String)sql));
    }

    void releaseStatement(HerdDBStatement statement) {
        this.openStatements.remove(statement.getId());
    }

    void bindToTransaction(long transactionId) {
        this.transactionId = transactionId;
    }

    void registerOpenStatement(HerdDBStatement statement) {
        this.openStatements.put(statement.getId(), statement);
    }

    boolean isKeepReadLocks() {
        return this.transactionIsolation == 4;
    }

    long getTransactionId() {
        return this.transactionId;
    }
}

