/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import herddb.jdbc.BasicHerdDBDataSource;
import herddb.jdbc.HerdDBConnection;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

class ConnectionsPoolRuntime {
    private final BasicHerdDBDataSource parent;
    private final GenericObjectPool<HerdDBConnection> pool;

    public ConnectionsPoolRuntime(BasicHerdDBDataSource parent) {
        this.parent = parent;
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setBlockWhenExhausted(true);
        int maxActive = parent.getMaxActive();
        config.setMaxTotal(parent.getMaxActive());
        config.setMaxIdle(maxActive);
        config.setMinIdle(maxActive / 2);
        config.setJmxNamePrefix("HerdDBClient");
        this.pool = new GenericObjectPool((PooledObjectFactory)new ConnectionsFactory(), config);
    }

    HerdDBConnection borrowObject() throws Exception {
        return (HerdDBConnection)this.pool.borrowObject();
    }

    void returnObject(HerdDBConnection connection) {
        this.pool.returnObject((Object)connection);
    }

    private final class ConnectionsFactory
    implements PooledObjectFactory<HerdDBConnection> {
        private ConnectionsFactory() {
        }

        public PooledObject<HerdDBConnection> makeObject() throws Exception {
            HerdDBConnection res = ConnectionsPoolRuntime.this.parent.makeConnection();
            return new DefaultPooledObject((Object)res);
        }

        public void destroyObject(PooledObject<HerdDBConnection> po) throws Exception {
            ((HerdDBConnection)po.getObject()).close();
        }

        public boolean validateObject(PooledObject<HerdDBConnection> po) {
            return true;
        }

        public void activateObject(PooledObject<HerdDBConnection> po) throws Exception {
            ((HerdDBConnection)po.getObject()).reset(ConnectionsPoolRuntime.this.parent.getDefaultSchema());
        }

        public void passivateObject(PooledObject<HerdDBConnection> po) throws Exception {
        }
    }
}

