/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.client.ClientConfiguration;
import herddb.client.ClientSideMetadataProviderException;
import herddb.client.HDBClient;
import herddb.client.HDBConnection;
import herddb.client.HDBException;
import herddb.jdbc.ConnectionsPoolRuntime;
import herddb.jdbc.HerdDBConnection;
import herddb.utils.QueryParser;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class BasicHerdDBDataSource
implements DataSource,
AutoCloseable,
Closeable {
    protected HDBClient client;
    protected final Properties properties = new Properties();
    protected int loginTimeout;
    protected int maxActive = 200;
    private boolean autoClose;
    private final AtomicInteger activeCount = new AtomicInteger();
    private Consumer<BasicHerdDBDataSource> onAutoClose = BasicHerdDBDataSource::close;
    private static final Logger LOGGER = Logger.getLogger(BasicHerdDBDataSource.class.getName());
    protected String url;
    protected String defaultSchema = "herd";
    private String waitForTableSpace = "";
    private int waitForTableSpaceTimeout = 60000;
    private boolean discoverTableSpaceFromQuery = true;
    private HDBConnection connection;
    private boolean poolConnections = true;
    private ConnectionsPoolRuntime poolRuntime;
    private PrintWriter logWriter;

    private synchronized HDBConnection getHDBConnection() {
        if (this.connection == null) {
            HDBClient _client = this.getClient();
            HDBConnection _connection = _client.openConnection();
            _connection.setDiscoverTablespaceFromSql(false);
            this.connection = _connection;
        }
        return this.connection;
    }

    public synchronized int getWaitForTableSpaceTimeout() {
        return this.waitForTableSpaceTimeout;
    }

    public synchronized void setWaitForTableSpaceTimeout(int waitForTableSpaceTimeout) {
        this.waitForTableSpaceTimeout = waitForTableSpaceTimeout;
    }

    public synchronized String getWaitForTableSpace() {
        return this.waitForTableSpace;
    }

    public synchronized void setWaitForTableSpace(String waitForTableSpace) {
        this.waitForTableSpace = waitForTableSpace;
    }

    public synchronized boolean isDiscoverTableSpaceFromQuery() {
        return this.discoverTableSpaceFromQuery;
    }

    public synchronized void setDiscoverTableSpaceFromQuery(boolean discoverTableSpaceFromQuery) {
        this.discoverTableSpaceFromQuery = discoverTableSpaceFromQuery;
    }

    protected BasicHerdDBDataSource() {
    }

    public BasicHerdDBDataSource(HDBClient client) {
        if (client == null) {
            throw new NullPointerException();
        }
        this.client = client;
    }

    public synchronized int getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public synchronized String getUsername() {
        if (this.client != null) {
            return this.client.getConfiguration().getString("user", "sa");
        }
        return this.properties.getProperty("user", "sa");
    }

    public synchronized void setUsername(String username) {
        this.properties.put("user", username);
        if (this.client != null) {
            this.client.getConfiguration().set("user", (Object)username);
        }
    }

    public synchronized String getPassword() {
        if (this.client != null) {
            return this.client.getConfiguration().getString("password", "hdb");
        }
        return this.properties.getProperty("password", "hdb");
    }

    public synchronized void setPassword(String password) {
        this.properties.put("password", password);
        if (this.client != null) {
            this.client.getConfiguration().set("password", (Object)password);
        }
    }

    public synchronized String getUrl() {
        return this.url;
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"})
    public synchronized void setUrl(String url) {
        this.url = url;
        if (this.client != null) {
            this.client.getConfiguration().set("client.initialized", (Object)"true");
        }
        QueryParser.parseQueryKeyPairs((String)url).forEach(pair -> {
            if (pair[0].startsWith("client.") && this.client != null) {
                this.client.getConfiguration().set(pair[0], (Object)pair[1]);
            } else {
                this.properties.setProperty(pair[0], pair[1]);
            }
        });
    }

    public synchronized boolean isPoolConnections() {
        return this.poolConnections;
    }

    public synchronized void setPoolConnections(boolean poolConnections) {
        if (this.client != null || this.poolRuntime != null) {
            throw new IllegalStateException("Cannot set poolConections=" + poolConnections + " once bootstrap is completed");
        }
        this.poolConnections = poolConnections;
    }

    public Properties getProperties() {
        return this.properties;
    }

    protected synchronized void doWaitForTableSpace() throws SQLException {
        if (this.waitForTableSpaceTimeout > 0 && !this.waitForTableSpace.isEmpty()) {
            try (HDBConnection con = this.client.openConnection();){
                con.waitForTableSpace(this.waitForTableSpace, this.waitForTableSpaceTimeout);
            }
            catch (ClientSideMetadataProviderException | HDBException err) {
                throw new SQLException(err);
            }
        }
    }

    protected synchronized void ensureClient() throws SQLException {
        if (this.client == null) {
            ClientConfiguration clientConfiguration = new ClientConfiguration(this.properties);
            Properties propsNoPassword = new Properties();
            propsNoPassword.putAll((Map<?, ?>)this.properties);
            propsNoPassword.setProperty("password", "---");
            LOGGER.log(Level.INFO, "Booting HerdDB Client, url:" + this.url + ", properties:" + propsNoPassword + " clientConfig " + clientConfiguration);
            try {
                clientConfiguration.readJdbcUrl(this.url);
            }
            catch (RuntimeException err) {
                throw new SQLException(err);
            }
            this.autoClose = clientConfiguration.getBoolean("autoClose", this.isAutoClose());
            if (this.properties.containsKey("discoverTableSpaceFromQuery")) {
                this.discoverTableSpaceFromQuery = clientConfiguration.getBoolean("discoverTableSpaceFromQuery", true);
            }
            this.properties.stringPropertyNames().stream().filter(it -> it.startsWith("client.")).forEach(key -> clientConfiguration.set(key, (Object)this.properties.getProperty((String)key)));
            this.client = new HDBClient(clientConfiguration);
        }
        if (this.poolRuntime == null) {
            this.poolConnections = Boolean.parseBoolean(this.properties.getProperty("poolConnections", this.poolConnections + ""));
            if (this.properties.containsKey("maxActive")) {
                this.maxActive = Integer.parseInt(this.properties.getProperty("maxActive", this.maxActive + ""));
            }
            this.poolRuntime = !this.poolConnections ? null : new ConnectionsPoolRuntime(this);
        }
    }

    protected synchronized void ensureConnection() throws SQLException {
        this.ensureClient();
    }

    public synchronized HDBClient getClient() {
        return this.client;
    }

    public synchronized void setClient(HDBClient client) {
        this.client = client;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    HerdDBConnection makeConnection() throws SQLException {
        return new HerdDBConnection(this, this.getHDBConnection(), this.defaultSchema);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.ensureConnection();
        try {
            HerdDBConnection res = !this.isPoolConnections() ? this.makeConnection() : this.getPoolRuntime().borrowObject();
            this.activeCount.incrementAndGet();
            return res;
        }
        catch (Exception err) {
            throw new SQLException(err);
        }
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.logWriter = out;
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return LOGGER;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public synchronized boolean isAutoClose() {
        return this.autoClose;
    }

    public synchronized void setAutoClose(boolean autoClose) {
        this.autoClose = autoClose;
    }

    public synchronized void setOnAutoClose(Consumer<BasicHerdDBDataSource> onAutoClose) {
        this.onAutoClose = onAutoClose;
    }

    @Override
    public synchronized void close() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    void releaseConnection(HerdDBConnection connection) {
        if (this.isPoolConnections()) {
            this.getPoolRuntime().returnObject(connection);
        }
        if (this.activeCount.decrementAndGet() == 0) {
            this.performAutoClose();
        }
    }

    private synchronized void performAutoClose() {
        if (this.autoClose && this.onAutoClose != null) {
            this.onAutoClose.accept(this);
        }
    }

    public synchronized ConnectionsPoolRuntime getPoolRuntime() {
        return this.poolRuntime;
    }
}

