/*
 * Decompiled with CFR 0.152.
 */
package org.bkvm.daemons;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class PidFileLocker
implements AutoCloseable {
    private static final String PIDFILE = System.getProperty("pidfile", "");
    private final Path file;
    private final byte[] pid;
    private volatile boolean closed;
    private final ScheduledExecutorService timer = Executors.newSingleThreadScheduledExecutor(runnable -> {
        Thread thread = new Thread(runnable, "pid-file-locker");
        thread.setDaemon(true);
        return thread;
    });

    public PidFileLocker(Path basePath) {
        this.file = basePath.resolve(PIDFILE);
        String _pid = ManagementFactory.getRuntimeMXBean().getName();
        int choi = _pid.indexOf(64);
        _pid = _pid.substring(0, choi);
        System.out.println("Current process PID:" + _pid);
        this.pid = _pid.getBytes(StandardCharsets.UTF_8);
    }

    public void lock() throws IOException {
        if (PIDFILE.isEmpty()) {
            return;
        }
        System.out.println("Creating and locking file " + this.file.toAbsolutePath());
        if (Files.exists(this.file, new LinkOption[0])) {
            throw new IOException("file " + this.file.toAbsolutePath() + " already exists");
        }
        Files.write(this.file, this.pid, StandardOpenOption.CREATE_NEW);
        this.timer.scheduleWithFixedDelay(() -> {
            try {
                this.check();
            }
            catch (Exception err) {
                Runtime.getRuntime().halt(1);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public void check() throws Exception {
        byte[] actualContent;
        if (PIDFILE.isEmpty() || this.closed) {
            return;
        }
        if (!Files.isRegularFile(this.file, new LinkOption[0])) {
            System.out.println("Lock file " + this.file.toAbsolutePath() + " does not exists any more. stopping service");
            throw new Exception("Lock file " + this.file.toAbsolutePath() + " does not exists any more. stopping service");
        }
        try {
            actualContent = Files.readAllBytes(this.file);
        }
        catch (IOException err) {
            System.out.println("Lock file " + this.file.toAbsolutePath() + " cannot be read (" + err + "). stopping service");
            throw new Exception("Lock file " + this.file.toAbsolutePath() + " cannot be read (" + err + "). stopping service", err);
        }
        if (!Arrays.equals(this.pid, actualContent)) {
            System.out.println("Lock file " + this.file.toAbsolutePath() + " changed, now contains " + new String(actualContent, StandardCharsets.UTF_8) + ". stopping service");
            throw new Exception("Lock file " + this.file.toAbsolutePath() + " changed, now contains " + new String(actualContent, StandardCharsets.UTF_8) + ". stopping service");
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.timer.shutdown();
        if (PIDFILE.isEmpty()) {
            return;
        }
        try {
            Files.deleteIfExists(this.file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

