/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.Bytes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import net.jpountz.xxhash.StreamingXXHash64;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;

public class XXHash64Utils {
    private static final int DEFAULT_SEED = -1756908916;
    private static final XXHashFactory factory = XXHashFactory.fastestInstance();
    private static final XXHash64 HASHER = factory.hash64();
    private static final int HASH_LEN = 8;

    public static byte[] digest(byte[] array, int offset, int len) {
        long hash = HASHER.hash(array, offset, len, -1756908916L);
        byte[] digest = Bytes.longToByteArray(hash);
        return digest;
    }

    public static long hash(byte[] array, int offset, int len) {
        return HASHER.hash(array, offset, len, -1756908916L);
    }

    public static boolean verifyBlockWithFooter(byte[] array, int offset, int len) {
        byte[] expectedFooter = Arrays.copyOfRange(array, len - 8, len);
        long expectedHash = HASHER.hash(array, offset, len - 8, -1756908916L);
        long hash = Bytes.toLong(expectedFooter, 0);
        return hash == expectedHash;
    }

    public static final class HashingOutputStream
    extends OutputStream {
        private final StreamingXXHash64 hash;
        private final byte[] singleByteBuffer = new byte[1];
        private final OutputStream out;
        private long size;

        public HashingOutputStream(OutputStream in) {
            this.out = in;
            this.hash = factory.newStreamingHash64(-1756908916L);
        }

        @Override
        public void write(int b) throws IOException {
            this.singleByteBuffer[0] = (byte)b;
            this.hash.update(this.singleByteBuffer, 0, 1);
            this.out.write(b);
            ++this.size;
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.hash.update(b, off, len);
            this.out.write(b, off, len);
            this.size += (long)len;
        }

        @Override
        public void write(byte[] b) throws IOException {
            int len = b.length;
            this.hash.update(b, 0, len);
            this.out.write(b, 0, len);
            this.size += (long)len;
        }

        public long hash() {
            return this.hash.getValue();
        }

        public long size() {
            return this.size;
        }
    }

    public static final class HashingStream
    extends InputStream {
        private final StreamingXXHash64 hash;
        private final byte[] singleByteBuffer = new byte[1];
        private final InputStream in;

        public HashingStream(InputStream in) {
            this.in = in;
            this.hash = factory.newStreamingHash64(-1756908916L);
        }

        @Override
        public long skip(long n) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int res = this.in.read(b, off, len);
            if (res > 0) {
                this.hash.update(b, off, res);
            }
            return res;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int res = this.in.read(b);
            if (res > 0) {
                this.hash.update(b, 0, res);
            }
            return res;
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            if (result == -1) {
                return -1;
            }
            this.singleByteBuffer[0] = (byte)result;
            this.hash.update(this.singleByteBuffer, 0, 1);
            return result;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void reset() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void mark(int readlimit) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        public long hash() {
            return this.hash.getValue();
        }
    }
}

