/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.ExtendedDataInputStream;
import herddb.utils.ExtendedDataOutputStream;
import herddb.utils.SimpleBufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;

public final class DiskArrayList<T>
implements AutoCloseable,
Iterable<T> {
    private ArrayList<T> buffer = new ArrayList();
    private boolean swapped = false;
    private final int swapThreshold;
    private boolean compressionEnabled = false;
    private final Serializer<T> serializer;
    private boolean closed;
    private static final int DISK_BUFFER_SIZE = 131072;
    private OutputStream out;
    private SimpleBufferedOutputStream bout;
    private OutputStream zippedout;
    private ExtendedDataOutputStream oout;
    private InputStream in;
    private BufferedInputStream bin;
    private ExtendedDataInputStream oin;
    private InputStream zippedin;
    private Path tmpFile;
    private boolean writing;
    private boolean written;
    private int size;
    private int countread;
    private static final Logger logger = Logger.getLogger(DiskArrayList.class.getName());
    private final Path tmpDir;

    public void enableCompression() {
        if (this.swapped) {
            throw new RuntimeException("list already swapped, cannot enable compression now");
        }
        this.compressionEnabled = true;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.closed) {
            throw new IllegalArgumentException("this DiskArrayList has been closed");
        }
        if (!this.written) {
            throw new IllegalArgumentException("call finish() before read operations");
        }
        if (this.swapped) {
            return new Reader();
        }
        return this.buffer.iterator();
    }

    public void add(T summary) {
        try {
            ++this.size;
            if (this.size > this.swapThreshold && !this.swapped) {
                this.startWrite();
            }
            if (!this.swapped) {
                this.buffer.add(summary);
            } else {
                this.serializer.write(summary, this.oout);
            }
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public boolean isSwapped() {
        return this.swapped;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public void sortBuffer(Comparator<T> comparator) {
        if (!this.written) {
            throw new IllegalArgumentException("call finish() before sort operations");
        }
        if (this.isSwapped()) {
            throw new IllegalStateException();
        }
        this.buffer.sort(comparator);
    }

    public void finish() {
        this.closeWriter();
    }

    public DiskArrayList(int swapThreshold, Path tmpDir, Serializer<T> serializer) {
        this.swapThreshold = swapThreshold;
        this.tmpDir = tmpDir;
        this.serializer = serializer;
    }

    @Override
    public void close() {
        this.closeWriter();
        this.closeReader();
        if (this.tmpFile != null) {
            logger.log(Level.FINER, "destroy tmp swap file {0}", this.tmpFile);
            try {
                Files.deleteIfExists(this.tmpFile);
            }
            catch (IOException error) {
                logger.log(Level.SEVERE, "cannot delete tmp swap file {0}: " + error, this.tmpDir);
            }
            this.tmpFile = null;
        }
        this.written = false;
        this.swapped = false;
        this.closed = true;
    }

    private void startWrite() throws IOException {
        this.swapped = true;
        this.openWriter();
        for (T record : this.buffer) {
            this.serializer.write(record, this.oout);
        }
        this.buffer.clear();
        this.buffer = null;
    }

    public void truncate(int size) {
        if (size > 0 && this.size > size) {
            this.size = size;
            if (!this.swapped) {
                this.buffer = new ArrayList<T>(this.buffer.subList(0, size));
            }
        }
    }

    private void openReader() {
        if (!this.written) {
            throw new IllegalStateException("prima bisogna riempire la lista e chiamare finish()");
        }
        if (this.writing) {
            throw new IllegalStateException("scrittura ancora in corso");
        }
        if (!this.swapped) {
            throw new IllegalStateException("scrittura non avvenuta");
        }
        if (this.in != null) {
            this.closeReader();
        }
        try {
            this.in = Files.newInputStream(this.tmpFile, new OpenOption[0]);
            this.bin = new BufferedInputStream(this.in, 131072);
            if (this.compressionEnabled) {
                this.zippedin = new LZ4BlockInputStream((InputStream)this.bin);
                this.oin = new ExtendedDataInputStream(this.zippedin);
            } else {
                this.oin = new ExtendedDataInputStream(this.bin);
            }
            this.countread = 0;
        }
        catch (IOException err) {
            this.closeReader();
            throw new RuntimeException(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeReader() {
        if (this.oin != null) {
            try {
                this.oin.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.oin = null;
            }
        }
        if (this.zippedin != null) {
            try {
                this.zippedin.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.zippedin = null;
            }
        }
        if (this.bin != null) {
            try {
                this.bin.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bin = null;
            }
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.in = null;
            }
        }
    }

    private void openWriter() throws IOException {
        if (this.written) {
            throw new IllegalStateException("list is already closed");
        }
        if (this.writing) {
            throw new IllegalStateException("already writing on this list");
        }
        this.tmpFile = this.compressionEnabled ? Files.createTempFile(this.tmpDir, "listswap", ".tmp.gz", new FileAttribute[0]) : Files.createTempFile(this.tmpDir, "listswap", ".tmp", new FileAttribute[0]);
        logger.log(Level.FINE, "opening tmp swap file {0}", this.tmpFile.toAbsolutePath());
        this.writing = true;
        try {
            this.out = Files.newOutputStream(this.tmpFile, new OpenOption[0]);
            this.bout = new SimpleBufferedOutputStream(this.out, 131072);
            if (this.compressionEnabled) {
                this.zippedout = new LZ4BlockOutputStream(this.out);
                this.oout = new ExtendedDataOutputStream(this.zippedout);
            } else {
                this.oout = new ExtendedDataOutputStream(this.bout);
            }
        }
        catch (IOException ex) {
            this.closeWriter();
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWriter() {
        this.writing = false;
        this.written = true;
        if (this.oout != null) {
            try {
                this.oout.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.oout = null;
            }
        }
        if (this.zippedout != null) {
            try {
                this.zippedout.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.zippedout = null;
            }
        }
        if (this.bout != null) {
            try {
                this.bout.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.bout = null;
            }
        }
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.out = null;
            }
        }
    }

    public static interface Serializer<T> {
        public T read(ExtendedDataInputStream var1) throws IOException;

        public void write(T var1, ExtendedDataOutputStream var2) throws IOException;
    }

    private class Reader
    implements Iterator<T> {
        public Reader() {
            DiskArrayList.this.openReader();
        }

        @Override
        public boolean hasNext() {
            return DiskArrayList.this.countread < DiskArrayList.this.size;
        }

        @Override
        public T next() {
            try {
                DiskArrayList.this.countread++;
                Object res = DiskArrayList.this.serializer.read(DiskArrayList.this.oin);
                if (DiskArrayList.this.countread == DiskArrayList.this.size) {
                    DiskArrayList.this.closeReader();
                }
                return res;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

