/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.AbstractDataAccessor;
import herddb.utils.AllNullsDataAccessor;
import herddb.utils.Constants;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public interface DataAccessor {
    public static final DataAccessor NULL = new AbstractDataAccessor(){

        @Override
        public void forEach(BiConsumer<String, Object> consumer) {
        }

        @Override
        public Object get(int index) {
            return null;
        }

        @Override
        public boolean fieldEqualsTo(int index, Object value) {
            return false;
        }

        @Override
        public boolean fieldNotEqualsTo(int index, Object value) {
            return false;
        }

        @Override
        public SQLRecordPredicateFunctions.CompareResult fieldCompareTo(int index, Object value) {
            return SQLRecordPredicateFunctions.CompareResult.NULL;
        }

        @Override
        public Object[] getValues() {
            return Constants.EMPTY_OBJECT_ARRAY;
        }

        @Override
        public Object get(String property) {
            return null;
        }

        @Override
        public Map<String, Object> toMap() {
            return Collections.emptyMap();
        }

        @Override
        public String[] getFieldNames() {
            return Constants.EMPTY_STRING_ARRAY;
        }
    };

    public Object get(String var1);

    default public Map<String, Object> toMap() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        this.forEach(res::put);
        return res;
    }

    public String[] getFieldNames();

    default public int getNumFields() {
        return this.getFieldNames().length;
    }

    default public void forEach(BiConsumer<String, Object> consumer) {
        for (String property : this.getFieldNames()) {
            consumer.accept(property, this.get(property));
        }
    }

    default public Object get(int index) {
        return this.get(this.getFieldNames()[index]);
    }

    default public boolean fieldEqualsTo(int index, Object value) {
        Object val = this.get(index);
        if (val == null) {
            return false;
        }
        return SQLRecordPredicateFunctions.objectEquals(val, value);
    }

    default public boolean fieldNotEqualsTo(int index, Object value) {
        Object val = this.get(index);
        if (val == null) {
            return false;
        }
        return SQLRecordPredicateFunctions.objectNotEquals(val, value);
    }

    default public SQLRecordPredicateFunctions.CompareResult fieldCompareTo(int index, Object value) {
        Object val = this.get(index);
        if (val == null) {
            return SQLRecordPredicateFunctions.CompareResult.NULL;
        }
        return SQLRecordPredicateFunctions.compareConsiderNull(val, value);
    }

    default public Object[] getValues() {
        String[] fieldNames = this.getFieldNames();
        Object[] result = new Object[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = this.get(fieldNames[i]);
        }
        return result;
    }

    public static DataAccessor ALL_NULLS(String[] fieldNames) {
        return new AllNullsDataAccessor(fieldNames);
    }
}

