/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;

public final class ContextClassLoaderAwareObjectInputStream
extends ObjectInputStream {
    public ContextClassLoaderAwareObjectInputStream(InputStream in) throws IOException {
        super(in);
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        try {
            return Class.forName(desc.getName(), false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return super.resolveClass(desc);
        }
    }
}

