/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.utils.Bytes;
import herddb.utils.RawString;
import io.netty.util.Recycler;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;

@SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"})
public class ByteArrayCursor
implements Closeable {
    private static final Recycler<ByteArrayCursor> RECYCLER = new Recycler<ByteArrayCursor>(){

        protected ByteArrayCursor newObject(Recycler.Handle<ByteArrayCursor> handle) {
            return new ByteArrayCursor(handle);
        }
    };
    private final Recycler.Handle<ByteArrayCursor> handle;
    private byte[] array;
    private int position;
    private int end;
    private static final byte[] EMPTY_ARRAY = new byte[0];

    public static ByteArrayCursor wrap(byte[] array) {
        ByteArrayCursor res = (ByteArrayCursor)RECYCLER.get();
        res.array = array;
        res.position = 0;
        res.end = array.length;
        return res;
    }

    public static ByteArrayCursor wrap(byte[] array, int offset, int length) {
        ByteArrayCursor res = (ByteArrayCursor)RECYCLER.get();
        res.array = array;
        res.position = offset;
        res.end = offset + length;
        return res;
    }

    private ByteArrayCursor(Recycler.Handle<ByteArrayCursor> handle) {
        this.handle = handle;
    }

    public ByteArrayCursor(byte[] array) {
        this.array = array;
        this.handle = null;
    }

    public boolean isEof() {
        return this.position >= this.end;
    }

    public int read() {
        if (this.position >= this.end) {
            return -1;
        }
        return this.array[this.position++];
    }

    public byte readByte() throws IOException {
        this.checkReadable(1);
        return this.array[this.position++];
    }

    private void checkReadable(int len) throws IOException {
        if (this.position + len > this.end) {
            throw new EOFException("array len " + this.end + ", pos " + this.position + ", try to read " + len + " bytes");
        }
    }

    public int readVInt() throws IOException {
        byte b = this.readByte();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public int readVIntNoEOFException() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            this.position = this.end;
            return -1;
        }
        byte b = (byte)ch;
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = this.readByte();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    public long readVLong() throws IOException {
        return this.readVLong(false);
    }

    private long readVLong(boolean allowNegative) throws IOException {
        byte b = this.readByte();
        if (b >= 0) {
            return b;
        }
        long i = (long)b & 0x7FL;
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 7;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 14;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 21;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 28;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 35;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 42;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 49;
        if (b >= 0) {
            return i;
        }
        b = this.readByte();
        i |= ((long)b & 0x7FL) << 56;
        if (b >= 0) {
            return i;
        }
        if (allowNegative) {
            b = this.readByte();
            i |= ((long)b & 0x7FL) << 63;
            if (b == 0 || b == 1) {
                return i;
            }
            throw new IOException("Invalid vLong detected (more than 64 bits)");
        }
        throw new IOException("Invalid vLong detected (negative values disallowed)");
    }

    public int readZInt() throws IOException {
        int i = this.readVInt();
        return i >>> 1 ^ -(i & 1);
    }

    public long readZLong() throws IOException {
        long l = this.readVLong();
        return l >>> 1 ^ -(l & 1L);
    }

    public int readArrayLen() throws IOException {
        return this.readVInt();
    }

    public int getPosition() {
        return this.position;
    }

    public byte[] getArray() {
        return this.array;
    }

    public void readArray(int len, byte[] buffer) throws IOException {
        if (len == 0) {
            return;
        }
        try {
            System.arraycopy(this.array, this.position, buffer, 0, len);
            this.position += len;
        }
        catch (IndexOutOfBoundsException t) {
            throw new IOException(t);
        }
    }

    public int readInt() throws IOException {
        this.checkReadable(4);
        int ch1 = this.array[this.position++] & 0xFF;
        int ch2 = this.array[this.position++] & 0xFF;
        int ch3 = this.array[this.position++] & 0xFF;
        int ch4 = this.array[this.position++] & 0xFF;
        if ((ch1 | ch2 | ch3 | ch4) < 0) {
            throw new EOFException();
        }
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    public long readLong() throws IOException {
        this.checkReadable(8);
        long res = ((long)this.array[this.position++] << 56) + ((long)(this.array[this.position++] & 0xFF) << 48) + ((long)(this.array[this.position++] & 0xFF) << 40) + ((long)(this.array[this.position++] & 0xFF) << 32) + ((long)(this.array[this.position++] & 0xFF) << 24) + (long)((this.array[this.position++] & 0xFF) << 16) + (long)((this.array[this.position++] & 0xFF) << 8) + (long)((this.array[this.position++] & 0xFF) << 0);
        return res;
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final boolean readBoolean() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            throw new EOFException();
        }
        return ch != 0;
    }

    public byte[] readArray() throws IOException {
        int len = this.readVInt();
        if (len == 0) {
            return EMPTY_ARRAY;
        }
        if (len == -1) {
            return null;
        }
        byte[] res = new byte[len];
        this.readArray(len, res);
        return res;
    }

    public Bytes readBytesNoCopy() throws IOException {
        int len = this.readVInt();
        if (len == 0) {
            return Bytes.EMPTY_ARRAY;
        }
        if (len == -1) {
            return null;
        }
        Bytes res = Bytes.from_array(this.array, this.position, len);
        this.position += len;
        return res;
    }

    public Bytes readBytes() throws IOException {
        return Bytes.from_nullable_array(this.readArray());
    }

    public RawString readRawStringNoCopy() throws IOException {
        int len = this.readVInt();
        if (len == 0) {
            return RawString.EMPTY;
        }
        if (len == -1) {
            return null;
        }
        RawString string = RawString.newPooledRawString(this.array, this.position, len);
        this.position += len;
        return string;
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipArray() throws IOException {
        int len = this.readVInt();
        if (len <= 0) {
            return;
        }
        this.skip(len);
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipInt() throws IOException {
        this.skip(4);
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipLong() throws IOException {
        this.skip(8);
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipDouble() throws IOException {
        this.skip(8);
    }

    @SuppressFBWarnings(value={"SR_NOT_CHECKED"})
    public void skipBoolean() throws IOException {
        this.skip(1);
    }

    public void skip(int pos) throws IOException {
        if (pos < 0) {
            throw new IOException("corrupted data");
        }
        this.checkReadable(pos);
        this.position += pos;
    }

    @Override
    public void close() {
        this.array = null;
        this.position = 0;
        if (this.handle != null) {
            this.handle.recycle((Object)this);
        }
    }
}

