/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryUtils {
    private static final String PREFIX_SELECT = "(?i)select.+[^a-zA-Z_0-9'\"]+from[^a-zA-Z_0-9'\"]+";
    private static final String PREFIX_UPDATE = "(?i)update\\W+";
    private static final String PREFIX_INSERT = "(?i)insert\\W+into\\W+";
    private static final String PREFIX_UPSERT = "(?i)upsert\\W+into\\W+";
    private static final String PREFIX_DELETE = "(?i)delete.+[^a-zA-Z_0-9'\"]+from[^a-zA-Z_0-9'\"]+";
    private static final String PREFIX_TABLE_CREATE = "(?i)create\\W+table\\W+";
    private static final String PREFIX_TABLE_DROP = "(?i)drop\\W+table\\W+";
    private static final String PREFIX_TABLE_TRUNCATE = "(?i)truncate\\W+table\\W+";
    private static final String PREFIX_TABLE_ALTER = "(?i)alter\\W+table\\W+";
    private static final String PREFIX_INDEX_CREATE = "(?i)create\\W+(?:(hash|brin)\\W+)?index\\W+.+\\W+on\\W+";
    private static final String PREFIX_INDEX_DROP = "(?i)drop\\W+index\\W+";
    private static final Pattern TABLE_SPACE_NAME_PATTERN = Pattern.compile("(?:(?i)select.+[^a-zA-Z_0-9'\"]+from[^a-zA-Z_0-9'\"]+|(?i)update\\W+|(?i)insert\\W+into\\W+|(?i)upsert\\W+into\\W+|(?i)delete.+[^a-zA-Z_0-9'\"]+from[^a-zA-Z_0-9'\"]+|(?i)create\\W+table\\W+|(?i)drop\\W+table\\W+|(?i)truncate\\W+table\\W+|(?i)alter\\W+table\\W+|(?i)create\\W+(?:(hash|brin)\\W+)?index\\W+.+\\W+on\\W+|(?i)drop\\W+index\\W+)(?<tablespace>\\S+\\.)?(?<tablename>\\S+)", 2);

    public static String discoverTablespace(String defaultTableSpace, String query) {
        String tableSpace;
        if (query == null) {
            return defaultTableSpace;
        }
        Matcher matcher = TABLE_SPACE_NAME_PATTERN.matcher(query);
        if (matcher.find() && (tableSpace = matcher.group("tablespace")) != null) {
            return tableSpace.substring(0, tableSpace.length() - 1);
        }
        return defaultTableSpace;
    }
}

