/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.functions;

import herddb.core.AbstractTableManager;
import herddb.core.DBManager;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.ColumnTypes;
import herddb.model.ExecutionPlan;
import herddb.model.Index;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableDoesNotExistException;
import herddb.model.TableSpaceDoesNotExistException;
import herddb.model.commands.SQLPlannedOperationStatement;
import herddb.model.planner.ValuesOp;
import herddb.sql.SQLStatementEvaluationContext;
import herddb.sql.TranslatedQuery;
import herddb.sql.expressions.ConstantExpression;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class ShowCreateTableCalculator {
    public static String calculate(boolean showCreateIndex, String tableName, String tableSpace, AbstractTableManager tableManager) {
        List<Index> indexes;
        Table t = tableManager.getTable();
        if (t == null) {
            throw new TableDoesNotExistException(String.format("Table %s does not exist.", tableName));
        }
        StringBuilder sb = new StringBuilder("CREATE TABLE " + tableSpace + "." + tableName);
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        for (Column c : t.getColumns()) {
            joiner.add(c.name + " " + ColumnTypes.typeToString(c.type) + ShowCreateTableCalculator.autoIncrementColumn(t, c) + ShowCreateTableCalculator.defaultClause(c));
        }
        if (t.getPrimaryKey().length > 0) {
            joiner.add("PRIMARY KEY(" + String.join((CharSequence)",", t.getPrimaryKey()) + ")");
        }
        if (showCreateIndex && !(indexes = tableManager.getAvailableIndexes()).isEmpty()) {
            indexes.forEach(idx -> {
                if (idx.unique) {
                    joiner.add("UNIQUE KEY " + idx.name + " (" + String.join((CharSequence)",", idx.columnNames) + ")");
                } else {
                    joiner.add("INDEX " + idx.name + "(" + String.join((CharSequence)",", idx.columnNames) + ")");
                }
            });
        }
        sb.append(joiner.toString());
        return sb.toString();
    }

    private static String autoIncrementColumn(Table t, Column c) {
        if (t.auto_increment && c.name.equals(t.primaryKey[0]) && (c.type == 2 || c.type == 12 || c.type == 1 || c.type == 13)) {
            return " auto_increment";
        }
        return "";
    }

    private static String defaultClause(Column c) {
        if (c.defaultValue != null) {
            return " DEFAULT " + Column.defaultValueToString(c);
        }
        return "";
    }

    public static TranslatedQuery calculateShowCreateTable(String query, String defaultTablespace, List<Object> parameters, DBManager manager) {
        String[] items = new String[]{"SHOW", "CREATE", "TABLE"};
        if (Arrays.stream(items).allMatch(query::contains)) {
            String tableName;
            query = query.substring(Arrays.stream(items).collect(Collectors.joining(" ")).length()).trim();
            String tableSpace = defaultTablespace;
            boolean showCreateIndex = query.contains("WITH INDEXES");
            if (showCreateIndex) {
                query = query.substring(0, query.indexOf("WITH INDEXES"));
            }
            if (query.contains(".")) {
                String[] tokens = query.split("\\.");
                tableSpace = tokens[0].trim();
                tableName = tokens[1].trim();
            } else {
                tableName = query.trim();
            }
            tableName = tableName.toLowerCase();
            TableSpaceManager tableSpaceManager = manager.getTableSpaceManager(tableSpace);
            if (tableSpaceManager == null) {
                throw new TableSpaceDoesNotExistException(String.format("Tablespace %s does not exist.", tableSpace));
            }
            AbstractTableManager tableManager = tableSpaceManager.getTableManager(tableName);
            if (tableManager == null || tableManager.getCreatedInTransaction() > 0L) {
                throw new TableDoesNotExistException(String.format("Table %s does not exist.", tableName));
            }
            String showCreateResult = ShowCreateTableCalculator.calculate(showCreateIndex, tableName, tableSpace, tableManager);
            ValuesOp values = new ValuesOp(manager.getNodeId(), new String[]{"tabledef"}, new Column[]{Column.column("tabledef", 0)}, Arrays.asList(Arrays.asList(new ConstantExpression(showCreateResult, 11))));
            ExecutionPlan executionPlan = ExecutionPlan.simple(new SQLPlannedOperationStatement(values), values);
            return new TranslatedQuery(executionPlan, new SQLStatementEvaluationContext(query, parameters, false, false));
        }
        throw new StatementExecutionException(String.format("Incorrect Syntax for SHOW CREATE TABLE tablespace.tablename", new Object[0]));
    }
}

