/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.functions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.AggregatedColumnCalculator;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.functions.AvgColumnCalculator;
import herddb.sql.functions.CountColumnCalculator;
import herddb.sql.functions.FloatingPointAvgColumnCalculator;
import herddb.sql.functions.MaxColumnCalculator;
import herddb.sql.functions.MinColumnCalculator;
import herddb.sql.functions.SingleValueCalculator;
import herddb.sql.functions.SumColumnCalculator;

public class BuiltinFunctions {
    public static final String COUNT = "count";
    public static final String SUM = "sum";
    public static final String SUM0 = "$sum0";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String SINGLEVALUE = "single_value";
    public static final String LOWER = "lower";
    public static final String UPPER = "upper";
    public static final String ABS = "abs";
    public static final String ROUND = "round";
    public static final String EXTRACT = "extract";
    public static final String FLOOR = "floor";
    public static final String RAND = "rand";
    public static final String AVG = "avg";
    public static final String CURRENT_TIMESTAMP = "current_timestamp";
    public static final String BOOLEAN_TRUE = "true";
    public static final String BOOLEAN_FALSE = "false";
    public static final String NAME_COUNT = "COUNT";
    public static final String NAME_SUM = "SUM";
    public static final String NAME_MIN = "MIN";
    public static final String NAME_MAX = "MAX";
    public static final String NAME_AVG = "AVG";
    public static final String NAME_LOWERCASE = "LOWER";
    public static final String NAME_UPPER = "UPPER";
    public static final String NAME_ABS = "ABS";
    public static final String NAME_ROUND = "ROUND";
    public static final String NAME_EXTRACT = "EXTRACT";
    public static final String NAME_FLOOR = "FLOOR";
    public static final String NAME_RAND = "RAND";
    public static final String NAME_REINTERPRET = "Reinterpret";
    public static final String NAME_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    public static final String NAME_CURRENT_DATE = "CURRENT_DATE";

    public static AggregatedColumnCalculator getColumnCalculator(String functionName, String fieldName, int type, CompiledSQLExpression firstParam, StatementEvaluationContext context) throws StatementExecutionException {
        switch (functionName) {
            case "count": {
                return new CountColumnCalculator(fieldName);
            }
            case "sum": 
            case "$sum0": {
                return new SumColumnCalculator(fieldName, firstParam, context);
            }
            case "avg": {
                if (type == 16 || type == 6) {
                    return new FloatingPointAvgColumnCalculator(fieldName, firstParam, context);
                }
                return new AvgColumnCalculator(fieldName, type, firstParam, context);
            }
            case "min": {
                return new MinColumnCalculator(fieldName, firstParam, context);
            }
            case "max": {
                return new MaxColumnCalculator(fieldName, firstParam, context);
            }
            case "single_value": {
                return new SingleValueCalculator(fieldName, firstParam, context);
            }
        }
        return null;
    }

    public static boolean isAggregatedFunction(String functionNameLowercase) {
        switch (functionNameLowercase) {
            case "count": 
            case "sum": 
            case "avg": 
            case "$sum0": 
            case "min": 
            case "max": {
                return true;
            }
        }
        return false;
    }
}

