/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.functions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.SQLRecordPredicate;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.functions.AbstractSingleExpressionArgumentColumnCalculator;
import herddb.utils.DataAccessor;

public class AvgColumnCalculator
extends AbstractSingleExpressionArgumentColumnCalculator {
    private final int type;
    private long result;
    private long count;

    public AvgColumnCalculator(String fieldName, int type, CompiledSQLExpression expression, StatementEvaluationContext context) throws StatementExecutionException {
        super(fieldName, expression, context);
        this.type = type;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public void consume(DataAccessor tuple) throws StatementExecutionException {
        Comparable value = this.valueExtractor.apply(tuple);
        if (value != null) {
            this.result += ((Number)((Object)value)).longValue();
        }
        ++this.count;
    }

    @Override
    public Object getValue() {
        if (this.count == 0L) {
            throw new StatementExecutionException("Division by zero in AVG function");
        }
        return SQLRecordPredicate.cast(this.result / this.count, this.type);
    }
}

