/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.core.HerdDBInternalException;
import herddb.model.StatementExecutionException;
import herddb.sql.JSQLParserPlanner;
import herddb.sql.expressions.AccessCurrentRowExpression;
import herddb.sql.expressions.CastExpression;
import herddb.sql.expressions.ColumnRef;
import herddb.sql.expressions.CompiledAddExpression;
import herddb.sql.expressions.CompiledAndExpression;
import herddb.sql.expressions.CompiledCaseExpression;
import herddb.sql.expressions.CompiledDivideExpression;
import herddb.sql.expressions.CompiledEqualsExpression;
import herddb.sql.expressions.CompiledFunction;
import herddb.sql.expressions.CompiledGreaterThanEqualsExpression;
import herddb.sql.expressions.CompiledGreaterThanExpression;
import herddb.sql.expressions.CompiledInExpression;
import herddb.sql.expressions.CompiledIsNullExpression;
import herddb.sql.expressions.CompiledLikeExpression;
import herddb.sql.expressions.CompiledMinorThanEqualsExpression;
import herddb.sql.expressions.CompiledMinorThanExpression;
import herddb.sql.expressions.CompiledModuloExpression;
import herddb.sql.expressions.CompiledMultiplyExpression;
import herddb.sql.expressions.CompiledNotEqualsExpression;
import herddb.sql.expressions.CompiledNotExpression;
import herddb.sql.expressions.CompiledOrExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.CompiledSignedExpression;
import herddb.sql.expressions.CompiledSubtractExpression;
import herddb.sql.expressions.ConstantExpression;
import herddb.sql.expressions.JdbcParameterExpression;
import herddb.sql.expressions.OpSchema;
import herddb.sql.functions.BuiltinFunctions;
import herddb.utils.IntHolder;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;

public class SQLParserExpressionCompiler {
    public static CompiledSQLExpression compileExpression(Expression expression, OpSchema tableSchema) {
        return SQLParserExpressionCompiler.compileExpressionInternal(expression, tableSchema).simplify();
    }

    private static CompiledSQLExpression compileExpressionInternal(Expression expression, OpSchema tableSchema) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JdbcParameter) {
            JdbcParameter p = (JdbcParameter)expression;
            return new JdbcParameterExpression(p.getIndex() - 1);
        }
        if (expression instanceof StringValue || expression instanceof LongValue || expression instanceof NullValue || expression instanceof DoubleValue || expression instanceof TimestampValue) {
            return JSQLParserPlanner.resolveValueAsCompiledSQLExpression(expression, false);
        }
        if (expression instanceof Column) {
            Column col = (Column)expression;
            String tableAlias = SQLParserExpressionCompiler.extractTableName(col);
            String columnName = col.getColumnName();
            if (SQLParserExpressionCompiler.isBooleanLiteral(col)) {
                return new ConstantExpression(Boolean.parseBoolean(columnName.toLowerCase()), 17);
            }
            IntHolder indexInSchema = new IntHolder(-1);
            ColumnRef found = SQLParserExpressionCompiler.findColumnInSchema(tableAlias, columnName, tableSchema, indexInSchema);
            if (indexInSchema.value == -1 || found == null) {
                String nameInError = tableAlias != null ? tableAlias + "." + columnName : columnName;
                throw new StatementExecutionException("Column " + nameInError + " not found in target table (schema " + tableSchema + ")");
            }
            return new AccessCurrentRowExpression(indexInSchema.value, found.type);
        }
        if (expression instanceof BinaryExpression) {
            return SQLParserExpressionCompiler.compileBinaryExpression((BinaryExpression)expression, tableSchema);
        }
        if (expression instanceof IsNullExpression) {
            IsNullExpression eq = (IsNullExpression)expression;
            CompiledSQLExpression left = SQLParserExpressionCompiler.compileExpression(eq.getLeftExpression(), tableSchema);
            return new CompiledIsNullExpression(eq.isNot(), left);
        }
        if (expression instanceof NotExpression) {
            NotExpression eq = (NotExpression)expression;
            CompiledSQLExpression left = SQLParserExpressionCompiler.compileExpression(eq.getExpression(), tableSchema);
            return new CompiledNotExpression(left);
        }
        if (expression instanceof Parenthesis) {
            Parenthesis eq = (Parenthesis)expression;
            return SQLParserExpressionCompiler.compileExpression(eq.getExpression(), tableSchema);
        }
        if (expression instanceof SignedExpression) {
            SignedExpression eq = (SignedExpression)expression;
            return new CompiledSignedExpression(eq.getSign(), SQLParserExpressionCompiler.compileExpression(eq.getExpression(), tableSchema));
        }
        if (expression instanceof InExpression) {
            InExpression eq = (InExpression)expression;
            JSQLParserPlanner.checkSupported(eq.getOldOracleJoinSyntax() == 0);
            JSQLParserPlanner.checkSupported(eq.getOraclePriorPosition() == 0);
            JSQLParserPlanner.checkSupported(eq.getLeftItemsList() == null);
            JSQLParserPlanner.checkSupported(eq.getMultiExpressionList() == null);
            JSQLParserPlanner.checkSupported(eq.getRightExpression() == null);
            CompiledSQLExpression left = SQLParserExpressionCompiler.compileExpression(eq.getLeftExpression(), tableSchema);
            ItemsList rightItemsList = eq.getRightItemsList();
            JSQLParserPlanner.checkSupported(rightItemsList instanceof ExpressionList, "Sub Selects are not supported with jSQLParser");
            ExpressionList expressionList = (ExpressionList)rightItemsList;
            CompiledSQLExpression[] values = new CompiledSQLExpression[expressionList.getExpressions().size()];
            int i = 0;
            for (Expression exp : expressionList.getExpressions()) {
                values[i++] = SQLParserExpressionCompiler.compileExpression(exp, tableSchema);
            }
            return new CompiledInExpression(left, values);
        }
        if (expression instanceof TimeKeyExpression) {
            TimeKeyExpression eq = (TimeKeyExpression)expression;
            if (eq.getStringValue().equalsIgnoreCase("CURRENT_TIMESTAMP")) {
                return new CompiledFunction("current_timestamp", Collections.emptyList());
            }
        } else if (expression instanceof Function) {
            Function eq = (Function)expression;
            JSQLParserPlanner.checkSupported(eq.getKeep() == null);
            JSQLParserPlanner.checkSupported(eq.getMultipartName() != null && eq.getMultipartName().size() == 1);
            JSQLParserPlanner.checkSupported(eq.getNamedParameters() == null);
            JSQLParserPlanner.checkSupported(eq.getAttribute() == null);
            JSQLParserPlanner.checkSupported(eq.getAttributeName() == null);
            ArrayList<CompiledSQLExpression> operands = new ArrayList<CompiledSQLExpression>();
            if (eq.getParameters() != null) {
                for (Expression e : eq.getParameters().getExpressions()) {
                    operands.add(SQLParserExpressionCompiler.compileExpression(e, tableSchema));
                }
            }
            switch (eq.getName().toUpperCase()) {
                case "LOWER": {
                    return new CompiledFunction("lower", operands);
                }
                case "UPPER": {
                    return new CompiledFunction("upper", operands);
                }
                case "ABS": {
                    return new CompiledFunction("abs", operands);
                }
                case "AVG": {
                    return new CompiledFunction("avg", operands);
                }
                case "ROUND": {
                    return new CompiledFunction("round", operands);
                }
                case "EXTRACT": {
                    return new CompiledFunction("extract", operands);
                }
                case "FLOOR": {
                    return new CompiledFunction("floor", operands);
                }
                case "RAND": {
                    return new CompiledFunction("rand", operands);
                }
            }
        } else {
            if (expression instanceof CaseExpression) {
                CaseExpression eq = (CaseExpression)expression;
                JSQLParserPlanner.checkSupported(eq.getSwitchExpression() == null);
                List whenClauses = eq.getWhenClauses();
                ArrayList<Map.Entry<CompiledSQLExpression, CompiledSQLExpression>> cases = new ArrayList<Map.Entry<CompiledSQLExpression, CompiledSQLExpression>>(whenClauses.size());
                for (WhenClause c : whenClauses) {
                    cases.add(new AbstractMap.SimpleImmutableEntry<CompiledSQLExpression, CompiledSQLExpression>(SQLParserExpressionCompiler.compileExpression(c.getWhenExpression(), tableSchema), SQLParserExpressionCompiler.compileExpression(c.getThenExpression(), tableSchema)));
                }
                CompiledSQLExpression elseExp = eq.getElseExpression() != null ? SQLParserExpressionCompiler.compileExpression(eq.getElseExpression(), tableSchema) : null;
                return new CompiledCaseExpression(cases, elseExp);
            }
            if (expression instanceof Between) {
                Between b = (Between)expression;
                boolean not = b.isNot();
                CompiledSQLExpression baseValue = SQLParserExpressionCompiler.compileExpression(b.getLeftExpression(), tableSchema);
                CompiledSQLExpression start = SQLParserExpressionCompiler.compileExpression(b.getBetweenExpressionStart(), tableSchema);
                CompiledSQLExpression end = SQLParserExpressionCompiler.compileExpression(b.getBetweenExpressionEnd(), tableSchema);
                CompiledAndExpression result = new CompiledAndExpression(new CompiledGreaterThanEqualsExpression(baseValue, start), new CompiledMinorThanEqualsExpression(baseValue, end));
                if (not) {
                    return new CompiledNotExpression(result);
                }
                return result;
            }
            if (expression instanceof net.sf.jsqlparser.expression.CastExpression) {
                net.sf.jsqlparser.expression.CastExpression b = (net.sf.jsqlparser.expression.CastExpression)expression;
                CompiledSQLExpression left = SQLParserExpressionCompiler.compileExpression(b.getLeftExpression(), tableSchema);
                int type = JSQLParserPlanner.sqlDataTypeToColumnType(b.getType());
                return new CastExpression(left, type);
            }
        }
        throw new StatementExecutionException("not implemented expression type " + expression.getClass() + ": " + expression);
    }

    private static CompiledSQLExpression compileBinaryExpression(BinaryExpression expression, OpSchema tableSchema) {
        CompiledSQLExpression left = SQLParserExpressionCompiler.compileExpression(expression.getLeftExpression(), tableSchema);
        CompiledSQLExpression right = SQLParserExpressionCompiler.compileExpression(expression.getRightExpression(), tableSchema);
        if (expression instanceof EqualsTo) {
            EqualsTo eq = (EqualsTo)expression;
            JSQLParserPlanner.checkSupported(eq.getOldOracleJoinSyntax() == 0);
            JSQLParserPlanner.checkSupported(eq.getOraclePriorPosition() == 0);
            return new CompiledEqualsExpression(left, right);
        }
        if (expression instanceof AndExpression) {
            return new CompiledAndExpression(left, right);
        }
        if (expression instanceof OrExpression) {
            return new CompiledOrExpression(left, right);
        }
        if (expression instanceof GreaterThan) {
            return new CompiledGreaterThanExpression(left, right);
        }
        if (expression instanceof GreaterThanEquals) {
            return new CompiledGreaterThanEqualsExpression(left, right);
        }
        if (expression instanceof MinorThan) {
            return new CompiledMinorThanExpression(left, right);
        }
        if (expression instanceof MinorThanEquals) {
            return new CompiledMinorThanEqualsExpression(left, right);
        }
        if (expression instanceof Addition) {
            return new CompiledAddExpression(left, right);
        }
        if (expression instanceof Division) {
            return new CompiledDivideExpression(left, right);
        }
        if (expression instanceof Multiplication) {
            return new CompiledMultiplyExpression(left, right);
        }
        if (expression instanceof LikeExpression) {
            CompiledSQLExpression res;
            LikeExpression eq = (LikeExpression)expression;
            if (eq.isCaseInsensitive()) {
                throw new StatementExecutionException("ILIKE is not supported");
            }
            if (eq.getEscape() != null) {
                ConstantExpression escape = new ConstantExpression(eq.getEscape(), 11);
                res = new CompiledLikeExpression(left, right, escape);
            } else {
                res = new CompiledLikeExpression(left, right);
            }
            if (eq.isNot()) {
                res = new CompiledNotExpression(res);
            }
            return res;
        }
        if (expression instanceof Modulo) {
            return new CompiledModuloExpression(left, right);
        }
        if (expression instanceof Subtraction) {
            return new CompiledSubtractExpression(left, right);
        }
        if (expression instanceof NotEqualsTo) {
            NotEqualsTo eq = (NotEqualsTo)expression;
            JSQLParserPlanner.checkSupported(eq.getOldOracleJoinSyntax() == 0);
            JSQLParserPlanner.checkSupported(eq.getOraclePriorPosition() == 0);
            return new CompiledNotEqualsExpression(left, right);
        }
        throw new StatementExecutionException("not implemented expression type " + expression.getClass() + ": " + expression);
    }

    public static boolean isBooleanLiteral(Column col) {
        if (col.getTable() != null) {
            return false;
        }
        String columnName = col.getColumnName().toLowerCase();
        return columnName.equals("false") || columnName.equals("true");
    }

    public static Function detectAggregatedFunction(Expression expression) {
        if (expression instanceof net.sf.jsqlparser.expression.CastExpression) {
            net.sf.jsqlparser.expression.CastExpression c = (net.sf.jsqlparser.expression.CastExpression)expression;
            return SQLParserExpressionCompiler.detectAggregatedFunction(c.getLeftExpression());
        }
        if (!(expression instanceof Function)) {
            return null;
        }
        Function fn = (Function)expression;
        if (BuiltinFunctions.isAggregatedFunction(fn.getName().toLowerCase())) {
            return fn;
        }
        return null;
    }

    public static int getAggregateFunctionType(Expression exp, OpSchema tableSchema) {
        String functionNameLowercase;
        if (exp instanceof net.sf.jsqlparser.expression.CastExpression) {
            net.sf.jsqlparser.expression.CastExpression c = (net.sf.jsqlparser.expression.CastExpression)exp;
            return JSQLParserPlanner.sqlDataTypeToColumnType(c.getType());
        }
        Function fn = (Function)exp;
        switch (functionNameLowercase = fn.getName().toLowerCase()) {
            case "count": {
                return 1;
            }
            case "sum": 
            case "$sum0": 
            case "avg": 
            case "min": 
            case "max": {
                JSQLParserPlanner.checkSupported(fn.getParameters().getExpressions().size() == 1);
                Expression first = (Expression)fn.getParameters().getExpressions().get(0);
                if (first instanceof net.sf.jsqlparser.expression.CastExpression) {
                    net.sf.jsqlparser.expression.CastExpression c = (net.sf.jsqlparser.expression.CastExpression)first;
                    return JSQLParserPlanner.sqlDataTypeToColumnType(c.getType());
                }
                JSQLParserPlanner.checkSupported(first instanceof Column, first.getClass());
                Column cName = (Column)first;
                String tableAlias = SQLParserExpressionCompiler.extractTableName(cName);
                ColumnRef col = SQLParserExpressionCompiler.findColumnInSchema(tableAlias, SQLParserExpressionCompiler.fixMySqlBackTicks(cName.getColumnName()), tableSchema, new IntHolder());
                JSQLParserPlanner.checkSupported(col != null);
                return col.type;
            }
        }
        throw new HerdDBInternalException(functionNameLowercase);
    }

    public static ColumnRef getAggregateFunctionArgument(Function fn, OpSchema tableSchema) {
        String functionNameLowercase;
        switch (functionNameLowercase = fn.getName().toLowerCase()) {
            case "count": {
                return null;
            }
            case "sum": 
            case "$sum0": 
            case "avg": 
            case "min": 
            case "max": {
                JSQLParserPlanner.checkSupported(fn.getParameters().getExpressions().size() == 1);
                Expression first = (Expression)fn.getParameters().getExpressions().get(0);
                if (first instanceof net.sf.jsqlparser.expression.CastExpression) {
                    first = ((net.sf.jsqlparser.expression.CastExpression)first).getLeftExpression();
                }
                JSQLParserPlanner.checkSupported(first instanceof Column);
                Column cName = (Column)first;
                String tableAlias = SQLParserExpressionCompiler.extractTableName(cName);
                ColumnRef col = SQLParserExpressionCompiler.findColumnInSchema(tableAlias, SQLParserExpressionCompiler.fixMySqlBackTicks(cName.getColumnName()), tableSchema, new IntHolder());
                JSQLParserPlanner.checkSupported(col != null);
                return col;
            }
        }
        throw new HerdDBInternalException(functionNameLowercase);
    }

    public static ColumnRef findColumnInSchema(String tableName, String columnName, OpSchema tableSchema, IntHolder pos) {
        columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(columnName);
        pos.value = 0;
        if (tableName == null || tableName.equalsIgnoreCase(tableSchema.name)) {
            for (ColumnRef colInSchema : tableSchema.columns) {
                if (colInSchema.name.equalsIgnoreCase(columnName) && (colInSchema.tableName == null || tableName == null || colInSchema.tableName.equalsIgnoreCase(tableSchema.name))) {
                    return colInSchema;
                }
                ++pos.value;
            }
        } else {
            for (ColumnRef colInSchema : tableSchema.columns) {
                if (colInSchema.name.equalsIgnoreCase(columnName) && (colInSchema.tableName != null && colInSchema.tableName.equalsIgnoreCase(tableName) || tableName.equalsIgnoreCase(tableSchema.alias))) {
                    return colInSchema;
                }
                ++pos.value;
            }
        }
        pos.value = -1;
        return null;
    }

    public static String extractTableName(Column col) {
        if (col.getTable() != null) {
            Table table = col.getTable();
            JSQLParserPlanner.checkSupported(table.getAlias() == null);
            return SQLParserExpressionCompiler.fixMySqlBackTicks(table.getName());
        }
        return null;
    }

    public static String fixMySqlBackTicks(String s) {
        if (s == null || s.length() < 2) {
            return s;
        }
        if (s.startsWith("`") && s.endsWith("`")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

