/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementExecutionException;
import herddb.sql.CalcitePlanner;
import herddb.sql.expressions.AccessCorrelVariableExpression;
import herddb.sql.expressions.AccessCurrentRowExpression;
import herddb.sql.expressions.AccessFieldExpression;
import herddb.sql.expressions.CompiledAddExpression;
import herddb.sql.expressions.CompiledCaseExpression;
import herddb.sql.expressions.CompiledDivideExpression;
import herddb.sql.expressions.CompiledDivideIntExpression;
import herddb.sql.expressions.CompiledEqualsExpression;
import herddb.sql.expressions.CompiledFunction;
import herddb.sql.expressions.CompiledGreaterThanEqualsExpression;
import herddb.sql.expressions.CompiledGreaterThanExpression;
import herddb.sql.expressions.CompiledIsNotTrueExpression;
import herddb.sql.expressions.CompiledIsNullExpression;
import herddb.sql.expressions.CompiledLikeExpression;
import herddb.sql.expressions.CompiledMinorThanEqualsExpression;
import herddb.sql.expressions.CompiledMinorThanExpression;
import herddb.sql.expressions.CompiledModuloExpression;
import herddb.sql.expressions.CompiledMultiAndExpression;
import herddb.sql.expressions.CompiledMultiOrExpression;
import herddb.sql.expressions.CompiledMultiplyExpression;
import herddb.sql.expressions.CompiledNotEqualsExpression;
import herddb.sql.expressions.CompiledParenthesisExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.CompiledSignedExpression;
import herddb.sql.expressions.CompiledSubtractExpression;
import herddb.sql.expressions.ConstantExpression;
import herddb.sql.expressions.TypedJdbcParameterExpression;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.SqlTypeName;

public class SQLExpressionCompiler {
    public static CompiledSQLExpression compileExpression(RexNode expression) {
        block80: {
            block79: {
                if (expression == null) {
                    return null;
                }
                if (expression instanceof RexDynamicParam) {
                    RexDynamicParam p = (RexDynamicParam)expression;
                    return new TypedJdbcParameterExpression(p.getIndex(), CalcitePlanner.convertToHerdType(p.getType()));
                }
                if (expression instanceof RexLiteral) {
                    RexLiteral p = (RexLiteral)expression;
                    if (p.isNull()) {
                        return new ConstantExpression(null, 5);
                    }
                    return new ConstantExpression(SQLExpressionCompiler.safeValue(p.getValue3(), p.getType(), p.getTypeName()), CalcitePlanner.convertToHerdType(p.getType()));
                }
                if (expression instanceof RexInputRef) {
                    RexInputRef p = (RexInputRef)expression;
                    return new AccessCurrentRowExpression(p.getIndex(), CalcitePlanner.convertToHerdType(p.getType()));
                }
                if (!(expression instanceof RexCall)) break block79;
                RexCall p = (RexCall)expression;
                SqlOperator op = p.op;
                String name = op.getName();
                Object[] operands = new CompiledSQLExpression[p.operands.size()];
                int i = 0;
                for (RexNode operand : p.operands) {
                    operands[i++] = SQLExpressionCompiler.compileExpression(operand);
                }
                switch (name) {
                    case "=": {
                        return new CompiledEqualsExpression(operands[0], operands[1]);
                    }
                    case "<>": {
                        return new CompiledNotEqualsExpression(operands[0], operands[1]);
                    }
                    case ">": {
                        return new CompiledGreaterThanExpression(operands[0], operands[1]);
                    }
                    case ">=": {
                        return new CompiledGreaterThanEqualsExpression(operands[0], operands[1]);
                    }
                    case "<": {
                        return new CompiledMinorThanExpression(operands[0], operands[1]);
                    }
                    case "<=": {
                        return new CompiledMinorThanEqualsExpression(operands[0], operands[1]);
                    }
                    case "+": {
                        return new CompiledAddExpression(operands[0], operands[1]);
                    }
                    case "MOD": {
                        return new CompiledModuloExpression(operands[0], operands[1]);
                    }
                    case "-": {
                        if (operands.length == 1) {
                            return new CompiledSignedExpression('-', operands[0]);
                        }
                        if (operands.length == 2) {
                            return new CompiledSubtractExpression(operands[0], (CompiledSQLExpression)operands[1]);
                        }
                        break block80;
                    }
                    case "*": {
                        return new CompiledMultiplyExpression(operands[0], operands[1]);
                    }
                    case "/": {
                        return new CompiledDivideExpression(operands[0], operands[1]);
                    }
                    case "/INT": {
                        return new CompiledDivideIntExpression(operands[0], operands[1]);
                    }
                    case "LIKE": {
                        if (operands.length == 2) {
                            return new CompiledLikeExpression(operands[0], operands[1]);
                        }
                        return new CompiledLikeExpression(operands[0], operands[1], (CompiledSQLExpression)operands[2]);
                    }
                    case "AND": {
                        return new CompiledMultiAndExpression((CompiledSQLExpression[])operands);
                    }
                    case "OR": {
                        return new CompiledMultiOrExpression((CompiledSQLExpression[])operands);
                    }
                    case "NOT": {
                        return new CompiledParenthesisExpression(true, operands[0]);
                    }
                    case "IS NOT NULL": {
                        return new CompiledIsNullExpression(true, operands[0]);
                    }
                    case "IS NOT TRUE": {
                        return new CompiledIsNotTrueExpression(false, operands[0]);
                    }
                    case "IS NULL": {
                        return new CompiledIsNullExpression(false, operands[0]);
                    }
                    case "CAST": {
                        return operands[0].cast(CalcitePlanner.convertToHerdType(p.type));
                    }
                    case "CASE": {
                        ArrayList<Map.Entry<CompiledSQLExpression, CompiledSQLExpression>> cases = new ArrayList<Map.Entry<CompiledSQLExpression, CompiledSQLExpression>>(operands.length / 2);
                        boolean hasElse = operands.length % 2 == 1;
                        int numcases = hasElse ? (operands.length - 1) / 2 : operands.length / 2;
                        for (int j = 0; j < numcases; ++j) {
                            cases.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(operands[j * 2], operands[j * 2 + 1]));
                        }
                        Object elseExp = hasElse ? operands[operands.length - 1] : null;
                        return new CompiledCaseExpression(cases, (CompiledSQLExpression)elseExp);
                    }
                    case "CURRENT_TIMESTAMP": {
                        return new CompiledFunction("current_timestamp", Collections.emptyList());
                    }
                    case "CURRENT_DATE": {
                        return new CompiledFunction("CURRENT_DATE", Collections.emptyList());
                    }
                    case "LOWER": {
                        return new CompiledFunction("lower", Arrays.asList(operands));
                    }
                    case "UPPER": {
                        return new CompiledFunction("upper", Arrays.asList(operands));
                    }
                    case "ABS": {
                        return new CompiledFunction("abs", Arrays.asList(operands));
                    }
                    case "ROUND": {
                        return new CompiledFunction("round", Arrays.asList(operands));
                    }
                    case "EXTRACT": {
                        return new CompiledFunction("extract", Arrays.asList(operands));
                    }
                    case "FLOOR": {
                        return new CompiledFunction("floor", Arrays.asList(operands));
                    }
                    case "RAND": {
                        return new CompiledFunction("rand", Arrays.asList(operands));
                    }
                    case "Reinterpret": {
                        if (operands.length != 1) {
                            throw new StatementExecutionException("unsupported use of Reinterpret with " + Arrays.toString(operands));
                        }
                        return operands[0];
                    }
                    default: {
                        throw new StatementExecutionException("unsupported operator '" + name + "'");
                    }
                }
            }
            if (expression instanceof RexFieldAccess) {
                RexFieldAccess p = (RexFieldAccess)expression;
                CompiledSQLExpression object = SQLExpressionCompiler.compileExpression(p.getReferenceExpr());
                return new AccessFieldExpression(object, p.getField().getName());
            }
            if (expression instanceof RexCorrelVariable) {
                RexCorrelVariable p = (RexCorrelVariable)expression;
                return new AccessCorrelVariableExpression(p.id.getId(), p.id.getName());
            }
        }
        throw new StatementExecutionException("not implemented expression type " + expression.getClass() + ": " + expression);
    }

    private static Object safeValue(Object value3, RelDataType relDataType, SqlTypeName sqlTypeName) {
        if (value3 instanceof BigDecimal) {
            if (relDataType instanceof BasicSqlType) {
                sqlTypeName = relDataType.getSqlTypeName();
            }
            if (sqlTypeName == SqlTypeName.DECIMAL || sqlTypeName == SqlTypeName.DOUBLE) {
                return ((BigDecimal)value3).doubleValue();
            }
            return ((BigDecimal)value3).longValue();
        }
        return value3;
    }
}

