/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.sql.expressions.ColumnRef;
import java.util.Arrays;

public final class OpSchema {
    public final String tableSpace;
    public final String name;
    public final String alias;
    public final ColumnRef[] columns;
    public final String[] columnNames;

    public OpSchema(String tableSpace, String tableName, String alias, String[] columnNames, ColumnRef[] tableSchema) {
        this.tableSpace = tableSpace;
        this.name = tableName;
        this.alias = alias;
        this.columns = tableSchema;
        this.columnNames = columnNames;
    }

    public OpSchema(String tableSpace, String name, String alias, ColumnRef[] tableSchema) {
        this.tableSpace = tableSpace;
        this.name = name;
        this.alias = alias;
        this.columns = tableSchema;
        String[] _columnNames = new String[tableSchema.length];
        for (int i = 0; i < tableSchema.length; ++i) {
            _columnNames[i] = tableSchema[i].name;
        }
        this.columnNames = _columnNames;
    }

    public boolean isTableOrAlias(String name) {
        if (name == null) {
            return false;
        }
        if (name.equalsIgnoreCase(this.name)) {
            return true;
        }
        return name.equalsIgnoreCase(this.alias);
    }

    public String toString() {
        return "OpSchema{tableSpace=" + this.tableSpace + ", name=" + this.name + ", alias=" + this.alias + ", columns=" + Arrays.toString(this.columns) + ", columnNames=" + Arrays.toString(this.columnNames) + '}';
    }
}

