/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;

public class CompiledOrExpression
extends CompiledBinarySQLExpression {
    public CompiledOrExpression(CompiledSQLExpression left, CompiledSQLExpression right) {
        super(left, right);
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        boolean ok = SQLRecordPredicateFunctions.toBoolean((Object)this.left.evaluate(bean, context));
        if (ok) {
            return true;
        }
        return SQLRecordPredicateFunctions.toBoolean((Object)this.right.evaluate(bean, context));
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        this.left.validate(context);
        this.right.validate(context);
    }

    @Override
    public String toString() {
        return "CompiledAndExpression{left=" + this.left + ", right=" + this.right + '}';
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        CompiledSQLExpression remappedLeft = this.left.remapPositionalAccessToToPrimaryKeyAccessor(projection);
        CompiledSQLExpression remappedRight = this.right.remapPositionalAccessToToPrimaryKeyAccessor(projection);
        return new CompiledOrExpression(remappedLeft, remappedRight);
    }
}

