/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;

public class CompiledNotExpression
implements CompiledSQLExpression {
    private final CompiledSQLExpression left;

    public CompiledNotExpression(CompiledSQLExpression left) {
        this.left = left;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        Object leftValue = this.left.evaluate(bean, context);
        if (leftValue == null) {
            return null;
        }
        return !SQLRecordPredicateFunctions.toBoolean((Object)leftValue);
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        this.left.validate(context);
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return new CompiledNotExpression(this.left.remapPositionalAccessToToPrimaryKeyAccessor(projection));
    }

    public String toString() {
        return "CompiledNotExpression{left=" + this.left + '}';
    }

    @Override
    public CompiledSQLExpression simplify() {
        CompiledBinarySQLExpression binaryLeft;
        if (this.left instanceof CompiledBinarySQLExpression && (binaryLeft = (CompiledBinarySQLExpression)this.left).isNegateSupported()) {
            return binaryLeft.negate();
        }
        return this;
    }
}

