/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.core.HerdDBInternalException;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.ConstantExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.regex.Pattern;

public class CompiledLikeExpression
extends CompiledBinarySQLExpression {
    private final Pattern rightConstantPattern;

    public CompiledLikeExpression(CompiledSQLExpression left, CompiledSQLExpression right) throws HerdDBInternalException {
        super(left, right);
        this.rightConstantPattern = CompiledLikeExpression.compilePattern(right, '\\');
    }

    public CompiledLikeExpression(CompiledSQLExpression left, CompiledSQLExpression right, CompiledSQLExpression escape) throws HerdDBInternalException {
        super(left, right);
        this.rightConstantPattern = CompiledLikeExpression.compilePattern(right, ((String)escape.cast(0).evaluate(DataAccessor.NULL, null)).charAt(0));
    }

    private static Pattern compilePattern(CompiledSQLExpression exp, char escapeChar) throws HerdDBInternalException {
        if (exp instanceof ConstantExpression) {
            ConstantExpression ce = (ConstantExpression)exp;
            if (ce.isNull()) {
                return null;
            }
            return SQLRecordPredicateFunctions.compileLikePattern((String)ce.evaluate(DataAccessor.NULL, null).toString(), (char)escapeChar);
        }
        return null;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        boolean ok;
        Object leftValue = this.left.evaluate(bean, context);
        if (this.rightConstantPattern != null) {
            ok = SQLRecordPredicateFunctions.matches((Object)leftValue, (Pattern)this.rightConstantPattern);
        } else {
            Object rightValue = this.right.evaluate(bean, context);
            ok = SQLRecordPredicateFunctions.like((Object)leftValue, (Object)rightValue, (char)'\\');
        }
        return ok;
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return new CompiledLikeExpression(this.left.remapPositionalAccessToToPrimaryKeyAccessor(projection), this.right.remapPositionalAccessToToPrimaryKeyAccessor(projection));
    }
}

