/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import java.util.Arrays;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class CompiledInExpression
implements CompiledSQLExpression {
    private final CompiledSQLExpression left;
    private final CompiledSQLExpression[] values;

    public CompiledInExpression(CompiledSQLExpression left, CompiledSQLExpression[] values) {
        this.values = values;
        this.left = left;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.left.opEqualsTo(bean, context, this.values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        this.left.validate(context);
        for (CompiledSQLExpression op : this.values) {
            op.validate(context);
        }
    }

    public String toString() {
        return "IN{" + this.left + ", " + Arrays.toString(this.values) + '}';
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        CompiledSQLExpression[] remappedValues = new CompiledSQLExpression[this.values.length];
        int i = 0;
        for (CompiledSQLExpression exp : this.values) {
            remappedValues[i++] = exp.remapPositionalAccessToToPrimaryKeyAccessor(projection);
        }
        return new CompiledInExpression(this.left.remapPositionalAccessToToPrimaryKeyAccessor(projection), remappedValues);
    }
}

