/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledMinorThanExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;

public class CompiledGreaterThanEqualsExpression
extends CompiledBinarySQLExpression {
    public CompiledGreaterThanEqualsExpression(CompiledSQLExpression left, CompiledSQLExpression right) {
        super(left, right);
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        SQLRecordPredicateFunctions.CompareResult res = this.left.opCompareTo(bean, context, this.right);
        return res == SQLRecordPredicateFunctions.CompareResult.GREATER || res == SQLRecordPredicateFunctions.CompareResult.EQUALS;
    }

    @Override
    public String getOperator() {
        return ">=";
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        return new CompiledGreaterThanEqualsExpression(this.left.remapPositionalAccessToToPrimaryKeyAccessor(projection), this.right.remapPositionalAccessToToPrimaryKeyAccessor(projection));
    }

    @Override
    public CompiledBinarySQLExpression negate() {
        return new CompiledMinorThanExpression(this.left, this.right);
    }

    @Override
    public boolean isNegateSupported() {
        return true;
    }
}

