/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import java.sql.Timestamp;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.calcite.avatica.util.TimeUnitRange;

public class CompiledFunction
implements CompiledSQLExpression {
    private final String name;
    private final List<CompiledSQLExpression> parameters;
    private final long roundMultiplier;
    private final double roundSign;

    public CompiledFunction(String name, List<CompiledSQLExpression> parameters) {
        this.name = name;
        this.parameters = parameters;
        if (name.equals("round") && parameters.size() == 2) {
            if (parameters.size() == 2) {
                long precision;
                try {
                    precision = ((Number)parameters.get(1).evaluate(DataAccessor.NULL, null)).longValue();
                }
                catch (NullPointerException ex) {
                    throw new IllegalArgumentException("round second parameter must be a constant value");
                }
                long mult = 1L;
                int i = 0;
                while ((long)i < Math.abs(precision)) {
                    mult *= 10L;
                    ++i;
                }
                this.roundMultiplier = mult;
                this.roundSign = Math.signum(precision);
            } else {
                this.roundMultiplier = 0L;
                this.roundSign = 0.0;
            }
        } else {
            this.roundMultiplier = 0L;
            this.roundSign = 0.0;
        }
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        switch (this.name) {
            case "count": 
            case "sum": 
            case "min": 
            case "avg": 
            case "max": {
                return null;
            }
            case "lower": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                return parValue.toString().toLowerCase();
            }
            case "upper": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                return parValue.toString().toUpperCase();
            }
            case "abs": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                if (parValue instanceof Double) {
                    return Math.abs((Double)parValue);
                }
                return Math.abs((Long)parValue);
            }
            case "current_timestamp": {
                return context.getCurrentTimestamp();
            }
            case "CURRENT_DATE": {
                return context.getCurrentTimestamp();
            }
            case "rand": {
                return ThreadLocalRandom.current().nextInt();
            }
            case "round": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                if (this.roundSign == 0.0) {
                    return (double)Math.round((Double)parValue);
                }
                if (this.roundSign > 0.0) {
                    return (double)Math.round((Double)parValue * (double)this.roundMultiplier) / (double)this.roundMultiplier;
                }
                return (double)Math.round((Double)parValue / (double)this.roundMultiplier) * (double)this.roundMultiplier;
            }
            case "extract": {
                TimeUnitRange range = (TimeUnitRange)this.parameters.get(0).evaluate(bean, context);
                Object parValue = this.parameters.get(1).evaluate(bean, context);
                if (parValue == null) {
                    return null;
                }
                if (!(parValue instanceof Timestamp)) {
                    throw new StatementExecutionException("Cannot EXTRACT " + range + " FROM a " + parValue.getClass() + " value is " + parValue);
                }
                ZonedDateTime i = ((Timestamp)parValue).toInstant().atZone(context.getTimezone());
                switch (range) {
                    case YEAR: {
                        return i.get(ChronoField.YEAR);
                    }
                    case MONTH: {
                        return i.get(ChronoField.MONTH_OF_YEAR);
                    }
                    case DAY: {
                        return i.get(ChronoField.DAY_OF_MONTH);
                    }
                    case DOW: {
                        return i.get(ChronoField.DAY_OF_WEEK);
                    }
                    case HOUR: {
                        return i.get(ChronoField.HOUR_OF_DAY);
                    }
                    case MINUTE: {
                        return i.get(ChronoField.MINUTE_OF_HOUR);
                    }
                    case SECOND: {
                        return i.get(ChronoField.SECOND_OF_MINUTE);
                    }
                    case MILLISECOND: {
                        return i.get(ChronoField.MILLI_OF_SECOND);
                    }
                }
                throw new StatementExecutionException("Unsupported EXTRACT " + range);
            }
            case "floor": {
                Object parValue = this.parameters.get(0).evaluate(bean, context);
                if (parValue == null) {
                    return null;
                }
                TimeUnitRange range = (TimeUnitRange)this.parameters.get(1).evaluate(bean, context);
                if (!(parValue instanceof Timestamp)) {
                    throw new StatementExecutionException("Cannot FLOOR " + range + " FROM a " + parValue.getClass() + " value is " + parValue);
                }
                ZonedDateTime i = ((Timestamp)parValue).toInstant().atZone(context.getTimezone());
                switch (range) {
                    case DAY: {
                        return new Timestamp(i.toLocalDate().atStartOfDay(context.getTimezone()).toInstant().toEpochMilli());
                    }
                }
                throw new StatementExecutionException("Unsupported FLOOR " + range);
            }
        }
        throw new StatementExecutionException("unhandled function " + this.name + " operands " + this.parameters);
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        if (this.parameters != null) {
            this.parameters.forEach(expression -> expression.validate(context));
        }
    }

    public String toString() {
        if (this.roundMultiplier > 0L) {
            return "CompiledFunction{name=" + this.name + ", parameters=" + this.parameters + ", roundMultiplier=" + this.roundMultiplier + ", roundSign=" + this.roundSign + '}';
        }
        return "CompiledFunction{name=" + this.name + ", parameters=" + this.parameters + '}';
    }
}

