/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;

public class CompiledDivideIntExpression
extends CompiledBinarySQLExpression {
    public CompiledDivideIntExpression(CompiledSQLExpression left, CompiledSQLExpression right) {
        super(left, right);
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        Object rightValue;
        Object leftValue = this.left.evaluate(bean, context);
        Object res = SQLRecordPredicateFunctions.divide((Object)leftValue, (Object)(rightValue = this.right.evaluate(bean, context)));
        if (res == null) {
            return null;
        }
        if (res instanceof Number) {
            return ((Number)res).intValue();
        }
        throw new StatementExecutionException("Cannot Divide (int) " + leftValue + " and " + rightValue + ": result would be " + res);
    }
}

