/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.Column;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.AccessCurrentRowExpression;
import herddb.sql.expressions.BindableTableScanColumnNameResolver;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.ConstantExpression;
import herddb.sql.expressions.JdbcParameterExpression;
import herddb.sql.expressions.TypedJdbcParameterExpression;
import java.util.Collections;
import java.util.List;

public abstract class CompiledBinarySQLExpression
implements CompiledSQLExpression {
    protected final CompiledSQLExpression left;
    protected final CompiledSQLExpression right;

    public CompiledBinarySQLExpression(CompiledSQLExpression left, CompiledSQLExpression right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        this.left.validate(context);
        this.right.validate(context);
    }

    public String getOperator() {
        return "";
    }

    @Override
    public List<CompiledSQLExpression> scanForConstraintedValueOnColumnWithOperator(String column, String operator, BindableTableScanColumnNameResolver columnNameResolver) {
        if (!operator.equals(this.getOperator())) {
            return Collections.emptyList();
        }
        if ((this.right instanceof ConstantExpression || this.right instanceof TypedJdbcParameterExpression || this.right instanceof JdbcParameterExpression) && this.left instanceof AccessCurrentRowExpression) {
            AccessCurrentRowExpression ex = (AccessCurrentRowExpression)this.left;
            Column colName = columnNameResolver.resolveColumName(ex.getIndex());
            if (column.equals(colName.name)) {
                return Collections.singletonList(this.right.cast(colName.type));
            }
        }
        return Collections.emptyList();
    }

    @Override
    public List<CompiledSQLExpression> scanForConstraintsOnColumn(String column, BindableTableScanColumnNameResolver columnNameResolver) {
        if ((this.right instanceof ConstantExpression || this.right instanceof TypedJdbcParameterExpression || this.right instanceof JdbcParameterExpression) && this.left instanceof AccessCurrentRowExpression) {
            AccessCurrentRowExpression ex = (AccessCurrentRowExpression)this.left;
            Column colName = columnNameResolver.resolveColumName(ex.getIndex());
            if (column.equals(colName.name)) {
                return Collections.singletonList(this);
            }
        }
        return Collections.emptyList();
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        throw new IllegalStateException("no implemented");
    }

    @Override
    public int estimateObjectSizeForCache() {
        return 16 + this.right.estimateObjectSizeForCache() + this.left.estimateObjectSizeForCache();
    }

    public String toString() {
        return "BINARY-EXP{op=" + this.getOperator() + ", left=" + this.left + ", right=" + this.right + '}';
    }

    public boolean isNegateSupported() {
        return false;
    }

    public CompiledBinarySQLExpression negate() {
        throw new UnsupportedOperationException();
    }
}

