/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.AccessCurrentRowExpression;
import herddb.sql.expressions.BindableTableScanColumnNameResolver;
import herddb.sql.expressions.CompiledBinarySQLExpression;
import herddb.sql.expressions.CompiledEqualsExpression;
import herddb.sql.expressions.CompiledIsNullExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.ArrayList;
import java.util.List;

public class CompiledAndExpression
extends CompiledBinarySQLExpression {
    public CompiledAndExpression(CompiledSQLExpression left, CompiledSQLExpression right) {
        super(left, right);
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        boolean ok = SQLRecordPredicateFunctions.toBoolean((Object)this.left.evaluate(bean, context));
        if (!ok) {
            return false;
        }
        return SQLRecordPredicateFunctions.toBoolean((Object)this.right.evaluate(bean, context));
    }

    @Override
    public void validate(StatementEvaluationContext context) throws StatementExecutionException {
        this.left.validate(context);
        this.right.validate(context);
    }

    @Override
    public String toString() {
        return "CompiledAndExpression{left=" + this.left + ", right=" + this.right + '}';
    }

    @Override
    public List<CompiledSQLExpression> scanForConstraintsOnColumn(String column, BindableTableScanColumnNameResolver columnNameResolver) {
        ArrayList<CompiledSQLExpression> res = new ArrayList<CompiledSQLExpression>();
        res.addAll(this.left.scanForConstraintsOnColumn(column, columnNameResolver));
        res.addAll(this.right.scanForConstraintsOnColumn(column, columnNameResolver));
        return res;
    }

    @Override
    public List<CompiledSQLExpression> scanForConstraintedValueOnColumnWithOperator(String column, String operator, BindableTableScanColumnNameResolver columnNameResolver) {
        ArrayList<CompiledSQLExpression> res = new ArrayList<CompiledSQLExpression>();
        res.addAll(this.left.scanForConstraintedValueOnColumnWithOperator(column, operator, columnNameResolver));
        res.addAll(this.right.scanForConstraintedValueOnColumnWithOperator(column, operator, columnNameResolver));
        return res;
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        CompiledSQLExpression remappedLeft = this.left.remapPositionalAccessToToPrimaryKeyAccessor(projection);
        CompiledSQLExpression remappedRight = this.right.remapPositionalAccessToToPrimaryKeyAccessor(projection);
        return new CompiledAndExpression(remappedLeft, remappedRight);
    }

    @Override
    public CompiledSQLExpression simplify() {
        CompiledEqualsExpression eq;
        CompiledBinarySQLExpression l;
        if (this.left instanceof CompiledBinarySQLExpression && (l = (CompiledBinarySQLExpression)this.left) instanceof CompiledEqualsExpression && (eq = (CompiledEqualsExpression)l).getLeft() instanceof AccessCurrentRowExpression) {
            AccessCurrentRowExpression accessFieldOnRight;
            CompiledIsNullExpression r;
            AccessCurrentRowExpression accessField = (AccessCurrentRowExpression)eq.getLeft();
            if (this.right instanceof CompiledIsNullExpression && (r = (CompiledIsNullExpression)this.right).isNot() && r.getLeft() instanceof AccessCurrentRowExpression && (accessFieldOnRight = (AccessCurrentRowExpression)r.getLeft()).getIndex() == accessField.getIndex()) {
                return this.left;
            }
        }
        return this;
    }
}

