/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.Column;

public final class ColumnRef {
    public final String name;
    public final String tableName;
    public final int type;

    public ColumnRef(String tableName, Column column) {
        this.tableName = tableName;
        this.name = column.name;
        this.type = column.type;
    }

    public ColumnRef(String name, String tableName, int type) {
        this.name = name;
        this.tableName = tableName;
        this.type = type;
    }

    public static Column[] toColumnsArray(ColumnRef[] a) {
        Column[] c = new Column[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i].toColumn();
        }
        return c;
    }

    public static ColumnRef[] toColumnsRefsArray(String tableName, Column[] a) {
        ColumnRef[] c = new ColumnRef[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = new ColumnRef(tableName, a[i]);
        }
        return c;
    }

    public Column toColumn() {
        return Column.column(this.name, this.type);
    }

    public String toString() {
        return this.tableName + "." + this.name + " (type=" + this.type + ")";
    }
}

