/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql.expressions;

import herddb.model.ColumnTypes;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import java.util.Arrays;

public class AccessCurrentRowExpression
implements CompiledSQLExpression {
    private final int index;
    private final int expectedType;

    public AccessCurrentRowExpression(int index, int type) {
        this.index = index;
        this.expectedType = type;
    }

    @Override
    public Object evaluate(DataAccessor bean, StatementEvaluationContext context) throws StatementExecutionException {
        return bean.get(this.index);
    }

    @Override
    public boolean opEqualsTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object rightValue = right.evaluate(bean, context);
        if (rightValue == null) {
            return false;
        }
        return bean.fieldEqualsTo(this.index, rightValue);
    }

    @Override
    public boolean opNotEqualsTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object rightValue = right.evaluate(bean, context);
        if (rightValue == null) {
            return false;
        }
        return bean.fieldNotEqualsTo(this.index, rightValue);
    }

    @Override
    public SQLRecordPredicateFunctions.CompareResult opCompareTo(DataAccessor bean, StatementEvaluationContext context, CompiledSQLExpression right) throws StatementExecutionException {
        Object rightValue = right.evaluate(bean, context);
        if (rightValue == null) {
            return SQLRecordPredicateFunctions.CompareResult.NULL;
        }
        return bean.fieldCompareTo(this.index, rightValue);
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        return "AccessCurrentRow{" + this.index + ", type=" + ColumnTypes.typeToString(this.expectedType) + '}';
    }

    @Override
    public CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(int[] projection) {
        int _index = projection[this.index];
        if (_index < 0) {
            throw new IllegalStateException("column " + this.index + " not in pk, projection:" + Arrays.toString(projection));
        }
        return new AccessCurrentRowExpression(_index, this.expectedType);
    }

    public int getExpectedType() {
        return this.expectedType;
    }
}

