/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import herddb.model.ExecutionPlan;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PlansCache {
    private static final Logger LOG = Logger.getLogger(PlansCache.class.getName());
    private final Cache<String, ExecutionPlanContainer> cache;

    public PlansCache(long maxBytes) {
        LOG.log(Level.INFO, "Max query plan cache size: {0} bytes", maxBytes + "");
        this.cache = CacheBuilder.newBuilder().recordStats().weigher((sql, plan) -> ((ExecutionPlanContainer)plan).weight).maximumWeight(maxBytes).removalListener(notification -> LOG.log(Level.FINE, "Removed query {0} -> {1} size {2} bytes", new Object[]{notification.getCause(), notification.getKey(), ((ExecutionPlanContainer)notification.getValue()).weight})).build();
    }

    public long getCacheSize() {
        return this.cache.size();
    }

    public long getCacheHits() {
        return this.cache.stats().hitCount();
    }

    public long getCacheMisses() {
        return this.cache.stats().missCount();
    }

    public ExecutionPlan get(String sql) {
        ExecutionPlanContainer res = (ExecutionPlanContainer)this.cache.getIfPresent((Object)sql);
        return res != null ? res.plan : null;
    }

    public void put(String sql, ExecutionPlan statement) {
        this.cache.put((Object)sql, (Object)new ExecutionPlanContainer(statement));
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    private static class ExecutionPlanContainer {
        private final ExecutionPlan plan;
        private final int weight;

        public ExecutionPlanContainer(ExecutionPlan plan) {
            this.plan = plan;
            this.weight = plan.estimateObjectSizeForCache();
        }
    }
}

