/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import herddb.core.AbstractIndexManager;
import herddb.core.AbstractTableManager;
import herddb.core.DBManager;
import herddb.core.HerdDBInternalException;
import herddb.core.TableSpaceManager;
import herddb.metadata.MetadataStorageManagerException;
import herddb.model.AutoIncrementPrimaryKeyRecordFunction;
import herddb.model.ColumnTypes;
import herddb.model.DMLStatement;
import herddb.model.ExecutionPlan;
import herddb.model.ForeignKeyDef;
import herddb.model.Index;
import herddb.model.Projection;
import herddb.model.RecordFunction;
import herddb.model.ScanLimits;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.model.TableDoesNotExistException;
import herddb.model.TableSpace;
import herddb.model.TableSpaceDoesNotExistException;
import herddb.model.TupleComparator;
import herddb.model.commands.AlterTableSpaceStatement;
import herddb.model.commands.AlterTableStatement;
import herddb.model.commands.BeginTransactionStatement;
import herddb.model.commands.CommitTransactionStatement;
import herddb.model.commands.CreateIndexStatement;
import herddb.model.commands.CreateTableSpaceStatement;
import herddb.model.commands.CreateTableStatement;
import herddb.model.commands.DeleteStatement;
import herddb.model.commands.DropIndexStatement;
import herddb.model.commands.DropTableSpaceStatement;
import herddb.model.commands.DropTableStatement;
import herddb.model.commands.GetStatement;
import herddb.model.commands.InsertStatement;
import herddb.model.commands.RollbackTransactionStatement;
import herddb.model.commands.SQLPlannedOperationStatement;
import herddb.model.commands.ScanStatement;
import herddb.model.commands.TableConsistencyCheckStatement;
import herddb.model.commands.TableSpaceConsistencyCheckStatement;
import herddb.model.commands.TruncateTableStatement;
import herddb.model.commands.UpdateStatement;
import herddb.model.planner.AggregateOp;
import herddb.model.planner.BindableTableScanOp;
import herddb.model.planner.FilterOp;
import herddb.model.planner.InsertOp;
import herddb.model.planner.JoinOp;
import herddb.model.planner.LimitOp;
import herddb.model.planner.PlannerOp;
import herddb.model.planner.ProjectOp;
import herddb.model.planner.SimpleDeleteOp;
import herddb.model.planner.SimpleInsertOp;
import herddb.model.planner.SimpleUpdateOp;
import herddb.model.planner.SortOp;
import herddb.model.planner.UnionAllOp;
import herddb.model.planner.ValuesOp;
import herddb.sql.AbstractSQLPlanner;
import herddb.sql.IndexUtils;
import herddb.sql.PlansCache;
import herddb.sql.SQLRecordFunction;
import herddb.sql.SQLRecordKeyFunction;
import herddb.sql.SQLRecordPredicate;
import herddb.sql.SQLStatementEvaluationContext;
import herddb.sql.TranslatedQuery;
import herddb.sql.expressions.AccessCurrentRowExpression;
import herddb.sql.expressions.ColumnRef;
import herddb.sql.expressions.CompiledEqualsExpression;
import herddb.sql.expressions.CompiledFunction;
import herddb.sql.expressions.CompiledMultiAndExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import herddb.sql.expressions.ConstantExpression;
import herddb.sql.expressions.JdbcParameterExpression;
import herddb.sql.expressions.OpSchema;
import herddb.sql.expressions.SQLParserExpressionCompiler;
import herddb.sql.expressions.TypedJdbcParameterExpression;
import herddb.sql.functions.ShowCreateTableCalculator;
import herddb.utils.Bytes;
import herddb.utils.IntHolder;
import herddb.utils.SQLUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.Provider;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.ForeignKeyIndex;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.execute.Execute;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperation;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.UnionOp;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.upsert.Upsert;

public class JSQLParserPlanner
extends AbstractSQLPlanner {
    public static final String TABLE_CONSISTENCY_COMMAND = "tableconsistencycheck";
    public static final String TABLESPACE_CONSISTENCY_COMMAND = "tablespaceconsistencycheck";
    private final PlansCache cache;
    private final AbstractSQLPlanner fallback;
    private static final Logger LOG = Logger.getLogger(JSQLParserPlanner.class.getName());

    public static String delimit(String name) {
        if (name == null) {
            return null;
        }
        return "`" + name + "`";
    }

    @Override
    public long getCacheSize() {
        return this.cache.getCacheSize();
    }

    @Override
    public long getCacheHits() {
        return this.cache.getCacheHits();
    }

    @Override
    public long getCacheMisses() {
        return this.cache.getCacheMisses();
    }

    @Override
    public void clearCache() {
        this.cache.clear();
        if (this.fallback != null) {
            this.fallback.clearCache();
        }
    }

    public JSQLParserPlanner(DBManager manager, PlansCache plansCache, AbstractSQLPlanner fallback) {
        super(manager);
        this.cache = plansCache;
        this.fallback = fallback;
    }

    public static String rewriteExecuteSyntax(String query) {
        char ch = query.charAt(0);
        switch (ch) {
            case 'A': 
            case 'a': {
                if (query.regionMatches(true, 0, "ALTER TABLESPACE ", 0, 17)) {
                    return "EXECUTE altertablespace " + query.substring(17);
                }
                return query;
            }
            case 'B': 
            case 'b': {
                if (query.regionMatches(true, 0, "BEGIN TRANSACTION", 0, 17)) {
                    return "EXECUTE begintransaction" + query.substring(17);
                }
                return query;
            }
            case 'C': 
            case 'c': {
                ch = query.charAt(1);
                switch (ch) {
                    case 'O': 
                    case 'o': {
                        if (!query.regionMatches(true, 0, "COMMIT TRANSACTION", 0, 18)) break;
                        return "EXECUTE committransaction" + query.substring(18);
                    }
                    case 'R': 
                    case 'r': {
                        if (!query.regionMatches(true, 0, "CREATE TABLESPACE ", 0, 18)) break;
                        return "EXECUTE createtablespace " + query.substring(18);
                    }
                }
                return query;
            }
            case 'D': 
            case 'd': {
                if (query.regionMatches(true, 0, "DROP TABLESPACE ", 0, 16)) {
                    return "EXECUTE droptablespace " + query.substring(16);
                }
                return query;
            }
            case 'R': 
            case 'r': {
                if (query.regionMatches(true, 0, "ROLLBACK TRANSACTION", 0, 20)) {
                    return "EXECUTE rollbacktransaction" + query.substring(20);
                }
                return query;
            }
            case 'T': 
            case 't': {
                if (query.regionMatches(true, 0, "TRUNCATE", 0, 8)) {
                    return "TRUNCATE" + query.substring(8);
                }
                return query;
            }
        }
        return query;
    }

    @Override
    public TranslatedQuery translate(String defaultTableSpace, String query, List<Object> parameters, boolean scan, boolean allowCache, boolean returnValues, int maxRows) throws StatementExecutionException {
        int idx;
        this.ensureDefaultTableSpaceBootedLocally(defaultTableSpace);
        if (parameters == null) {
            parameters = Collections.emptyList();
        }
        if ((idx = SQLUtils.findQueryStart((String)query)) != -1) {
            query = query.substring(idx);
        }
        if ((query = JSQLParserPlanner.rewriteExecuteSyntax(query)).startsWith("ALTER TABLE") && query.contains("ADD FOREIGN KEY")) {
            query = query.replace("ADD FOREIGN KEY", "ADD CONSTRAINT generate_unnamed FOREIGN KEY");
        }
        if (query.startsWith("EXPLAIN ")) {
            Statement stmt = this.parseStatement(query = query.substring("EXPLAIN ".length()));
            if (!JSQLParserPlanner.isCachable(stmt)) {
                allowCache = false;
            }
            ExecutionPlan queryExecutionPlan = this.plan(defaultTableSpace, stmt, scan, returnValues, maxRows);
            PlannerOp finalPlan = queryExecutionPlan.originalRoot;
            ValuesOp values = new ValuesOp(this.manager.getNodeId(), new String[]{"name", "value"}, new herddb.model.Column[]{herddb.model.Column.column("name", 0), herddb.model.Column.column("value", 0)}, Arrays.asList(Arrays.asList(new ConstantExpression("query", 11), new ConstantExpression(query, 11)), Arrays.asList(new ConstantExpression("logicalplan", 11), new ConstantExpression(stmt + "", 11)), Arrays.asList(new ConstantExpression("plan", 11), new ConstantExpression(finalPlan + "", 11)), Arrays.asList(new ConstantExpression("finalplan", 11), new ConstantExpression(finalPlan.optimize(), 11))));
            ExecutionPlan executionPlan = ExecutionPlan.simple(new SQLPlannedOperationStatement(values), values);
            return new TranslatedQuery(executionPlan, new SQLStatementEvaluationContext(query, parameters, false, false));
        }
        if (query.startsWith("SHOW")) {
            return ShowCreateTableCalculator.calculateShowCreateTable(query, defaultTableSpace, parameters, this.manager);
        }
        String cacheKey = "scan:" + scan + ",defaultTableSpace:" + defaultTableSpace + ",query:" + query + ",returnValues:" + returnValues + ",maxRows:" + maxRows;
        try {
            ExecutionPlan executionPlan;
            ExecutionPlan cached;
            boolean forceAcquireWriteLock;
            if (query.endsWith(" FOR UPDATE") && query.substring(0, 6).toLowerCase().equals("select")) {
                forceAcquireWriteLock = true;
                query = query.substring(0, query.length() - " FOR UPDATE".length());
            } else {
                forceAcquireWriteLock = false;
            }
            if (allowCache && (cached = this.cache.get(cacheKey)) != null) {
                return new TranslatedQuery(cached, new SQLStatementEvaluationContext(query, parameters, forceAcquireWriteLock, false));
            }
            if (query.startsWith(TABLE_CONSISTENCY_COMMAND)) {
                executionPlan = ExecutionPlan.simple(this.queryConsistencyCheckStatement(defaultTableSpace, query, parameters));
                return new TranslatedQuery(executionPlan, new SQLStatementEvaluationContext(query, parameters, false, false));
            }
            if (query.startsWith(TABLESPACE_CONSISTENCY_COMMAND)) {
                executionPlan = ExecutionPlan.simple(this.queryConsistencyCheckStatement(query));
                return new TranslatedQuery(executionPlan, new SQLStatementEvaluationContext(query, parameters, false, false));
            }
            Statement stmt = this.parseStatement(query);
            if (!JSQLParserPlanner.isCachable(stmt)) {
                allowCache = false;
            }
            ExecutionPlan executionPlan2 = this.plan(defaultTableSpace, stmt, scan, returnValues, maxRows);
            if (LOG.isLoggable(DUMP_QUERY_LEVEL)) {
                LOG.log(DUMP_QUERY_LEVEL, "Query: {0} --HerdDB Plan\n{1}", new Object[]{query, executionPlan2.mainStatement});
            }
            if (allowCache) {
                this.cache.put(cacheKey, executionPlan2);
            }
            return new TranslatedQuery(executionPlan2, new SQLStatementEvaluationContext(query, parameters, forceAcquireWriteLock, false));
        }
        catch (StatementNotSupportedException err) {
            if (this.fallback == null) {
                throw new StatementExecutionException("I am sorry, I cannot plan SQL \"" + query + "\" with simple jSQLParser planner, consider setting " + "server.planner.type" + "=" + "auto", (Throwable)((Object)err));
            }
            TranslatedQuery res = this.fallback.translate(defaultTableSpace, query, parameters, scan, allowCache, returnValues, maxRows);
            if (allowCache) {
                this.cache.put(cacheKey, res.plan);
            }
            return res;
        }
    }

    private Statement parseStatement(String query) throws StatementExecutionException {
        CCJSqlParser parser = new CCJSqlParser((Provider)new StringProvider(query));
        try {
            return parser.Statement();
        }
        catch (ParseException err) {
            throw new StatementExecutionException("unable to parse query " + query, err);
        }
    }

    private ExecutionPlan plan(String defaultTableSpace, Statement stmt, boolean scan, boolean returnValues, int maxRows) {
        ExecutionPlan result;
        if (stmt instanceof CreateTable) {
            result = ExecutionPlan.simple(this.buildCreateTableStatement(defaultTableSpace, (CreateTable)stmt));
        } else if (stmt instanceof CreateIndex) {
            result = ExecutionPlan.simple(this.buildCreateIndexStatement(defaultTableSpace, (CreateIndex)stmt));
        } else if (stmt instanceof Execute) {
            result = ExecutionPlan.simple(this.buildExecuteStatement(defaultTableSpace, (Execute)stmt));
        } else if (stmt instanceof Alter) {
            result = ExecutionPlan.simple(this.buildAlterStatement(defaultTableSpace, (Alter)stmt));
        } else if (stmt instanceof Drop) {
            result = ExecutionPlan.simple(this.buildDropStatement(defaultTableSpace, (Drop)stmt));
        } else if (stmt instanceof Truncate) {
            result = ExecutionPlan.simple(this.buildTruncateStatement(defaultTableSpace, (Truncate)stmt));
        } else if (stmt instanceof Insert) {
            result = this.buildInsertStatement(defaultTableSpace, (Insert)stmt, returnValues);
        } else if (stmt instanceof Upsert) {
            result = this.buildUpsertStatement(defaultTableSpace, (Upsert)stmt, returnValues);
        } else if (stmt instanceof Update) {
            result = this.buildUpdateStatement(defaultTableSpace, (Update)stmt, returnValues);
        } else if (stmt instanceof Select) {
            result = this.buildSelectStatement(defaultTableSpace, maxRows, (Select)stmt, scan);
        } else if (stmt instanceof Delete) {
            result = this.buildDeleteStatement(defaultTableSpace, (Delete)stmt);
        } else {
            throw new StatementNotSupportedException("Not implemented " + stmt.getClass().getName());
        }
        return result;
    }

    private static boolean isCachable(Statement stmt) {
        if (stmt instanceof Execute) {
            return false;
        }
        if (stmt instanceof Alter) {
            return false;
        }
        if (stmt instanceof Drop) {
            return false;
        }
        return !(stmt instanceof Truncate);
    }

    private herddb.model.Statement buildCreateTableStatement(String defaultTableSpace, CreateTable s) throws StatementExecutionException {
        String tableSpace = SQLParserExpressionCompiler.fixMySqlBackTicks(s.getTable().getSchemaName());
        String tableName = SQLParserExpressionCompiler.fixMySqlBackTicks(s.getTable().getName());
        if (tableSpace == null) {
            tableSpace = defaultTableSpace;
        }
        if (s.getColumnDefinitions() == null) {
            throw new StatementExecutionException("A table must have at least 1 column");
        }
        boolean isNotExsists = s.isIfNotExists();
        try {
            boolean foundPk = false;
            Table.Builder tablebuilder = herddb.model.Table.builder().uuid(UUID.randomUUID().toString()).name(tableName).tablespace(tableSpace);
            HashSet<String> primaryKey = new HashSet<String>();
            HashSet<String> simpleUniqueFields = new HashSet<String>();
            if (s.getIndexes() != null) {
                for (net.sf.jsqlparser.statement.create.table.Index index : s.getIndexes()) {
                    if (!index.getType().equalsIgnoreCase("PRIMARY KEY")) continue;
                    for (String n : index.getColumnsNames()) {
                        n = SQLParserExpressionCompiler.fixMySqlBackTicks(n.toLowerCase());
                        tablebuilder.primaryKey(n);
                        primaryKey.add(n);
                        foundPk = true;
                    }
                }
            }
            int position = 0;
            for (ColumnDefinition cf : s.getColumnDefinitions()) {
                String columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(cf.getColumnName().toLowerCase());
                String dataType = cf.getColDataType().getDataType();
                List<String> columnSpecs = this.decodeColumnSpecs(cf.getColumnSpecs());
                int type = JSQLParserPlanner.sqlDataTypeToColumnType(dataType, cf.getColDataType().getArgumentsStringList(), columnSpecs);
                Bytes defaultValue = JSQLParserPlanner.decodeDefaultValue(cf, type);
                if (!columnSpecs.isEmpty()) {
                    boolean isUnique;
                    boolean auto_increment = this.decodeAutoIncrement(columnSpecs);
                    if (columnSpecs.contains("PRIMARY")) {
                        foundPk = true;
                        tablebuilder.primaryKey(columnName, auto_increment);
                    }
                    if (auto_increment && primaryKey.contains(columnName)) {
                        tablebuilder.primaryKey(columnName, auto_increment);
                    }
                    if (isUnique = columnSpecs.contains("UNIQUE")) {
                        simpleUniqueFields.add(columnName);
                    }
                }
                tablebuilder.column(columnName, type, position++, defaultValue);
            }
            if (!foundPk) {
                tablebuilder.column("_pk", 1, position++, null);
                tablebuilder.primaryKey("_pk", true);
            }
            herddb.model.Table table = tablebuilder.build();
            ArrayList<Index> otherIndexes = new ArrayList<Index>();
            ArrayList<ForeignKeyDef> foreignKeys = new ArrayList<ForeignKeyDef>();
            if (s.getIndexes() != null) {
                for (net.sf.jsqlparser.statement.create.table.Index index : s.getIndexes()) {
                    if (index.getType().equalsIgnoreCase("PRIMARY KEY")) continue;
                    if (index.getType().equalsIgnoreCase("INDEX") || index.getType().equalsIgnoreCase("KEY") || index.getType().equalsIgnoreCase("UNIQUE KEY")) {
                        String indexName = SQLParserExpressionCompiler.fixMySqlBackTicks(index.getName().toLowerCase());
                        String indexType = JSQLParserPlanner.convertIndexType(null);
                        boolean unique = index.getType().equalsIgnoreCase("UNIQUE KEY");
                        Index.Builder builder = Index.builder().onTable(table).name(indexName).unique(unique).type(indexType).uuid(UUID.randomUUID().toString());
                        for (String columnName : index.getColumnsNames()) {
                            herddb.model.Column column = table.getColumn(columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(columnName.toLowerCase()));
                            if (column == null) {
                                throw new StatementExecutionException("no such column " + columnName + " on table " + tableName + " in tablespace " + tableSpace);
                            }
                            builder.column(column.name, column.type);
                        }
                        otherIndexes.add(builder.build());
                        continue;
                    }
                    if (index.getType().equals("FOREIGN KEY")) {
                        ForeignKeyIndex fk = (ForeignKeyIndex)index;
                        ForeignKeyDef fkDef = this.parseForeignKeyIndex(fk, table, tableName, tableSpace);
                        foreignKeys.add(fkDef);
                        continue;
                    }
                    throw new StatementExecutionException("Unsupported index type " + index.getType());
                }
            }
            for (String col : simpleUniqueFields) {
                Index.Builder builder = Index.builder().onTable(table).name(table.name + "_unique_" + col).unique(true).type("brin").uuid(UUID.randomUUID().toString()).column(col, table.getColumn((String)col).type);
                otherIndexes.add(builder.build());
            }
            if (!foreignKeys.isEmpty()) {
                table = table.withForeignKeys(foreignKeys.toArray(new ForeignKeyDef[0]));
            }
            CreateTableStatement statement = new CreateTableStatement(table, otherIndexes, isNotExsists);
            return statement;
        }
        catch (IllegalArgumentException err) {
            throw new StatementExecutionException("bad table definition: " + err.getMessage(), err);
        }
    }

    private ForeignKeyDef parseForeignKeyIndex(ForeignKeyIndex fk, herddb.model.Table table, String tableName, String tableSpace) throws StatementExecutionException {
        herddb.model.Column column;
        String indexName = SQLParserExpressionCompiler.fixMySqlBackTicks(fk.getName().toLowerCase());
        if (indexName.equals("generate_unnamed")) {
            indexName = "fk_" + tableName + "_" + System.nanoTime();
        }
        int onUpdateCascadeAction = JSQLParserPlanner.parseForeignKeyAction(fk.getOnUpdateReferenceOption());
        int onDeleteCascadeAction = JSQLParserPlanner.parseForeignKeyAction(fk.getOnDeleteReferenceOption());
        herddb.model.Table parentTableSchema = this.getTable(table.tablespace, fk.getTable());
        ForeignKeyDef.Builder builder = ForeignKeyDef.builder().name(indexName).parentTableId(parentTableSchema.uuid).onUpdateAction(onUpdateCascadeAction).onDeleteAction(onDeleteCascadeAction);
        for (String columnName : fk.getColumnsNames()) {
            column = table.getColumn(columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(columnName.toLowerCase()));
            if (column == null) {
                throw new StatementExecutionException("no such column " + columnName + " on table " + tableName + " in tablespace " + tableSpace);
            }
            builder.column(column.name);
        }
        for (String columnName : fk.getReferencedColumnNames()) {
            column = parentTableSchema.getColumn(columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(columnName.toLowerCase()));
            if (column == null) {
                throw new StatementExecutionException("no such column " + columnName + " on table " + parentTableSchema.name + " in tablespace " + parentTableSchema.tablespace);
            }
            builder.parentTableColumn(column.name);
        }
        ForeignKeyDef fkDef = builder.build();
        return fkDef;
    }

    private static int parseForeignKeyAction(String def) throws StatementExecutionException {
        int outcome;
        if (def == null) {
            def = "NO ACTION";
        }
        switch (def.toUpperCase().trim()) {
            case "NO ACTION": 
            case "RESTRICT": {
                outcome = 0;
                break;
            }
            case "CASCADE": {
                outcome = 1;
                break;
            }
            case "SET NULL": {
                outcome = 2;
                break;
            }
            default: {
                throw new StatementExecutionException("Unsupported option " + def);
            }
        }
        return outcome;
    }

    private boolean decodeAutoIncrement(List<String> columnSpecs) {
        boolean auto_increment = columnSpecs.contains("AUTO_INCREMENT");
        return auto_increment;
    }

    private List<String> decodeColumnSpecs(List<String> columnSpecs) {
        if (columnSpecs == null || columnSpecs.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> columnSpecsDecoded = columnSpecs.stream().map(String::toUpperCase).collect(Collectors.toList());
        return columnSpecsDecoded;
    }

    private herddb.model.Statement buildCreateIndexStatement(String defaultTableSpace, CreateIndex s) throws StatementExecutionException {
        try {
            String tableSpace = s.getTable().getSchemaName();
            if (tableSpace == null) {
                tableSpace = defaultTableSpace;
            }
            tableSpace = SQLParserExpressionCompiler.fixMySqlBackTicks(tableSpace);
            String tableName = SQLParserExpressionCompiler.fixMySqlBackTicks(s.getTable().getName().toLowerCase());
            String indexName = SQLParserExpressionCompiler.fixMySqlBackTicks(s.getIndex().getName().toLowerCase());
            boolean unique = JSQLParserPlanner.isUnique(s.getIndex().getType());
            String indexType = JSQLParserPlanner.convertIndexType(s.getIndex().getType());
            Index.Builder builder = Index.builder().name(indexName).uuid(UUID.randomUUID().toString()).type(indexType).unique(unique).table(tableName).tablespace(tableSpace);
            AbstractTableManager tableDefinition = this.manager.getTableSpaceManager(tableSpace).getTableManager(tableName);
            if (tableDefinition == null) {
                throw new TableDoesNotExistException("no such table " + tableName + " in tablespace " + tableSpace);
            }
            for (String columnName : s.getIndex().getColumnsNames()) {
                columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(columnName.toLowerCase());
                herddb.model.Column column = tableDefinition.getTable().getColumn(columnName);
                if (column == null) {
                    throw new StatementExecutionException("no such column " + columnName + " on table " + tableName + " in tablespace " + tableSpace);
                }
                builder.column(column.name, column.type);
            }
            CreateIndexStatement statement = new CreateIndexStatement(builder.build());
            return statement;
        }
        catch (IllegalArgumentException err) {
            throw new StatementExecutionException("bad index definition: " + err.getMessage(), err);
        }
    }

    private static boolean isUnique(String indexType) throws StatementExecutionException {
        return indexType != null && indexType.equalsIgnoreCase("UNIQUE");
    }

    private static String convertIndexType(String indexType) throws StatementExecutionException {
        if ((indexType = indexType == null ? "brin" : indexType.toLowerCase()).equals("unique")) {
            return "brin";
        }
        switch (indexType) {
            case "hash": 
            case "brin": {
                break;
            }
            default: {
                throw new StatementExecutionException("Invalid index type " + indexType);
            }
        }
        return indexType;
    }

    public static int sqlDataTypeToColumnType(ColDataType dataType) throws StatementExecutionException {
        return JSQLParserPlanner.sqlDataTypeToColumnType(dataType.getDataType(), dataType.getArgumentsStringList(), Collections.emptyList());
    }

    private static int sqlDataTypeToColumnType(String dataType, List<String> arguments, List<String> columnSpecs) throws StatementExecutionException {
        int type;
        switch (dataType.toLowerCase()) {
            case "string": 
            case "varchar": 
            case "nvarchar": 
            case "nvarchar2": 
            case "nclob": 
            case "text": 
            case "longtext": 
            case "clob": 
            case "char": {
                type = 0;
                break;
            }
            case "long": 
            case "bigint": {
                type = 1;
                break;
            }
            case "int": 
            case "integer": 
            case "tinyint": 
            case "smallint": {
                type = 2;
                break;
            }
            case "bytea": 
            case "blob": 
            case "image": {
                type = 3;
                break;
            }
            case "timestamp": 
            case "timestamptz": 
            case "timestamp with time zone": 
            case "datetime": 
            case "date": 
            case "time": 
            case "time with time zone": {
                type = 4;
                break;
            }
            case "boolean": 
            case "bool": 
            case "bit": {
                type = 7;
                break;
            }
            case "double": 
            case "float": 
            case "real": {
                type = 6;
                break;
            }
            case "numeric": 
            case "decimal": {
                if (arguments == null || arguments.isEmpty()) {
                    type = 6;
                    break;
                }
                if (arguments.size() == 2) {
                    int precision = Integer.parseInt(arguments.get(0));
                    int scale = Integer.parseInt(arguments.get(1));
                    if (scale == 0) {
                        if (precision > 0) {
                            type = 2;
                            break;
                        }
                        type = 1;
                        break;
                    }
                    type = 6;
                    break;
                }
                throw new StatementExecutionException("bad type " + dataType + " with arguments " + arguments);
            }
            default: {
                throw new StatementExecutionException("bad type " + dataType);
            }
        }
        if (String.join((CharSequence)"_", columnSpecs).contains("NOT_NULL")) {
            type = ColumnTypes.getNonNullTypeForPrimitiveType(type);
        }
        return type;
    }

    public static ConstantExpression resolveValueAsCompiledSQLExpression(Expression expression, boolean allowColumn) throws StatementExecutionException {
        Object res = JSQLParserPlanner.resolveValue(expression, allowColumn);
        if (res == null) {
            return new ConstantExpression(null, 5);
        }
        if (res instanceof String) {
            return new ConstantExpression(res, 11);
        }
        if (res instanceof Long) {
            return new ConstantExpression(res, 13);
        }
        if (res instanceof Integer) {
            return new ConstantExpression(res, 12);
        }
        if (res instanceof Double) {
            return new ConstantExpression(res, 16);
        }
        if (res instanceof Timestamp) {
            return new ConstantExpression(res, 15);
        }
        return new ConstantExpression(res, 10);
    }

    public static Object resolveValue(Expression expression, boolean allowColumn) throws StatementExecutionException {
        if (expression instanceof JdbcParameter) {
            throw new StatementExecutionException("jdbcparameter expression not usable in this query");
        }
        if (allowColumn && expression instanceof Column) {
            return SQLParserExpressionCompiler.fixMySqlBackTicks(((Column)expression).getColumnName());
        }
        if (expression instanceof StringValue) {
            return ((StringValue)expression).getValue();
        }
        if (expression instanceof LongValue) {
            return ((LongValue)expression).getValue();
        }
        if (expression instanceof DoubleValue) {
            return ((DoubleValue)expression).getValue();
        }
        if (expression instanceof NullValue) {
            return null;
        }
        if (expression instanceof TimestampValue) {
            return ((TimestampValue)expression).getValue();
        }
        if (expression instanceof SignedExpression) {
            SignedExpression se = (SignedExpression)expression;
            switch (se.getSign()) {
                case '+': {
                    return JSQLParserPlanner.resolveValue(se.getExpression(), allowColumn);
                }
                case '-': {
                    Object value = JSQLParserPlanner.resolveValue(se.getExpression(), allowColumn);
                    if (value == null) {
                        return null;
                    }
                    if (value instanceof Integer) {
                        return -1L * (long)((Integer)value).intValue();
                    }
                    if (value instanceof Long) {
                        return -1L * (Long)value;
                    }
                    throw new StatementExecutionException("unsupported value type " + expression.getClass() + " with sign " + se.getSign() + " on value " + value + " of type " + value.getClass());
                }
            }
            throw new StatementExecutionException("unsupported value type " + expression.getClass() + " with sign " + se.getSign());
        }
        throw new StatementExecutionException("unsupported value type " + expression.getClass());
    }

    private herddb.model.Statement buildExecuteStatement(String defaultTableSpace, Execute execute) throws StatementExecutionException {
        switch (execute.getName().toUpperCase()) {
            case "BEGINTRANSACTION": {
                if (execute.getExprList() == null || execute.getExprList().getExpressions().size() != 1) {
                    throw new StatementExecutionException("BEGINTRANSACTION requires one parameter (EXECUTE BEGINTRANSACTION tableSpaceName)");
                }
                Object tableSpaceName = JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(0), true);
                if (tableSpaceName == null) {
                    throw new StatementExecutionException("BEGINTRANSACTION requires one parameter (EXECUTE BEGINTRANSACTION tableSpaceName)");
                }
                return new BeginTransactionStatement(tableSpaceName.toString());
            }
            case "COMMITTRANSACTION": {
                if (execute.getExprList() == null || execute.getExprList().getExpressions().size() != 2) {
                    throw new StatementExecutionException("COMMITTRANSACTION requires two parameters (EXECUTE COMMITTRANSACTION tableSpaceName transactionId)");
                }
                Object tableSpaceName = JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(0), true);
                if (tableSpaceName == null) {
                    throw new StatementExecutionException("COMMITTRANSACTION requires two parameters (EXECUTE COMMITTRANSACTION tableSpaceName transactionId)");
                }
                Object transactionId = JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(1), true);
                if (transactionId == null) {
                    throw new StatementExecutionException("COMMITTRANSACTION requires two parameters (EXECUTE COMMITTRANSACTION tableSpaceName transactionId)");
                }
                try {
                    return new CommitTransactionStatement(tableSpaceName.toString(), Long.parseLong(transactionId.toString()));
                }
                catch (NumberFormatException err) {
                    throw new StatementExecutionException("COMMITTRANSACTION requires two parameters (EXECUTE COMMITTRANSACTION tableSpaceName transactionId)");
                }
            }
            case "ROLLBACKTRANSACTION": {
                if (execute.getExprList() == null || execute.getExprList().getExpressions().size() != 2) {
                    throw new StatementExecutionException("COMMITTRANSACTION requires two parameters (EXECUTE ROLLBACKTRANSACTION tableSpaceName transactionId)");
                }
                Object tableSpaceName = JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(0), true);
                if (tableSpaceName == null) {
                    throw new StatementExecutionException("COMMITTRANSACTION requires two parameters (EXECUTE ROLLBACKTRANSACTION tableSpaceName transactionId)");
                }
                Object transactionId = JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(1), true);
                if (transactionId == null) {
                    throw new StatementExecutionException("COMMITTRANSACTION requires two parameters (EXECUTE ROLLBACKTRANSACTION tableSpaceName transactionId)");
                }
                try {
                    return new RollbackTransactionStatement(tableSpaceName.toString(), Long.parseLong(transactionId.toString()));
                }
                catch (NumberFormatException err) {
                    throw new StatementExecutionException("COMMITTRANSACTION requires two parameters (EXECUTE ROLLBACKTRANSACTION tableSpaceName transactionId)");
                }
            }
            case "CREATETABLESPACE": {
                if (execute.getExprList() == null || execute.getExprList().getExpressions().size() < 1) {
                    throw new StatementExecutionException("CREATETABLESPACE syntax (EXECUTE CREATETABLESPACE tableSpaceName ['leader:LEADERID'],['wait:TIMEOUT'] )");
                }
                Object tableSpaceName = JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(0), true);
                String leader = null;
                Set<String> replica = new HashSet<String>();
                int expectedreplicacount = this.manager.getServerConfiguration().getInt("tablespace.default.replica.count", 1);
                long maxleaderinactivitytime = 0L;
                int wait = 0;
                block62: for (int i = 1; i < execute.getExprList().getExpressions().size(); ++i) {
                    String property = (String)JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(i), true);
                    int colon = property.indexOf(58);
                    if (colon <= 0) {
                        throw new StatementExecutionException("bad property " + property + " in " + execute + " statement");
                    }
                    String pName = property.substring(0, colon);
                    String value = property.substring(colon + 1);
                    switch (pName.toLowerCase()) {
                        case "leader": {
                            leader = value;
                            continue block62;
                        }
                        case "replica": {
                            replica = Arrays.asList(value.split(",")).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                            continue block62;
                        }
                        case "wait": {
                            wait = Integer.parseInt(value);
                            continue block62;
                        }
                        case "expectedreplicacount": {
                            try {
                                expectedreplicacount = Integer.parseInt(value.trim());
                                if (expectedreplicacount > 0) continue block62;
                                throw new StatementExecutionException("invalid expectedreplicacount " + value + " must be positive");
                            }
                            catch (NumberFormatException err) {
                                throw new StatementExecutionException("invalid expectedreplicacount " + value + ": " + err);
                            }
                        }
                        case "maxleaderinactivitytime": {
                            try {
                                maxleaderinactivitytime = Long.parseLong(value.trim());
                                if (maxleaderinactivitytime >= 0L) continue block62;
                                throw new StatementExecutionException("invalid maxleaderinactivitytime " + value + " must be positive or zero");
                            }
                            catch (NumberFormatException err) {
                                throw new StatementExecutionException("invalid maxleaderinactivitytime " + value + ": " + err);
                            }
                        }
                        default: {
                            throw new StatementExecutionException("bad property " + pName);
                        }
                    }
                }
                if (leader == null) {
                    leader = this.manager.getNodeId();
                }
                if (replica.isEmpty()) {
                    replica.add(leader);
                }
                return new CreateTableSpaceStatement(tableSpaceName + "", replica, leader, expectedreplicacount, wait, maxleaderinactivitytime);
            }
            case "ALTERTABLESPACE": {
                if (execute.getExprList() == null || execute.getExprList().getExpressions().size() < 2) {
                    throw new StatementExecutionException("ALTERTABLESPACE syntax (EXECUTE ALTERTABLESPACE tableSpaceName,'property:value','property2:value2')");
                }
                String tableSpaceName = (String)JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(0), true);
                try {
                    TableSpace tableSpace = this.manager.getMetadataStorageManager().describeTableSpace(tableSpaceName + "");
                    if (tableSpace == null) {
                        throw new TableSpaceDoesNotExistException(tableSpaceName);
                    }
                    Set<String> replica = tableSpace.replicas;
                    String leader = tableSpace.leaderId;
                    int expectedreplicacount = tableSpace.expectedReplicaCount;
                    long maxleaderinactivitytime = tableSpace.maxLeaderInactivityTime;
                    block63: for (int i = 1; i < execute.getExprList().getExpressions().size(); ++i) {
                        String property = (String)JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(i), true);
                        int colon = property.indexOf(58);
                        if (colon <= 0) {
                            throw new StatementExecutionException("bad property " + property + " in " + execute + " statement");
                        }
                        String pName = property.substring(0, colon);
                        String value = property.substring(colon + 1);
                        switch (pName.toLowerCase()) {
                            case "leader": {
                                leader = value;
                                continue block63;
                            }
                            case "replica": {
                                replica = Arrays.asList(value.split(",")).stream().map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
                                continue block63;
                            }
                            case "expectedreplicacount": {
                                try {
                                    expectedreplicacount = Integer.parseInt(value.trim());
                                    if (expectedreplicacount > 0) continue block63;
                                    throw new StatementExecutionException("invalid expectedreplicacount " + value + " must be positive");
                                }
                                catch (NumberFormatException err) {
                                    throw new StatementExecutionException("invalid expectedreplicacount " + value + ": " + err);
                                }
                            }
                            case "maxleaderinactivitytime": {
                                try {
                                    maxleaderinactivitytime = Long.parseLong(value.trim());
                                    if (maxleaderinactivitytime >= 0L) continue block63;
                                    throw new StatementExecutionException("invalid maxleaderinactivitytime " + value + " must be positive or zero");
                                }
                                catch (NumberFormatException err) {
                                    throw new StatementExecutionException("invalid maxleaderinactivitytime " + value + ": " + err);
                                }
                            }
                            default: {
                                throw new StatementExecutionException("bad property " + pName);
                            }
                        }
                    }
                    return new AlterTableSpaceStatement(tableSpaceName + "", replica, leader, expectedreplicacount, maxleaderinactivitytime);
                }
                catch (MetadataStorageManagerException err) {
                    throw new StatementExecutionException(err);
                }
            }
            case "DROPTABLESPACE": {
                if (execute.getExprList() == null || execute.getExprList().getExpressions().size() != 1) {
                    throw new StatementExecutionException("DROPTABLESPACE syntax (EXECUTE DROPTABLESPACE tableSpaceName)");
                }
                String tableSpaceName = (String)JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(0), true);
                try {
                    TableSpace tableSpace = this.manager.getMetadataStorageManager().describeTableSpace(tableSpaceName + "");
                    if (tableSpace == null) {
                        throw new TableSpaceDoesNotExistException(tableSpaceName);
                    }
                    return new DropTableSpaceStatement(tableSpaceName + "");
                }
                catch (MetadataStorageManagerException err) {
                    throw new StatementExecutionException(err);
                }
            }
            case "RENAMETABLE": {
                if (execute.getExprList() == null || execute.getExprList().getExpressions().size() != 3) {
                    throw new StatementExecutionException("RENAMETABLE syntax (EXECUTE RENAMETABLE 'tableSpaceName','tablename','nametablename')");
                }
                String tableSpaceName = (String)JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(0), true);
                String oldTableName = (String)JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(1), true);
                String newTableName = (String)JSQLParserPlanner.resolveValue((Expression)execute.getExprList().getExpressions().get(2), true);
                try {
                    TableSpace tableSpace = this.manager.getMetadataStorageManager().describeTableSpace(tableSpaceName + "");
                    if (tableSpace == null) {
                        throw new TableSpaceDoesNotExistException(tableSpaceName);
                    }
                    return new AlterTableStatement(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, oldTableName.toLowerCase(), tableSpaceName, newTableName.toLowerCase(), Collections.emptyList(), Collections.emptyList());
                }
                catch (MetadataStorageManagerException err) {
                    throw new StatementExecutionException(err);
                }
            }
        }
        throw new StatementExecutionException("Unsupported command " + execute.getName());
    }

    public herddb.model.Statement queryConsistencyCheckStatement(String defaultTablespace, String query, List<Object> parameters) {
        if (query.startsWith(TABLE_CONSISTENCY_COMMAND)) {
            String tableName;
            query = query.substring(query.substring(0, 21).length());
            String tableSpace = defaultTablespace;
            if (query.contains(".")) {
                String[] tokens = query.split("\\.");
                tableSpace = tokens[0].trim().replaceAll("'", "");
                tableName = tokens[1].trim().replaceAll("'", "");
            } else {
                tableName = query.trim();
            }
            TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(tableSpace);
            if (tableSpaceManager == null) {
                throw new TableSpaceDoesNotExistException(String.format("Tablespace %s does not exist.", tableSpace));
            }
            AbstractTableManager tableManager = tableSpaceManager.getTableManager(tableName);
            if (tableManager == null || tableManager.getCreatedInTransaction() > 0L) {
                throw new TableDoesNotExistException(String.format("Table %s does not exist.", tableName));
            }
            return new TableConsistencyCheckStatement(tableName, tableSpace);
        }
        throw new StatementExecutionException(String.format("Incorrect Syntax for tableconsistencycheck", new Object[0]));
    }

    public herddb.model.Statement queryConsistencyCheckStatement(String query) {
        if (query.startsWith(TABLESPACE_CONSISTENCY_COMMAND)) {
            String tableSpace = query.substring(query.substring(0, 26).length()).replace("'", "");
            TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(tableSpace.trim());
            if (tableSpaceManager == null) {
                throw new TableSpaceDoesNotExistException(String.format("Tablespace %s does not exist.", tableSpace));
            }
            return new TableSpaceConsistencyCheckStatement(tableSpace.trim());
        }
        throw new StatementExecutionException(String.format("Incorrect Syntax for tablespaceconsistencycheck", new Object[0]));
    }

    private herddb.model.Statement buildAlterStatement(String defaultTableSpace, Alter alter) throws StatementExecutionException {
        if (alter.getTable() == null) {
            throw new StatementExecutionException("missing table name");
        }
        String tableSpace = alter.getTable().getSchemaName();
        if (tableSpace == null) {
            tableSpace = defaultTableSpace;
        }
        tableSpace = SQLParserExpressionCompiler.fixMySqlBackTicks(tableSpace);
        ArrayList<herddb.model.Column> addColumns = new ArrayList<herddb.model.Column>();
        ArrayList<herddb.model.Column> modifyColumns = new ArrayList<herddb.model.Column>();
        ArrayList<String> dropColumns = new ArrayList<String>();
        ArrayList<String> dropForeignKeys = new ArrayList<String>();
        ArrayList<ForeignKeyDef> addForeignKeys = new ArrayList<ForeignKeyDef>();
        String tableName = SQLParserExpressionCompiler.fixMySqlBackTicks(alter.getTable().getName().toLowerCase());
        if (alter.getAlterExpressions() == null || alter.getAlterExpressions().size() != 1) {
            throw new StatementExecutionException("supported multi-alter operation '" + alter + "'");
        }
        AlterExpression alterExpression = (AlterExpression)alter.getAlterExpressions().get(0);
        AlterOperation operation = alterExpression.getOperation();
        Boolean changeAutoIncrement = null;
        TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(tableSpace);
        if (tableSpaceManager == null) {
            throw new StatementExecutionException("bad tablespace '" + tableSpace + "'");
        }
        herddb.model.Table table = this.getTable(defaultTableSpace, alter.getTable());
        switch (operation) {
            case ADD: {
                if (alterExpression.getColDataTypeList() != null) {
                    List cols = alterExpression.getColDataTypeList();
                    for (AlterExpression.ColumnDataType cl : cols) {
                        List<String> columnSpecs = this.decodeColumnSpecs(cl.getColumnSpecs());
                        int type = JSQLParserPlanner.sqlDataTypeToColumnType(cl.getColDataType().getDataType(), cl.getColDataType().getArgumentsStringList(), columnSpecs);
                        herddb.model.Column newColumn = herddb.model.Column.column(SQLParserExpressionCompiler.fixMySqlBackTicks(cl.getColumnName()), type, JSQLParserPlanner.decodeDefaultValue((ColumnDefinition)cl, type));
                        addColumns.add(newColumn);
                    }
                    break;
                }
                if (alterExpression.getIndex() != null && alterExpression.getIndex() instanceof ForeignKeyIndex) {
                    ForeignKeyDef fkIndex = this.parseForeignKeyIndex((ForeignKeyIndex)alterExpression.getIndex(), table, tableName, tableSpace);
                    addForeignKeys.add(fkIndex);
                    break;
                }
                throw new StatementExecutionException("Unrecognized ALTER TABLE ADD ... statement");
            }
            case DROP: {
                if (alterExpression.getColumnName() != null) {
                    dropColumns.add(SQLParserExpressionCompiler.fixMySqlBackTicks(alterExpression.getColumnName()));
                    break;
                }
                if (alterExpression.getConstraintName() != null) {
                    dropForeignKeys.add(SQLParserExpressionCompiler.fixMySqlBackTicks(alterExpression.getConstraintName()));
                    break;
                }
                throw new StatementExecutionException("Unrecognized ALTER TABLE DROP ... statement");
            }
            case MODIFY: {
                List cols = alterExpression.getColDataTypeList();
                for (AlterExpression.ColumnDataType cl : cols) {
                    String columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(cl.getColumnName().toLowerCase());
                    herddb.model.Column oldColumn = table.getColumn(columnName);
                    if (oldColumn == null) {
                        throw new StatementExecutionException("bad column " + columnName + " in table " + tableName + " in tablespace '" + tableSpace + "'");
                    }
                    Map<String, AbstractIndexManager> indexes = tableSpaceManager.getIndexesOnTable(tableName);
                    if (indexes != null) {
                        for (AbstractIndexManager am : indexes.values()) {
                            for (String indexedColumn : am.getColumnNames()) {
                                if (!(indexedColumn = SQLParserExpressionCompiler.fixMySqlBackTicks(indexedColumn)).equalsIgnoreCase(oldColumn.name)) continue;
                                throw new StatementExecutionException("cannot alter indexed " + columnName + " in table " + tableName + " in tablespace '" + tableSpace + "',index name is " + am.getIndexName());
                            }
                        }
                    }
                    List<String> columnSpecs = this.decodeColumnSpecs(cl.getColumnSpecs());
                    int newType = JSQLParserPlanner.sqlDataTypeToColumnType(cl.getColDataType().getDataType(), cl.getColDataType().getArgumentsStringList(), columnSpecs);
                    if (oldColumn.type != newType && !ColumnTypes.isNotNullToNullConversion(oldColumn.type, newType) && !ColumnTypes.isNullToNotNullConversion(oldColumn.type, newType)) {
                        throw new StatementExecutionException("cannot change datatype to " + ColumnTypes.typeToString(newType) + " for column " + columnName + " (" + ColumnTypes.typeToString(oldColumn.type) + ") in table " + tableName + " in tablespace '" + tableSpace + "'");
                    }
                    if (table.isPrimaryKeyColumn(columnName)) {
                        boolean new_auto_increment = this.decodeAutoIncrement(columnSpecs);
                        if (new_auto_increment && table.primaryKey.length > 1) {
                            throw new StatementExecutionException("cannot add auto_increment flag to " + cl.getColDataType().getDataType() + " for column " + columnName + " in table " + tableName + " in tablespace '" + tableSpace + "'");
                        }
                        if (table.auto_increment != new_auto_increment) {
                            changeAutoIncrement = new_auto_increment;
                        }
                    }
                    Bytes newDefault = oldColumn.defaultValue;
                    if (JSQLParserPlanner.containsDefaultClause((ColumnDefinition)cl)) {
                        newDefault = JSQLParserPlanner.decodeDefaultValue((ColumnDefinition)cl, newType);
                    }
                    herddb.model.Column newColumnDef = herddb.model.Column.column(columnName, newType, oldColumn.serialPosition, newDefault);
                    modifyColumns.add(newColumnDef);
                }
                break;
            }
            case CHANGE: {
                String renameTo;
                String columnName = alterExpression.getColOldName();
                List cols = alterExpression.getColDataTypeList();
                if (cols.size() != 1) {
                    throw new StatementExecutionException("bad CHANGE column " + columnName + " in table " + tableName + " in tablespace '" + tableSpace + "'");
                }
                AlterExpression.ColumnDataType cl = (AlterExpression.ColumnDataType)cols.get(0);
                herddb.model.Column oldColumn = table.getColumn(columnName);
                if (oldColumn == null) {
                    throw new StatementExecutionException("bad column " + columnName + " in table " + tableName + " in tablespace '" + tableSpace + "'");
                }
                Map<String, AbstractIndexManager> indexes = tableSpaceManager.getIndexesOnTable(tableName);
                if (indexes != null) {
                    for (AbstractIndexManager am : indexes.values()) {
                        for (String indexedColumn : am.getColumnNames()) {
                            if (!(indexedColumn = SQLParserExpressionCompiler.fixMySqlBackTicks(indexedColumn)).equalsIgnoreCase(oldColumn.name)) continue;
                            throw new StatementExecutionException("cannot alter indexed " + columnName + " in table " + tableName + " in tablespace '" + tableSpace + "',index name is " + am.getIndexName());
                        }
                    }
                }
                List<String> columnSpecs = this.decodeColumnSpecs(cl.getColumnSpecs());
                int newType = JSQLParserPlanner.sqlDataTypeToColumnType(cl.getColDataType().getDataType(), cl.getColDataType().getArgumentsStringList(), columnSpecs);
                if (oldColumn.type != newType) {
                    throw new StatementExecutionException("cannot change datatype to " + ColumnTypes.typeToString(newType) + " for column " + columnName + " (" + ColumnTypes.typeToString(oldColumn.type) + ") in table " + tableName + " in tablespace '" + tableSpace + "'");
                }
                if (table.isPrimaryKeyColumn(columnName)) {
                    boolean new_auto_increment = this.decodeAutoIncrement(columnSpecs);
                    if (new_auto_increment && table.primaryKey.length > 1) {
                        throw new StatementExecutionException("cannot add auto_increment flag to " + cl.getColDataType().getDataType() + " for column " + columnName + " in table " + tableName + " in tablespace '" + tableSpace + "'");
                    }
                    if (table.auto_increment != new_auto_increment) {
                        changeAutoIncrement = new_auto_increment;
                    }
                }
                if ((renameTo = SQLParserExpressionCompiler.fixMySqlBackTicks(cl.getColumnName().toLowerCase())) != null) {
                    columnName = renameTo;
                }
                herddb.model.Column newColumnDef = herddb.model.Column.column(columnName, newType, oldColumn.serialPosition, oldColumn.defaultValue);
                modifyColumns.add(newColumnDef);
                break;
            }
            default: {
                throw new StatementExecutionException("supported alter operation '" + alter + "'");
            }
        }
        return new AlterTableStatement(addColumns, modifyColumns, dropColumns, changeAutoIncrement, tableName.toLowerCase(), tableSpace, null, dropForeignKeys, addForeignKeys);
    }

    private herddb.model.Statement buildDropStatement(String defaultTableSpace, Drop drop) throws StatementExecutionException {
        if (drop.getType().equalsIgnoreCase("table")) {
            if (drop.getName() == null) {
                throw new StatementExecutionException("missing table name");
            }
            String tableSpace = SQLParserExpressionCompiler.fixMySqlBackTicks(drop.getName().getSchemaName());
            if (tableSpace == null) {
                tableSpace = defaultTableSpace;
            }
            String tableName = SQLParserExpressionCompiler.fixMySqlBackTicks(drop.getName().getName());
            return new DropTableStatement(tableSpace, tableName, drop.isIfExists());
        }
        if (drop.getType().equalsIgnoreCase("index")) {
            if (drop.getName() == null) {
                throw new StatementExecutionException("missing index name");
            }
            String tableSpace = SQLParserExpressionCompiler.fixMySqlBackTicks(drop.getName().getSchemaName());
            if (tableSpace == null) {
                tableSpace = defaultTableSpace;
            }
            String indexName = SQLParserExpressionCompiler.fixMySqlBackTicks(drop.getName().getName()).toLowerCase();
            return new DropIndexStatement(tableSpace, indexName, drop.isIfExists());
        }
        throw new StatementExecutionException("only DROP TABLE and TABLESPACE is supported, drop type=" + drop.getType() + " is not implemented");
    }

    private herddb.model.Statement buildTruncateStatement(String defaultTableSpace, Truncate truncate) throws StatementExecutionException {
        if (truncate.getTable() == null) {
            throw new StatementExecutionException("missing table name");
        }
        String tableSpace = truncate.getTable().getSchemaName();
        if (tableSpace == null) {
            tableSpace = defaultTableSpace;
        }
        String tableName = SQLParserExpressionCompiler.fixMySqlBackTicks(truncate.getTable().getName().toLowerCase());
        return new TruncateTableStatement(tableSpace, tableName);
    }

    private ExecutionPlan buildSelectStatement(String defaultTableSpace, int maxRows, Select select, boolean forceScan) throws StatementExecutionException {
        ScanStatement scanStatement;
        JSQLParserPlanner.checkSupported(select.getWithItemsList() == null);
        SelectBody selectBody = select.getSelectBody();
        PlannerOp op = this.buildSelectBody(defaultTableSpace, maxRows, selectBody, forceScan).optimize();
        if (!forceScan && op instanceof BindableTableScanOp && (scanStatement = (ScanStatement)op.unwrap(ScanStatement.class)) != null && scanStatement.getPredicate() != null) {
            herddb.model.Table tableDef = scanStatement.getTableDef();
            CompiledSQLExpression where = (CompiledSQLExpression)scanStatement.getPredicate().unwrap(CompiledSQLExpression.class);
            SQLRecordKeyFunction keyFunction = IndexUtils.findIndexAccess(where, tableDef.getPrimaryKey(), tableDef, "=", tableDef);
            if (keyFunction == null || !keyFunction.isFullPrimaryKey()) {
                throw new StatementExecutionException("unsupported GET not on PK (" + keyFunction + ")");
            }
            GetStatement get = new GetStatement(scanStatement.getTableSpace(), scanStatement.getTable(), keyFunction, scanStatement.getPredicate(), true);
            return ExecutionPlan.simple(get);
        }
        return ExecutionPlan.simple(new SQLPlannedOperationStatement(op), op);
    }

    private PlannerOp buildSelectBody(String defaultTableSpace, int maxRows, SelectBody selectBody, boolean forceScan) throws StatementExecutionException {
        Limit limit;
        Projection projection;
        List selectItems;
        if (selectBody instanceof SetOperationList) {
            SetOperationList list = (SetOperationList)selectBody;
            return this.buildSetOperationList(defaultTableSpace, maxRows, list, forceScan);
        }
        JSQLParserPlanner.checkSupported(selectBody instanceof PlainSelect, selectBody.getClass().getName());
        PlainSelect plainSelect = (PlainSelect)selectBody;
        JSQLParserPlanner.checkSupported(!plainSelect.getMySqlHintStraightJoin());
        JSQLParserPlanner.checkSupported(!plainSelect.getMySqlSqlCalcFoundRows());
        JSQLParserPlanner.checkSupported(!plainSelect.getMySqlSqlNoCache());
        JSQLParserPlanner.checkSupported(plainSelect.getDistinct() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getFetch() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getFirst() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getForUpdateTable() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getForXmlPath() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getHaving() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getIntoTables() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getOffset() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getOptimizeFor() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getOracleHierarchical() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getOracleHint() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getSkip() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getWait() == null);
        JSQLParserPlanner.checkSupported(plainSelect.getKsqlWindow() == null);
        FromItem fromItem = plainSelect.getFromItem();
        JSQLParserPlanner.checkSupported(fromItem instanceof Table);
        OpSchema primaryTableSchema = this.getTableSchema(defaultTableSpace, (Table)fromItem);
        ColumnRef[] joinedTables = new ColumnRef[]{};
        int totalJoinOutputFieldsCount = primaryTableSchema.columns.length;
        if (plainSelect.getJoins() != null) {
            joinedTables = new OpSchema[plainSelect.getJoins().size()];
            int i = 0;
            for (Join join : plainSelect.getJoins()) {
                JSQLParserPlanner.checkSupported(!join.isApply());
                JSQLParserPlanner.checkSupported(!join.isCross());
                JSQLParserPlanner.checkSupported(!join.isFull() || join.isFull() && join.isOuter());
                JSQLParserPlanner.checkSupported(!join.isSemi());
                JSQLParserPlanner.checkSupported(!join.isStraight());
                JSQLParserPlanner.checkSupported(!join.isWindowJoin());
                JSQLParserPlanner.checkSupported(join.getJoinWindow() == null);
                JSQLParserPlanner.checkSupported(join.getUsingColumns() == null);
                ColumnRef[] rightItem = join.getRightItem();
                JSQLParserPlanner.checkSupported(rightItem instanceof Table);
                OpSchema joinedTable = this.getTableSchema(defaultTableSpace, (Table)rightItem);
                joinedTables[i++] = joinedTable;
                totalJoinOutputFieldsCount += joinedTable.columns.length;
            }
        }
        int pos = 0;
        String[] joinOutputFieldnames = new String[totalJoinOutputFieldsCount];
        ColumnRef[] joinOutputColumns = new ColumnRef[totalJoinOutputFieldsCount];
        System.arraycopy(primaryTableSchema.columnNames, 0, joinOutputFieldnames, 0, primaryTableSchema.columnNames.length);
        System.arraycopy(primaryTableSchema.columns, 0, joinOutputColumns, 0, primaryTableSchema.columns.length);
        pos += primaryTableSchema.columnNames.length;
        for (OpSchema opSchema : joinedTables) {
            System.arraycopy(opSchema.columnNames, 0, joinOutputFieldnames, pos, opSchema.columnNames.length);
            System.arraycopy(opSchema.columns, 0, joinOutputColumns, pos, opSchema.columns.length);
            pos += opSchema.columnNames.length;
        }
        OpSchema currentSchema = primaryTableSchema;
        JSQLParserPlanner.checkSupported(joinedTables.length <= 1);
        if (joinedTables.length > 0) {
            currentSchema = new OpSchema(primaryTableSchema.tableSpace, null, null, joinOutputFieldnames, joinOutputColumns);
        }
        JSQLParserPlanner.checkSupported(!(selectItems = plainSelect.getSelectItems()).isEmpty());
        SQLRecordPredicate predicate = null;
        TupleComparator tupleComparator = null;
        ScanLimits limits = null;
        boolean identityProjection = false;
        ArrayList<SelectExpressionItem> selectedFields = new ArrayList<SelectExpressionItem>(selectItems.size());
        boolean containsAggregatedFunctions = false;
        if (selectItems.size() == 1 && selectItems.get(0) instanceof AllColumns) {
            projection = Projection.IDENTITY(currentSchema.columnNames, ColumnRef.toColumnsArray(currentSchema.columns));
            identityProjection = true;
        } else {
            JSQLParserPlanner.checkSupported(!selectItems.isEmpty());
            for (SelectItem item : selectItems) {
                if (item instanceof SelectExpressionItem) {
                    SelectExpressionItem selectExpressionItem = (SelectExpressionItem)item;
                    selectedFields.add(selectExpressionItem);
                    if (SQLParserExpressionCompiler.detectAggregatedFunction(selectExpressionItem.getExpression()) == null) continue;
                    containsAggregatedFunctions = true;
                    continue;
                }
                if (item instanceof AllTableColumns) {
                    AllTableColumns allTablesColumn = (AllTableColumns)item;
                    Table table = allTablesColumn.getTable();
                    String tableName = SQLParserExpressionCompiler.fixMySqlBackTicks(table.getName());
                    boolean found = false;
                    if (primaryTableSchema.isTableOrAlias(tableName)) {
                        for (ColumnRef col : primaryTableSchema.columns) {
                            Column c = new Column(table, col.name);
                            SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)c);
                            selectedFields.add(selectExpressionItem);
                            found = true;
                        }
                    } else {
                        for (ColumnRef joinedTableSchema : joinedTables) {
                            if (!((OpSchema)((Object)joinedTableSchema)).isTableOrAlias(tableName)) continue;
                            for (Column col : ((OpSchema)((Object)joinedTableSchema)).columns) {
                                Column c = new Column(table, col.name);
                                SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)c);
                                selectedFields.add(selectExpressionItem);
                            }
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    JSQLParserPlanner.checkSupported(false, "Bad table ref " + tableName + ".*");
                    continue;
                }
                JSQLParserPlanner.checkSupported(false);
            }
            if (!containsAggregatedFunctions) {
                projection = this.buildProjection(selectedFields, true, currentSchema);
            } else {
                projection = Projection.IDENTITY(currentSchema.columnNames, ColumnRef.toColumnsArray(currentSchema.columns));
                identityProjection = true;
            }
        }
        TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(primaryTableSchema.tableSpace);
        AbstractTableManager tableManager = tableSpaceManager.getTableManager(primaryTableSchema.name);
        herddb.model.Table tableImpl = tableManager.getTable();
        CompiledSQLExpression whereExpression = null;
        if (plainSelect.getWhere() != null) {
            whereExpression = SQLParserExpressionCompiler.compileExpression(plainSelect.getWhere(), currentSchema);
            if (joinedTables.length == 0 && whereExpression != null) {
                SQLRecordPredicate sqlWhere = new SQLRecordPredicate(tableImpl, null, whereExpression);
                IndexUtils.discoverIndexOperations(primaryTableSchema.tableSpace, whereExpression, tableImpl, sqlWhere, selectBody, tableSpaceManager);
                predicate = sqlWhere;
            }
        }
        ScanStatement scan = new ScanStatement(primaryTableSchema.tableSpace, primaryTableSchema.name, Projection.IDENTITY(primaryTableSchema.columnNames, ColumnRef.toColumnsArray(primaryTableSchema.columns)), predicate, tupleComparator, limits);
        scan.setTableDef(tableImpl);
        PlannerOp op = new BindableTableScanOp(scan);
        PlannerOp[] scanJoinedTables = new PlannerOp[joinedTables.length];
        int ji = 0;
        for (ColumnRef joinedTable : joinedTables) {
            ScanStatement scanSecondaryTable = new ScanStatement(((OpSchema)((Object)joinedTable)).tableSpace, ((OpSchema)((Object)joinedTable)).name, Projection.IDENTITY(((OpSchema)((Object)joinedTable)).columnNames, ColumnRef.toColumnsArray(((OpSchema)((Object)joinedTable)).columns)), null, null, null);
            scan.setTableDef(tableImpl);
            JSQLParserPlanner.checkSupported(((OpSchema)((Object)joinedTable)).tableSpace.equalsIgnoreCase(primaryTableSchema.tableSpace));
            BindableTableScanOp opSecondaryTable = new BindableTableScanOp(scanSecondaryTable);
            scanJoinedTables[ji++] = opSecondaryTable;
        }
        if (scanJoinedTables.length > 0) {
            Expression onExpression;
            Join joinClause = (Join)plainSelect.getJoins().get(0);
            ArrayList<CompiledSQLExpression> joinConditions = new ArrayList<CompiledSQLExpression>();
            if (joinClause.isNatural()) {
                ArrayList<CompiledEqualsExpression> naturalJoinConstraints = new ArrayList<CompiledEqualsExpression>();
                int posInRowLeft = 0;
                for (ColumnRef ref : primaryTableSchema.columns) {
                    int posInRowRight = primaryTableSchema.columns.length;
                    for (ColumnRef ref2 : ((OpSchema)((Object)joinedTables[0])).columns) {
                        if (ref2.name.equalsIgnoreCase(ref.name)) {
                            CompiledEqualsExpression equals = new CompiledEqualsExpression(new AccessCurrentRowExpression(posInRowLeft, ref.type), new AccessCurrentRowExpression(posInRowRight, ref2.type));
                            naturalJoinConstraints.add(equals);
                        }
                        ++posInRowRight;
                    }
                    ++posInRowLeft;
                }
                CompiledMultiAndExpression naturalJoin = new CompiledMultiAndExpression(naturalJoinConstraints.toArray(new CompiledSQLExpression[0]));
                joinConditions.add(naturalJoin);
            }
            if ((onExpression = joinClause.getOnExpression()) != null) {
                CompiledSQLExpression onCondition = SQLParserExpressionCompiler.compileExpression(onExpression, currentSchema);
                joinConditions.add(onCondition);
            }
            op = new JoinOp(joinOutputFieldnames, ColumnRef.toColumnsArray(joinOutputColumns), new int[]{}, op, new int[]{}, scanJoinedTables[0], joinClause.isRight() || joinClause.isFull() && joinClause.isOuter(), joinClause.isLeft() || joinClause.isFull() && joinClause.isOuter(), false, joinConditions);
            if (whereExpression != null) {
                op = new FilterOp(op, whereExpression);
            }
        }
        if (containsAggregatedFunctions) {
            JSQLParserPlanner.checkSupported(scanJoinedTables.length == 0);
            op = this.planAggregate(selectedFields, currentSchema, op, currentSchema, plainSelect.getGroupBy());
            currentSchema = new OpSchema(currentSchema.tableSpace, currentSchema.name, currentSchema.alias, ColumnRef.toColumnsRefsArray(currentSchema.name, op.getOutputSchema()));
        }
        if (plainSelect.getOrderByElements() != null) {
            op = this.planSort(op, currentSchema, plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            JSQLParserPlanner.checkSupported(scanJoinedTables.length == 0);
            JSQLParserPlanner.checkSupported(plainSelect.getTop() == null);
            limit = plainSelect.getLimit();
            CompiledSQLExpression offset = limit.getOffset() != null ? SQLParserExpressionCompiler.compileExpression(limit.getOffset(), currentSchema) : new ConstantExpression(0, 13);
            CompiledSQLExpression rowCount = null;
            if (limit.getRowCount() != null) {
                rowCount = SQLParserExpressionCompiler.compileExpression(limit.getRowCount(), currentSchema);
            }
            op = new LimitOp(op, rowCount, offset);
        }
        if (plainSelect.getTop() != null) {
            JSQLParserPlanner.checkSupported(scanJoinedTables.length == 0);
            JSQLParserPlanner.checkSupported(plainSelect.getLimit() == null);
            limit = plainSelect.getTop();
            CompiledSQLExpression rowCount = null;
            if (limit.getExpression() != null) {
                rowCount = SQLParserExpressionCompiler.compileExpression(limit.getExpression(), currentSchema);
            }
            op = new LimitOp(op, rowCount, new ConstantExpression(0, 13));
        }
        if (!containsAggregatedFunctions && !identityProjection) {
            op = new ProjectOp(projection, op);
        }
        if (maxRows > 0) {
            op = new LimitOp(op, new ConstantExpression(maxRows, 13), new ConstantExpression(0, 13)).optimize();
        }
        return op;
    }

    private OpSchema getTableSchema(String defaultTableSpace, Table table) {
        TableSpaceManager tableSpaceManager;
        String tableSpace = table.getSchemaName();
        if (tableSpace == null) {
            tableSpace = defaultTableSpace;
        }
        if ((tableSpaceManager = this.getTableSpaceManager(tableSpace = SQLParserExpressionCompiler.fixMySqlBackTicks(tableSpace))) == null) {
            this.clearCache();
            throw new StatementExecutionException("tablespace " + defaultTableSpace + " is not available");
        }
        String tableName = SQLParserExpressionCompiler.fixMySqlBackTicks(table.getName().toLowerCase());
        AbstractTableManager tableManager = tableSpaceManager.getTableManager(tableName);
        if (tableManager == null) {
            throw new TableDoesNotExistException("no table " + tableName + " here for " + tableSpace);
        }
        herddb.model.Table tableImpl = tableManager.getTable();
        String aliasTable = tableName;
        if (table.getAlias() != null) {
            aliasTable = SQLParserExpressionCompiler.fixMySqlBackTicks(table.getAlias().getName());
            JSQLParserPlanner.checkSupported(table.getAlias().getAliasColumns() == null);
        }
        ColumnRef[] refs = new ColumnRef[tableImpl.columns.length];
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = new ColumnRef(aliasTable, tableImpl.columns[i]);
        }
        return new OpSchema(tableSpace, tableName, aliasTable, tableImpl.columnNames, refs);
    }

    private herddb.model.Table getTable(String defaultTableSpace, Table table) {
        TableSpaceManager tableSpaceManager;
        String tableSpace = table.getSchemaName();
        if (tableSpace == null) {
            tableSpace = defaultTableSpace;
        }
        if ((tableSpaceManager = this.getTableSpaceManager(tableSpace = SQLParserExpressionCompiler.fixMySqlBackTicks(tableSpace))) == null) {
            this.clearCache();
            throw new StatementExecutionException("tablespace " + defaultTableSpace + " is not available");
        }
        String tableName = SQLParserExpressionCompiler.fixMySqlBackTicks(table.getName().toLowerCase());
        AbstractTableManager tableManager = tableSpaceManager.getTableManager(tableName);
        if (tableManager == null) {
            throw new TableDoesNotExistException("no table " + tableName + " here for " + tableSpace);
        }
        return tableManager.getTable();
    }

    private PlannerOp planAggregate(List<SelectExpressionItem> fieldList, OpSchema inputSchema, PlannerOp input, OpSchema originalTableSchema, GroupByElement groupBy) {
        PlannerOp op;
        Iterator col;
        ColumnRef colInSchema;
        ArrayList<herddb.model.Column> outputSchemaKeysInGroupBy = new ArrayList<herddb.model.Column>();
        ArrayList<String> fieldnamesKeysInGroupBy = new ArrayList<String>();
        ArrayList<herddb.model.Column> outputSchemaAggregationResults = new ArrayList<herddb.model.Column>();
        ArrayList<Object> fieldnamesAggregationResults = new ArrayList<Object>();
        ArrayList<Integer> projectionAggregationResults = new ArrayList<Integer>();
        ArrayList<List<Integer>> argLists = new ArrayList<List<Integer>>();
        ArrayList<String> aggtypes = new ArrayList<String>();
        ArrayList<herddb.model.Column> originalOutputSchema = new ArrayList<herddb.model.Column>();
        ArrayList<Object> originalFieldNames = new ArrayList<Object>();
        HashSet<Object> nonAggregateColumns = new HashSet<Object>();
        int k = 0;
        for (SelectExpressionItem sel : fieldList) {
            Expression exp;
            Function fn;
            Alias alias = sel.getAlias();
            Object fieldName = null;
            if (alias != null) {
                JSQLParserPlanner.checkSupported(alias.getAliasColumns() == null);
                fieldName = SQLParserExpressionCompiler.fixMySqlBackTicks(alias.getName().toLowerCase());
            }
            if ((fn = SQLParserExpressionCompiler.detectAggregatedFunction(exp = sel.getExpression())) != null) {
                int type = SQLParserExpressionCompiler.getAggregateFunctionType(exp, inputSchema);
                ColumnRef additionalColumn = SQLParserExpressionCompiler.getAggregateFunctionArgument(fn, inputSchema);
                aggtypes.add(SQLParserExpressionCompiler.fixMySqlBackTicks(fn.getName().toLowerCase()));
                if (additionalColumn != null) {
                    IntHolder pos = new IntHolder();
                    SQLParserExpressionCompiler.findColumnInSchema(additionalColumn.tableName, SQLParserExpressionCompiler.fixMySqlBackTicks(additionalColumn.name), originalTableSchema, pos);
                    JSQLParserPlanner.checkSupported(pos.value >= 0);
                    argLists.add(Collections.singletonList(pos.value));
                } else {
                    argLists.add(Collections.emptyList());
                }
                if (fieldName == null) {
                    fieldName = "expr$" + k;
                }
                herddb.model.Column col2 = herddb.model.Column.column((String)fieldName, type);
                outputSchemaAggregationResults.add(col2);
                originalFieldNames.add(fieldName);
                originalOutputSchema.add(col2);
                fieldnamesAggregationResults.add(fieldName);
                projectionAggregationResults.add(k);
            } else if (exp instanceof Column) {
                Column colRef = (Column)exp;
                String tableAlias = SQLParserExpressionCompiler.extractTableName(colRef);
                colInSchema = SQLParserExpressionCompiler.findColumnInSchema(tableAlias, SQLParserExpressionCompiler.fixMySqlBackTicks(colRef.getColumnName()), inputSchema, new IntHolder());
                JSQLParserPlanner.checkSupported(colInSchema != null);
                if (fieldName == null) {
                    fieldName = colInSchema.name;
                }
                col = herddb.model.Column.column((String)fieldName, colInSchema.type);
                originalFieldNames.add(fieldName);
                originalOutputSchema.add((herddb.model.Column)((Object)col));
                nonAggregateColumns.add(fieldName);
            } else {
                JSQLParserPlanner.checkSupported(false);
            }
            ++k;
        }
        ArrayList<Integer> groupedFieldsIndexes = new ArrayList<Integer>();
        ArrayList<Integer> projectionForGroupByFields = new ArrayList<Integer>();
        if (groupBy != null) {
            JSQLParserPlanner.checkSupported(groupBy.getGroupingSets() == null || groupBy.getGroupingSets().isEmpty());
            int posInGroupBy = 0;
            for (Expression exp : groupBy.getGroupByExpressions()) {
                if (exp instanceof Column) {
                    Column colRef = (Column)exp;
                    String tableName = SQLParserExpressionCompiler.extractTableName(colRef);
                    IntHolder pos = new IntHolder();
                    colInSchema = SQLParserExpressionCompiler.findColumnInSchema(tableName, SQLParserExpressionCompiler.fixMySqlBackTicks(colRef.getColumnName()), inputSchema, pos);
                    JSQLParserPlanner.checkSupported(colInSchema != null);
                    groupedFieldsIndexes.add(pos.value);
                    fieldnamesKeysInGroupBy.add(SQLParserExpressionCompiler.fixMySqlBackTicks(colRef.getColumnName()));
                    outputSchemaKeysInGroupBy.add(colInSchema.toColumn());
                    projectionForGroupByFields.add(posInGroupBy);
                } else {
                    JSQLParserPlanner.checkSupported(false);
                }
                ++posInGroupBy;
            }
        } else {
            Iterator posInGroupBy = nonAggregateColumns.iterator();
            if (posInGroupBy.hasNext()) {
                String s = (String)posInGroupBy.next();
                throw new StatementExecutionException("field " + s + " MUST appear in GROUP BY clause");
            }
        }
        if (!groupedFieldsIndexes.isEmpty()) {
            int pos;
            ArrayList<herddb.model.Column> outputSchema = new ArrayList<herddb.model.Column>();
            outputSchema.addAll(outputSchemaKeysInGroupBy);
            outputSchema.addAll(outputSchemaAggregationResults);
            herddb.model.Column[] outputSchemaArray = outputSchema.toArray(new herddb.model.Column[0]);
            ArrayList<Object> aggreateFieldNames = new ArrayList<Object>();
            aggreateFieldNames.addAll(fieldnamesKeysInGroupBy);
            aggreateFieldNames.addAll(fieldnamesAggregationResults);
            op = new AggregateOp(input, aggreateFieldNames.toArray(new String[0]), outputSchemaArray, aggtypes.toArray(new String[0]), argLists, groupedFieldsIndexes);
            String[] reodereded = originalFieldNames.toArray(new String[0]);
            int[] projections = new int[originalFieldNames.size()];
            int i = 0;
            col = projectionForGroupByFields.iterator();
            while (col.hasNext()) {
                pos = (Integer)col.next();
                projections[pos] = i++;
            }
            col = projectionAggregationResults.iterator();
            while (col.hasNext()) {
                pos = (Integer)col.next();
                projections[pos] = i++;
            }
            ProjectOp.ZeroCopyProjection projection = new ProjectOp.ZeroCopyProjection(reodereded, originalOutputSchema.toArray(new herddb.model.Column[0]), projections);
            op = new ProjectOp(projection, op);
        } else {
            op = new AggregateOp(input, originalFieldNames.toArray(new String[0]), originalOutputSchema.toArray(new herddb.model.Column[0]), aggtypes.toArray(new String[0]), argLists, groupedFieldsIndexes);
        }
        return op;
    }

    private static ExecutionPlan optimizePlan(PlannerOp op) {
        op = op.optimize();
        return ExecutionPlan.simple(new SQLPlannedOperationStatement(op), op);
    }

    private PlannerOp planSort(PlannerOp input, OpSchema columns, List<OrderByElement> fieldCollations) {
        boolean[] directions = new boolean[fieldCollations.size()];
        boolean[] nullLastdirections = new boolean[fieldCollations.size()];
        int[] fields = new int[fieldCollations.size()];
        int i = 0;
        for (OrderByElement col : fieldCollations) {
            OrderByElement.NullOrdering nullDirection = col.getNullOrdering();
            CompiledSQLExpression columnPos = SQLParserExpressionCompiler.compileExpression(col.getExpression(), columns);
            JSQLParserPlanner.checkSupported(columnPos instanceof AccessCurrentRowExpression);
            AccessCurrentRowExpression pos = (AccessCurrentRowExpression)columnPos;
            int index = pos.getIndex();
            directions[i] = col.isAsc();
            nullLastdirections[i] = nullDirection == OrderByElement.NullOrdering.NULLS_LAST || nullDirection == null;
            fields[i++] = index;
        }
        return new SortOp(input, directions, fields, nullLastdirections);
    }

    private Projection buildProjection(List<SelectExpressionItem> projects, boolean allowIdentity, OpSchema tableSchema) {
        boolean allowZeroCopyProjection = true;
        ArrayList<CompiledSQLExpression> fields = new ArrayList<CompiledSQLExpression>(projects.size());
        herddb.model.Column[] columns = new herddb.model.Column[projects.size()];
        String[] fieldNames = new String[columns.length];
        int i = 0;
        int[] zeroCopyProjections = new int[fieldNames.length];
        boolean identity = allowIdentity && tableSchema != null && tableSchema.columns.length == fieldNames.length;
        for (SelectExpressionItem node : projects) {
            CompiledSQLExpression exp;
            Object col;
            int type = 10;
            String alias = null;
            if (node.getAlias() != null) {
                alias = SQLParserExpressionCompiler.fixMySqlBackTicks(node.getAlias().getName().toLowerCase());
                JSQLParserPlanner.checkSupported(node.getAlias().getAliasColumns() == null);
            }
            if (node.getExpression() instanceof Column && !SQLParserExpressionCompiler.isBooleanLiteral((Column)node.getExpression())) {
                col = (Column)node.getExpression();
                String columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(col.getColumnName());
                String tableAlias = SQLParserExpressionCompiler.extractTableName(col);
                if (alias == null) {
                    alias = columnName;
                }
                IntHolder indexInSchema = new IntHolder(-1);
                ColumnRef found = SQLParserExpressionCompiler.findColumnInSchema(tableAlias, columnName, tableSchema, indexInSchema);
                if (indexInSchema.value == -1 || found == null) {
                    String nameInError = tableAlias != null ? tableAlias + "." + columnName : columnName;
                    throw new StatementExecutionException("Column " + nameInError + " not found in target table (schema " + tableSchema + ")");
                }
                exp = new AccessCurrentRowExpression(indexInSchema.value, found.type);
                type = found.type;
            } else {
                exp = SQLParserExpressionCompiler.compileExpression(node.getExpression(), tableSchema);
                if (alias == null) {
                    alias = "col" + i;
                }
            }
            if (exp instanceof AccessCurrentRowExpression) {
                int mappedIndex;
                AccessCurrentRowExpression accessCurrentRowExpression = (AccessCurrentRowExpression)exp;
                zeroCopyProjections[i] = mappedIndex = accessCurrentRowExpression.getIndex();
                if (i != mappedIndex) {
                    identity = false;
                }
            } else {
                allowZeroCopyProjection = false;
            }
            fields.add(exp);
            col = herddb.model.Column.column(alias, type);
            identity = identity && col.name.equals(tableSchema.columns[i].name);
            fieldNames[i] = alias;
            columns[i++] = col;
        }
        if (allowZeroCopyProjection) {
            if (identity) {
                return Projection.IDENTITY(fieldNames, columns);
            }
            return new ProjectOp.ZeroCopyProjection(fieldNames, columns, zeroCopyProjections);
        }
        return new ProjectOp.BasicProjection(fieldNames, columns, fields);
    }

    private ExecutionPlan buildInsertStatement(String defaultTableSpace, Insert insert, boolean returnValues) throws StatementExecutionException {
        Table table = insert.getTable();
        JSQLParserPlanner.checkSupported(table.getAlias() == null);
        JSQLParserPlanner.checkSupported(insert.getSelect() == null);
        ItemsList itemsList = insert.getItemsList();
        List columns = insert.getColumns();
        return this.planerInsertOrUpsert(defaultTableSpace, table, columns, itemsList, returnValues, false);
    }

    private ExecutionPlan planerInsertOrUpsert(String defaultTableSpace, Table table, List<Column> columns, ItemsList itemsList, boolean returnValues, boolean upsert) throws StatementExecutionException, StatementNotSupportedException {
        OpSchema inputSchema = this.getTableSchema(defaultTableSpace, table);
        TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(inputSchema.tableSpace);
        AbstractTableManager tableManager = tableSpaceManager.getTableManager(inputSchema.name);
        herddb.model.Table tableImpl = tableManager.getTable();
        ArrayList<CompiledSQLExpression> keyValueExpression = new ArrayList<CompiledSQLExpression>();
        ArrayList<String> keyExpressionToColumn = new ArrayList<String>();
        ArrayList<CompiledSQLExpression> valuesExpressions = new ArrayList<CompiledSQLExpression>();
        ArrayList<String> valuesColumns = new ArrayList<String>();
        boolean invalid = false;
        int index = 0;
        if (columns == null) {
            columns = new ArrayList<Column>();
            for (herddb.model.Column c : tableImpl.getColumns()) {
                columns.add(new Column(c.name));
            }
        }
        if (itemsList instanceof ExpressionList) {
            RecordFunction keyfunction;
            List values = ((ExpressionList)itemsList).getExpressions();
            for (Column column : columns) {
                CompiledSQLExpression exp = SQLParserExpressionCompiler.compileExpression((Expression)values.get(index), inputSchema);
                String columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(column.getColumnName()).toLowerCase();
                if (exp instanceof ConstantExpression || exp instanceof JdbcParameterExpression || exp instanceof TypedJdbcParameterExpression || exp instanceof CompiledFunction) {
                    boolean isAlwaysNull;
                    boolean bl = isAlwaysNull = exp instanceof ConstantExpression && ((ConstantExpression)exp).isNull();
                    if (!isAlwaysNull) {
                        herddb.model.Column columnFromSchema;
                        if (tableImpl.isPrimaryKeyColumn(columnName)) {
                            keyExpressionToColumn.add(columnName);
                            keyValueExpression.add(exp);
                        }
                        if ((columnFromSchema = tableImpl.getColumn(columnName)) == null) {
                            throw new StatementExecutionException("Column '" + columnName + "' not found in table " + tableImpl.name);
                        }
                        valuesColumns.add(columnFromSchema.name);
                        valuesExpressions.add(exp);
                    }
                    ++index;
                    continue;
                }
                JSQLParserPlanner.checkSupported(false, "Unsupported expression type " + exp.getClass().getName());
                break;
            }
            for (herddb.model.Column col : tableImpl.getColumns()) {
                if (valuesColumns.contains(col.name)) continue;
                if (col.defaultValue != null) {
                    valuesColumns.add(col.name);
                    CompiledSQLExpression defaultValueExpression = JSQLParserPlanner.makeDefaultValue(col);
                    valuesExpressions.add(defaultValueExpression);
                    continue;
                }
                if (!ColumnTypes.isNotNullDataType(col.type) || tableImpl.auto_increment) continue;
                throw new StatementExecutionException("Column '" + col.name + "' has no default value and does not allow NULLs");
            }
            if (!invalid) {
                if (keyValueExpression.isEmpty() && tableImpl.auto_increment) {
                    keyfunction = new AutoIncrementPrimaryKeyRecordFunction();
                } else {
                    if (keyValueExpression.size() != tableImpl.primaryKey.length) {
                        throw new StatementExecutionException("you must set a value for the primary key (expressions=" + keyValueExpression.size() + ")");
                    }
                    keyfunction = new SQLRecordKeyFunction(keyExpressionToColumn, keyValueExpression, tableImpl);
                }
            } else {
                throw new StatementNotSupportedException();
            }
            SQLRecordFunction valuesfunction = new SQLRecordFunction(valuesColumns, tableImpl, valuesExpressions);
            DMLStatement statement = new InsertStatement(inputSchema.tableSpace, inputSchema.name, keyfunction, valuesfunction, upsert).setReturnValues(returnValues);
            SimpleInsertOp op = new SimpleInsertOp(statement.setReturnValues(returnValues));
            return JSQLParserPlanner.optimizePlan(op);
        }
        if (itemsList instanceof MultiExpressionList) {
            List records = ((MultiExpressionList)itemsList).getExprList();
            ValuesOp values = this.planValuesForInsertOp(columns, tableImpl, inputSchema, records);
            InsertOp op = new InsertOp(tableImpl.tablespace, tableImpl.name, values, returnValues, upsert);
            return JSQLParserPlanner.optimizePlan(op);
        }
        JSQLParserPlanner.checkSupported(false);
        return null;
    }

    private ValuesOp planValuesForInsertOp(List<Column> fieldList, herddb.model.Table tableSchema, OpSchema insertSchema, List<ExpressionList> op) {
        ArrayList<List<CompiledSQLExpression>> tuples = new ArrayList<List<CompiledSQLExpression>>(op.size());
        herddb.model.Column[] columns = new herddb.model.Column[tableSchema.columns.length];
        int i = 0;
        String[] fieldNames = new String[tableSchema.columns.length];
        herddb.model.Column[] columnArray = tableSchema.columns;
        int n = columnArray.length;
        for (int j = 0; j < n; ++j) {
            herddb.model.Column tableColumn;
            columns[i] = tableColumn = columnArray[j];
            fieldNames[i++] = tableColumn.name;
        }
        for (ExpressionList tuple : op) {
            ArrayList<CompiledSQLExpression> row = new ArrayList<CompiledSQLExpression>(tuple.getExpressions().size());
            List values = tuple.getExpressions();
            for (herddb.model.Column tableColumn : tableSchema.columns) {
                int pos = 0;
                CompiledSQLExpression exp = null;
                for (Column field : fieldList) {
                    if (SQLParserExpressionCompiler.fixMySqlBackTicks(field.getColumnName()).equalsIgnoreCase(tableColumn.name)) {
                        Expression corresponding = (Expression)values.get(pos);
                        exp = SQLParserExpressionCompiler.compileExpression(corresponding, insertSchema);
                        break;
                    }
                    ++pos;
                }
                if (exp == null) {
                    if (tableColumn.defaultValue == null && ColumnTypes.isNotNullDataType(tableColumn.type) && !tableSchema.auto_increment) {
                        throw new StatementExecutionException("Column '" + tableColumn.name + "' has no default value and does not allow NULLs");
                    }
                    exp = JSQLParserPlanner.makeDefaultValue(tableColumn);
                }
                row.add(exp);
            }
            tuples.add(row);
        }
        return new ValuesOp(this.manager.getNodeId(), fieldNames, columns, tuples);
    }

    private ExecutionPlan buildUpsertStatement(String defaultTableSpace, Upsert upsert, boolean returnValues) throws StatementExecutionException {
        Table table = upsert.getTable();
        JSQLParserPlanner.checkSupported(upsert.getSelect() == null);
        JSQLParserPlanner.checkSupported(upsert.getDuplicateUpdateColumns() == null);
        JSQLParserPlanner.checkSupported(upsert.getDuplicateUpdateExpressionList() == null);
        ItemsList itemsList = upsert.getItemsList();
        List columns = upsert.getColumns();
        return this.planerInsertOrUpsert(defaultTableSpace, table, columns, itemsList, returnValues, true);
    }

    private ExecutionPlan buildUpdateStatement(String defaultTableSpace, Update update, boolean returnValues) throws StatementExecutionException {
        CompiledSQLExpression whereExpression;
        Table table = update.getTable();
        JSQLParserPlanner.checkSupported(table.getAlias() == null);
        OpSchema tableSchema = this.getTableSchema(defaultTableSpace, table);
        TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(tableSchema.tableSpace);
        AbstractTableManager tableManager = tableSpaceManager.getTableManager(tableSchema.name);
        herddb.model.Table tableImpl = tableManager.getTable();
        JSQLParserPlanner.checkSupported(update.getSelect() == null);
        JSQLParserPlanner.checkSupported(update.getJoins() == null);
        JSQLParserPlanner.checkSupported(update.getOrderByElements() == null);
        JSQLParserPlanner.checkSupported(update.getReturningExpressionList() == null);
        JSQLParserPlanner.checkSupported(update.getStartJoins() == null || update.getStartJoins().isEmpty());
        List projects = update.getExpressions();
        ArrayList<CompiledSQLExpression> expressions = new ArrayList<CompiledSQLExpression>(projects.size());
        int index = 0;
        ArrayList<String> updateColumnList = new ArrayList<String>(projects.size());
        for (Column column : update.getColumns()) {
            JSQLParserPlanner.checkSupported(column.getTable() == null);
            String columnName = SQLParserExpressionCompiler.fixMySqlBackTicks(column.getColumnName().toLowerCase());
            JSQLParserPlanner.checkSupported(!tableImpl.isPrimaryKeyColumn(columnName));
            updateColumnList.add(columnName);
            CompiledSQLExpression exp = SQLParserExpressionCompiler.compileExpression((Expression)projects.get(index), tableSchema);
            expressions.add(exp);
            ++index;
        }
        SQLRecordFunction function = new SQLRecordFunction(updateColumnList, tableImpl, expressions);
        SQLRecordPredicate where = null;
        if (update.getWhere() != null && (whereExpression = SQLParserExpressionCompiler.compileExpression(update.getWhere(), tableSchema)) != null) {
            SQLRecordPredicate sqlWhere = new SQLRecordPredicate(tableImpl, null, whereExpression);
            IndexUtils.discoverIndexOperations(tableSchema.tableSpace, whereExpression, tableImpl, sqlWhere, update, tableSpaceManager);
            where = sqlWhere;
        }
        SimpleUpdateOp op = new SimpleUpdateOp(new UpdateStatement(tableSchema.tableSpace, tableSchema.name, null, function, where).setReturnValues(returnValues));
        return JSQLParserPlanner.optimizePlan(op);
    }

    private ExecutionPlan buildDeleteStatement(String defaultTableSpace, Delete delete) throws StatementExecutionException {
        CompiledSQLExpression whereExpression;
        Table table = delete.getTable();
        JSQLParserPlanner.checkSupported(table.getAlias() == null);
        OpSchema tableSchema = this.getTableSchema(defaultTableSpace, table);
        TableSpaceManager tableSpaceManager = this.manager.getTableSpaceManager(tableSchema.tableSpace);
        AbstractTableManager tableManager = tableSpaceManager.getTableManager(tableSchema.name);
        herddb.model.Table tableImpl = tableManager.getTable();
        JSQLParserPlanner.checkSupported(delete.getLimit() == null);
        JSQLParserPlanner.checkSupported(delete.getJoins() == null);
        JSQLParserPlanner.checkSupported(delete.getOrderByElements() == null);
        JSQLParserPlanner.checkSupported(delete.getTables() == null || delete.getTables().isEmpty());
        SQLRecordPredicate where = null;
        if (delete.getWhere() != null && (whereExpression = SQLParserExpressionCompiler.compileExpression(delete.getWhere(), tableSchema)) != null) {
            SQLRecordPredicate sqlWhere = new SQLRecordPredicate(tableImpl, null, whereExpression);
            IndexUtils.discoverIndexOperations(tableSchema.tableSpace, whereExpression, tableImpl, sqlWhere, delete, tableSpaceManager);
            where = sqlWhere;
        }
        SimpleDeleteOp op = new SimpleDeleteOp(new DeleteStatement(tableSchema.tableSpace, tableSchema.name, null, where));
        return JSQLParserPlanner.optimizePlan(op);
    }

    private static boolean containsDefaultClause(ColumnDefinition cf) {
        List specs = cf.getColumnSpecs();
        if (specs == null || specs.isEmpty()) {
            return false;
        }
        for (String spec : specs) {
            if (!spec.equalsIgnoreCase("default")) continue;
            return true;
        }
        return false;
    }

    private static Bytes decodeDefaultValue(ColumnDefinition cf, int type) {
        List specs = cf.getColumnSpecs();
        if (specs == null || specs.isEmpty()) {
            return null;
        }
        int defaultKeyWordPos = -1;
        int i = 0;
        for (String spec : specs) {
            if (spec.equalsIgnoreCase("default")) {
                defaultKeyWordPos = i;
                break;
            }
            ++i;
        }
        if (defaultKeyWordPos < 0) {
            return null;
        }
        if (defaultKeyWordPos == specs.size() - 1) {
            throw new StatementExecutionException("Bad default constraint specs: " + specs);
        }
        String defaultRepresentation = (String)specs.get(defaultKeyWordPos + 1);
        if (defaultRepresentation.isEmpty()) {
            throw new StatementExecutionException("Bad default constraint specs: " + specs);
        }
        if (defaultRepresentation.equalsIgnoreCase("null")) {
            return null;
        }
        try {
            switch (type) {
                case 0: 
                case 11: {
                    if (defaultRepresentation.length() <= 1) {
                        throw new StatementExecutionException("Bad default constraint specs: " + specs);
                    }
                    if (!defaultRepresentation.startsWith("'") || !defaultRepresentation.endsWith("'")) {
                        throw new StatementExecutionException("Bad default constraint specs: " + specs);
                    }
                    return Bytes.from_string((String)defaultRepresentation.substring(1, defaultRepresentation.length() - 1));
                }
                case 2: 
                case 12: {
                    return Bytes.from_int((int)Integer.parseInt(defaultRepresentation));
                }
                case 1: 
                case 13: {
                    return Bytes.from_long((long)Long.parseLong(defaultRepresentation));
                }
                case 6: 
                case 16: {
                    return Bytes.from_double((double)Double.parseDouble(defaultRepresentation));
                }
                case 7: 
                case 17: {
                    if (defaultRepresentation.length() <= 1) {
                        throw new StatementExecutionException("Bad default constraint specs: " + specs);
                    }
                    if (!defaultRepresentation.startsWith("'") || !defaultRepresentation.endsWith("'")) {
                        throw new StatementExecutionException("Bad default constraint specs: " + specs);
                    }
                    if (!(defaultRepresentation = defaultRepresentation.substring(1, defaultRepresentation.length() - 1)).equalsIgnoreCase("true") && !defaultRepresentation.equalsIgnoreCase("false")) {
                        throw new StatementExecutionException("Bad default constraint specs: " + specs);
                    }
                    return Bytes.from_boolean((boolean)Boolean.parseBoolean(defaultRepresentation));
                }
                case 4: 
                case 15: {
                    if (!defaultRepresentation.equalsIgnoreCase("current_timestamp")) {
                        throw new StatementExecutionException("Bad default constraint specs: " + specs);
                    }
                    return Bytes.from_string((String)"CURRENT_TIMESTAMP");
                }
            }
            throw new StatementExecutionException("Default not yet supported for columns of type " + ColumnTypes.typeToString(type));
        }
        catch (IllegalArgumentException err) {
            throw new StatementExecutionException("Bad default constraint specs: " + specs, err);
        }
    }

    private static CompiledSQLExpression makeDefaultValue(herddb.model.Column col) {
        if (col.defaultValue == null) {
            return new ConstantExpression(null, 5);
        }
        switch (col.type) {
            case 0: 
            case 11: {
                return new ConstantExpression(col.defaultValue.to_string(), 11);
            }
            case 2: 
            case 12: {
                return new ConstantExpression(col.defaultValue.to_int(), 12);
            }
            case 1: 
            case 13: {
                return new ConstantExpression(col.defaultValue.to_long(), 13);
            }
            case 6: 
            case 16: {
                return new ConstantExpression(col.defaultValue.to_double(), 16);
            }
            case 7: 
            case 17: {
                return new ConstantExpression(col.defaultValue.to_boolean(), 17);
            }
            case 4: 
            case 15: {
                return new CompiledFunction("current_timestamp", Collections.emptyList());
            }
        }
        throw new UnsupportedOperationException("Not supported for type " + ColumnTypes.typeToString(col.type));
    }

    private PlannerOp buildSetOperationList(String defaultTableSpace, int maxRows, SetOperationList list, boolean forceScan) {
        JSQLParserPlanner.checkSupported(list.getFetch() == null);
        JSQLParserPlanner.checkSupported(list.getLimit() == null);
        JSQLParserPlanner.checkSupported(list.getOffset() == null);
        JSQLParserPlanner.checkSupported(list.getOrderByElements() == null);
        JSQLParserPlanner.checkSupported(list.getOperations().size() == 1);
        JSQLParserPlanner.checkSupported(list.getSelects().size() == 2);
        SetOperation operation = (SetOperation)list.getOperations().get(0);
        JSQLParserPlanner.checkSupported(operation instanceof UnionOp);
        UnionOp unionOp = (UnionOp)operation;
        JSQLParserPlanner.checkSupported(unionOp.isAll());
        JSQLParserPlanner.checkSupported(!unionOp.isDistinct());
        ArrayList<PlannerOp> inputs = new ArrayList<PlannerOp>();
        for (SelectBody body : list.getSelects()) {
            inputs.add(this.buildSelectBody(defaultTableSpace, -1, body, forceScan));
        }
        PlannerOp op = new UnionAllOp(inputs);
        if (maxRows > 0) {
            op = new LimitOp(op, new ConstantExpression(maxRows, 13), null);
        }
        return op;
    }

    public static void checkSupported(boolean condition) {
        if (!condition) {
            throw new StatementNotSupportedException();
        }
    }

    public static void checkSupported(boolean condition, Object message) {
        if (!condition) {
            throw new StatementNotSupportedException(message + "");
        }
    }

    private static class StatementNotSupportedException
    extends HerdDBInternalException {
        public StatementNotSupportedException() {
        }

        public StatementNotSupportedException(String message) {
            super(message);
        }
    }
}

