/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import herddb.core.AbstractIndexManager;
import herddb.core.TableSpaceManager;
import herddb.index.IndexOperation;
import herddb.index.PrimaryIndexPrefixScan;
import herddb.index.PrimaryIndexRangeScan;
import herddb.index.PrimaryIndexSeek;
import herddb.index.SecondaryIndexPrefixScan;
import herddb.index.SecondaryIndexRangeScan;
import herddb.index.SecondaryIndexSeek;
import herddb.model.ColumnsList;
import herddb.model.StatementExecutionException;
import herddb.model.Table;
import herddb.sql.SQLRecordKeyFunction;
import herddb.sql.SQLRecordPredicate;
import herddb.sql.expressions.BindableTableScanColumnNameResolver;
import herddb.sql.expressions.CompiledMultiAndExpression;
import herddb.sql.expressions.CompiledSQLExpression;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;

public class IndexUtils {
    private static final Logger LOG = Logger.getLogger(IndexUtils.class.getName());

    static void discoverIndexOperations(String tableSpace, CompiledSQLExpression where, Table table, SQLRecordPredicate predicate, Object debug, TableSpaceManager tableSpaceManager) throws StatementExecutionException {
        IndexOperation op = IndexUtils.scanForIndexAccess(where, table, tableSpaceManager);
        predicate.setIndexOperation(op);
        CompiledSQLExpression filterPk = IndexUtils.findFiltersOnPrimaryKey(table, where);
        if (filterPk != null) {
            filterPk = IndexUtils.remapPositionalAccessToToPrimaryKeyAccessor(filterPk, table, debug);
        }
        predicate.setPrimaryKeyFilter(filterPk);
    }

    private static IndexOperation scanForIndexAccess(CompiledSQLExpression expressionWhere, Table table, TableSpaceManager tableSpaceManager) {
        Map<String, AbstractIndexManager> indexes;
        SQLRecordKeyFunction keyFunction = IndexUtils.findIndexAccess(expressionWhere, table.primaryKey, table, "=", table);
        IndexOperation result = null;
        if (keyFunction != null) {
            result = keyFunction.isFullPrimaryKey() ? new PrimaryIndexSeek(keyFunction) : new PrimaryIndexPrefixScan(keyFunction);
        } else {
            SQLRecordKeyFunction rangeMax;
            SQLRecordKeyFunction rangeMin = IndexUtils.findIndexAccess(expressionWhere, table.primaryKey, table, ">=", table);
            if (rangeMin != null && !rangeMin.isFullPrimaryKey()) {
                rangeMin = null;
            }
            if (rangeMin == null && (rangeMin = IndexUtils.findIndexAccess(expressionWhere, table.primaryKey, table, ">", table)) != null && !rangeMin.isFullPrimaryKey()) {
                rangeMin = null;
            }
            if ((rangeMax = IndexUtils.findIndexAccess(expressionWhere, table.primaryKey, table, "<=", table)) != null && !rangeMax.isFullPrimaryKey()) {
                rangeMax = null;
            }
            if (rangeMax == null && (rangeMax = IndexUtils.findIndexAccess(expressionWhere, table.primaryKey, table, "<", table)) != null && !rangeMax.isFullPrimaryKey()) {
                rangeMax = null;
            }
            if (rangeMin != null || rangeMax != null) {
                result = new PrimaryIndexRangeScan(table.primaryKey, rangeMin, rangeMax);
            }
        }
        if (result == null && tableSpaceManager != null && (indexes = tableSpaceManager.getIndexesOnTable(table.name)) != null) {
            for (AbstractIndexManager index : indexes.values()) {
                IndexOperation secondaryIndexOperation;
                if (!index.isAvailable() || (secondaryIndexOperation = IndexUtils.findSecondaryIndexOperation(index, expressionWhere, table)) == null) continue;
                result = secondaryIndexOperation;
                break;
            }
        }
        return result;
    }

    private static IndexOperation findSecondaryIndexOperation(AbstractIndexManager index, CompiledSQLExpression where, Table table) throws StatementExecutionException {
        IndexOperation secondaryIndexOperation = null;
        String[] columnsToMatch = index.getColumnNames();
        SQLRecordKeyFunction indexSeekFunction = IndexUtils.findIndexAccess(where, columnsToMatch, index.getIndex(), "=", table);
        if (indexSeekFunction != null) {
            secondaryIndexOperation = indexSeekFunction.isFullPrimaryKey() ? new SecondaryIndexSeek(index.getIndexName(), columnsToMatch, indexSeekFunction) : new SecondaryIndexPrefixScan(index.getIndexName(), columnsToMatch, indexSeekFunction);
        } else {
            SQLRecordKeyFunction rangeMax;
            SQLRecordKeyFunction rangeMin = IndexUtils.findIndexAccess(where, columnsToMatch, index.getIndex(), ">=", table);
            if (rangeMin != null && !rangeMin.isFullPrimaryKey()) {
                rangeMin = null;
            }
            if (rangeMin == null && (rangeMin = IndexUtils.findIndexAccess(where, columnsToMatch, index.getIndex(), ">", table)) != null && !rangeMin.isFullPrimaryKey()) {
                rangeMin = null;
            }
            if ((rangeMax = IndexUtils.findIndexAccess(where, columnsToMatch, index.getIndex(), "<=", table)) != null && !rangeMax.isFullPrimaryKey()) {
                rangeMax = null;
            }
            if (rangeMax == null && (rangeMax = IndexUtils.findIndexAccess(where, columnsToMatch, index.getIndex(), "<", table)) != null && !rangeMax.isFullPrimaryKey()) {
                rangeMax = null;
            }
            if (rangeMin != null || rangeMax != null) {
                secondaryIndexOperation = new SecondaryIndexRangeScan(index.getIndexName(), columnsToMatch, rangeMin, rangeMax);
            }
        }
        return secondaryIndexOperation;
    }

    private static CompiledSQLExpression remapPositionalAccessToToPrimaryKeyAccessor(CompiledSQLExpression filterPk, Table table, Object debug) {
        try {
            int[] projectionToKey = table.getPrimaryKeyProjection();
            return filterPk.remapPositionalAccessToToPrimaryKeyAccessor(projectionToKey);
        }
        catch (IllegalStateException notImplemented) {
            if (debug instanceof RelNode) {
                LOG.log(Level.INFO, "Not implemented best access for PK on " + RelOptUtil.dumpPlan((String)"", (RelNode)((RelNode)debug), (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.ALL_ATTRIBUTES), notImplemented);
            } else {
                LOG.log(Level.INFO, "Not implemented best access for PK on {0}", debug);
            }
            return null;
        }
    }

    public static SQLRecordKeyFunction findIndexAccess(CompiledSQLExpression where, String[] columnsToMatch, ColumnsList table, String operator, BindableTableScanColumnNameResolver res) throws StatementExecutionException {
        String pk;
        List<CompiledSQLExpression> conditions;
        ArrayList<CompiledSQLExpression> expressions = new ArrayList<CompiledSQLExpression>();
        ArrayList<String> columns = new ArrayList<String>();
        String[] stringArray = columnsToMatch;
        int n = stringArray.length;
        for (int i = 0; i < n && !(conditions = where.scanForConstraintedValueOnColumnWithOperator(pk = stringArray[i], operator, res)).isEmpty(); ++i) {
            columns.add(pk);
            expressions.add(conditions.get(0));
        }
        if (expressions.isEmpty()) {
            return null;
        }
        return new SQLRecordKeyFunction(columns, expressions, table);
    }

    private static CompiledSQLExpression findFiltersOnPrimaryKey(Table table, CompiledSQLExpression where) throws StatementExecutionException {
        String pk;
        List<CompiledSQLExpression> conditions;
        ArrayList<CompiledSQLExpression> expressions = new ArrayList<CompiledSQLExpression>();
        String[] stringArray = table.primaryKey;
        int n = stringArray.length;
        for (int i = 0; i < n && !(conditions = where.scanForConstraintsOnColumn(pk = stringArray[i], table)).isEmpty(); ++i) {
            expressions.addAll(conditions);
        }
        if (expressions.isEmpty()) {
            return null;
        }
        if (expressions.size() == 1) {
            return (CompiledSQLExpression)expressions.get(0);
        }
        return new CompiledMultiAndExpression(expressions.toArray(new CompiledSQLExpression[expressions.size()]));
    }
}

