/*
 * Decompiled with CFR 0.152.
 */
package herddb.sql;

import herddb.core.DBManager;
import herddb.core.TableSpaceManager;
import herddb.model.NotLeaderException;
import herddb.model.StatementExecutionException;
import herddb.server.ServerConfiguration;
import herddb.sql.TranslatedQuery;
import herddb.utils.SystemProperties;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractSQLPlanner {
    protected final long waitForSchemaTimeout;
    protected static final Level DUMP_QUERY_LEVEL = Level.parse(SystemProperties.getStringSystemProperty((String)"herddb.planner.dumpqueryloglevel", (String)Level.FINE.toString()));
    private static final Logger LOG = Logger.getLogger(AbstractSQLPlanner.class.getName());
    protected final DBManager manager;

    public AbstractSQLPlanner(DBManager manager) {
        this.manager = manager;
        this.waitForSchemaTimeout = manager.getServerConfiguration().getInt("server.planner.waitfortablespace.timeout", ServerConfiguration.PROPERTY_PLANNER_WAITFORTABLESPACE_TIMEOUT_DEFAULT);
    }

    public abstract void clearCache();

    public abstract long getCacheHits();

    public abstract long getCacheMisses();

    public abstract long getCacheSize();

    public abstract TranslatedQuery translate(String var1, String var2, List<Object> var3, boolean var4, boolean var5, boolean var6, int var7) throws StatementExecutionException;

    protected final void ensureDefaultTableSpaceBootedLocally(String defaultTableSpace) {
        TableSpaceManager tableSpaceManager = this.getTableSpaceManager(defaultTableSpace);
        if (tableSpaceManager == null) {
            throw new NotLeaderException("tablespace " + defaultTableSpace + " not available here (at server " + this.manager.getNodeId() + ")");
        }
    }

    protected final TableSpaceManager getTableSpaceManager(String tableSpace) {
        long startTs = System.currentTimeMillis();
        TableSpaceManager result;
        while ((result = this.manager.getTableSpaceManager(tableSpace)) == null) {
            long delta = System.currentTimeMillis() - startTs;
            LOG.log(Level.FINE, "schema {0} not available yet, after waiting {1}/{2} ms", new Object[]{tableSpace, delta, this.waitForSchemaTimeout});
            if (delta >= this.waitForSchemaTimeout) {
                return null;
            }
            this.clearCache();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException err) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
        return result;
    }
}

