/*
 * Decompiled with CFR 0.152.
 */
package herddb.server;

import herddb.client.HDBException;
import herddb.client.ScanResultSet;
import herddb.client.ScanResultSetMetadata;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.utils.DataAccessor;

public class LocalClientScanResultSetImpl
extends ScanResultSet {
    private final DataScanner dataScanner;
    private final ScanResultSetMetadata metadata;

    LocalClientScanResultSetImpl(DataScanner dataScanner) {
        super(dataScanner.getTransactionId());
        this.dataScanner = dataScanner;
        this.metadata = new ScanResultSetMetadata(dataScanner.getFieldNames());
    }

    @Override
    public ScanResultSetMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void close() {
        if (this.dataScanner.isClosed()) {
            return;
        }
        try {
            this.dataScanner.close();
        }
        catch (DataScannerException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public boolean hasNext() throws HDBException {
        try {
            return this.dataScanner.hasNext();
        }
        catch (DataScannerException ex) {
            throw new HDBException(ex);
        }
    }

    @Override
    public DataAccessor next() throws HDBException {
        try {
            return this.dataScanner.next();
        }
        catch (DataScannerException ex) {
            throw new HDBException(ex);
        }
    }

    @Override
    public String getCursorName() {
        return "<scanner-" + System.identityHashCode(this.dataScanner) + "-@tx" + this.transactionId + ">";
    }
}

