/*
 * Decompiled with CFR 0.152.
 */
package herddb.security.sasl;

import herddb.security.sasl.SaslUtils;
import java.io.IOException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.zookeeper.server.auth.KerberosName;

public class SaslNettyClient {
    private static final Logger LOG = Logger.getLogger(SaslNettyClient.class.getName());
    private SaslClient saslClient;
    private Subject clientSubject;

    public SaslNettyClient(String username, String password, String serverHostname) throws Exception {
        String serverPrincipal = "herddb/" + serverHostname;
        this.clientSubject = this.loginClient();
        if (this.clientSubject == null) {
            LOG.log(Level.FINEST, "Using plain SASL/DIGEST-MD5 auth to connect to " + serverHostname);
            this.saslClient = Sasl.createSaslClient(new String[]{"DIGEST-MD5"}, null, null, "default", SaslUtils.getSaslProps(), new SaslClientCallbackHandler(username, password.toCharArray()));
        } else if (this.clientSubject.getPrincipals().isEmpty()) {
            LOG.log(Level.FINEST, "Using JAAS/SASL/DIGEST-MD5 auth to connect to " + serverPrincipal);
            String[] mechs = new String[]{"DIGEST-MD5"};
            username = (String)this.clientSubject.getPublicCredentials().toArray()[0];
            password = (String)this.clientSubject.getPrivateCredentials().toArray()[0];
            this.saslClient = Sasl.createSaslClient(mechs, username, "herddb", "herddb", null, new ClientCallbackHandler(password));
        } else {
            Object[] principals = this.clientSubject.getPrincipals().toArray();
            Principal clientPrincipal = (Principal)principals[0];
            KerberosName clientKerberosName = new KerberosName(clientPrincipal.getName());
            KerberosName serviceKerberosName = new KerberosName(serverPrincipal + "@" + clientKerberosName.getRealm());
            final String serviceName = serviceKerberosName.getServiceName();
            final String serviceHostname = serviceKerberosName.getHostName();
            final String clientPrincipalName = clientKerberosName.toString();
            LOG.log(Level.FINEST, "Using JAAS/SASL/GSSAPI auth to connect to server Principal " + serverPrincipal);
            this.saslClient = Subject.doAs(this.clientSubject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws SaslException {
                    String[] mechs = new String[]{"GSSAPI"};
                    return Sasl.createSaslClient(mechs, clientPrincipalName, serviceName, serviceHostname, null, new ClientCallbackHandler(null));
                }
            });
        }
        if (this.saslClient == null) {
            throw new IOException("Cannot create JVM SASL Client");
        }
    }

    public byte[] evaluateChallenge(final byte[] saslToken) throws SaslException {
        if (saslToken == null) {
            throw new SaslException("saslToken is null.");
        }
        if (this.clientSubject != null) {
            try {
                byte[] retval = Subject.doAs(this.clientSubject, new PrivilegedExceptionAction<byte[]>(){

                    @Override
                    public byte[] run() throws SaslException {
                        return SaslNettyClient.this.saslClient.evaluateChallenge(saslToken);
                    }
                });
                return retval;
            }
            catch (PrivilegedActionException e) {
                e.printStackTrace();
                throw new SaslException("SASL/JAAS error", e);
            }
        }
        return this.saslClient.evaluateChallenge(saslToken);
    }

    private Subject loginClient() throws SaslException, PrivilegedActionException, LoginException {
        String clientSection = "HerdDBClient";
        AppConfigurationEntry[] entries = Configuration.getConfiguration().getAppConfigurationEntry(clientSection);
        if (entries == null) {
            LOG.log(Level.FINEST, "No JAAS Configuration found with section HerdDBClient");
            return null;
        }
        try {
            LoginContext loginContext = new LoginContext(clientSection, new ClientCallbackHandler(null));
            loginContext.login();
            LOG.log(Level.INFO, "Using JAAS Configuration subject: " + loginContext.getSubject());
            return loginContext.getSubject();
        }
        catch (LoginException error) {
            LOG.log(Level.SEVERE, "Error JAAS Configuration subject: " + error, error);
            return null;
        }
    }

    public boolean hasInitialResponse() {
        return this.saslClient.hasInitialResponse();
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    public byte[] saslResponse(byte[] saslTokenMessage) {
        try {
            byte[] retval = this.saslClient.evaluateChallenge(saslTokenMessage);
            return retval;
        }
        catch (SaslException e) {
            LOG.log(Level.SEVERE, "saslResponse: Failed to respond to SASL server's token:", e);
            return null;
        }
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] userPassword;

        public SaslClientCallbackHandler(String username, char[] token) {
            this.userName = username;
            this.userPassword = token;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "handle: Unrecognized SASL client callback");
            }
            if (nc != null) {
                nc.setName(this.userName);
            }
            if (pc != null) {
                pc.setPassword(this.userPassword);
            }
            if (rc != null) {
                rc.setText(rc.getDefaultText());
            }
        }
    }

    private static class ClientCallbackHandler
    implements CallbackHandler {
        private String password = null;

        public ClientCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callback;
                    nc.setName(nc.getDefaultName());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)callback;
                    if (this.password == null) continue;
                    pc.setPassword(this.password.toCharArray());
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    RealmCallback rc = (RealmCallback)callback;
                    rc.setText(rc.getDefaultText());
                    continue;
                }
                if (callback instanceof AuthorizeCallback) {
                    String authzid;
                    AuthorizeCallback ac = (AuthorizeCallback)callback;
                    String authid = ac.getAuthenticationID();
                    if (authid.equals(authzid = ac.getAuthorizationID())) {
                        ac.setAuthorized(true);
                    } else {
                        ac.setAuthorized(false);
                    }
                    if (!ac.isAuthorized()) continue;
                    ac.setAuthorizedID(authzid);
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL ClientCallback");
            }
        }
    }
}

