/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.TransactionContext;
import herddb.model.planner.PlannerOp;
import herddb.utils.DataAccessor;
import java.util.Arrays;
import java.util.List;

public class UnionAllOp
implements PlannerOp {
    private final List<PlannerOp> inputs;

    public UnionAllOp(List<PlannerOp> inputs) {
        this.inputs = inputs;
    }

    @Override
    public String getTablespace() {
        return this.inputs.get(0).getTablespace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        try {
            StatementExecutionResult input = this.inputs.get(0).execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
            ScanResult downstream = (ScanResult)input;
            UnionAllDataScanner dataScanner = new UnionAllDataScanner(downstream.dataScanner, tableSpaceManager, transactionContext, context, lockRequired, forWrite);
            return new ScanResult(downstream.transactionId, dataScanner);
        }
        catch (DataScannerException ex) {
            throw new StatementExecutionException(ex);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UnionAllOp=");
        if (this.inputs == null || this.inputs.size() == 0) {
            sb.append("none");
        } else {
            sb.append(Arrays.toString(this.inputs.toArray()));
        }
        return sb.toString();
    }

    @Override
    public Column[] getOutputSchema() {
        return this.inputs.get(0).getOutputSchema();
    }

    private class UnionAllDataScanner
    extends DataScanner {
        int index;
        DataScanner current;
        final TableSpaceManager tableSpaceManager;
        TransactionContext transactionContext;
        final StatementEvaluationContext context;
        final boolean lockRequired;
        final boolean forWrite;
        private DataAccessor next;

        public UnionAllDataScanner(DataScanner first, TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws DataScannerException {
            super(first.getTransaction(), first.getFieldNames(), first.getSchema());
            this.index = 0;
            this.tableSpaceManager = tableSpaceManager;
            this.lockRequired = lockRequired;
            this.forWrite = forWrite;
            this.context = context;
            this.transactionContext = transactionContext;
            this.current = first;
            this.fetchNext();
        }

        private void fetchNext() throws DataScannerException {
            if (this.current.hasNext()) {
                this.next = this.current.next();
            } else if (this.index == UnionAllOp.this.inputs.size() - 1) {
                this.next = null;
            } else {
                if (this.current != null) {
                    this.current.close();
                }
                ++this.index;
                ScanResult execute = (ScanResult)((PlannerOp)UnionAllOp.this.inputs.get(this.index)).execute(this.tableSpaceManager, this.transactionContext, this.context, this.lockRequired, this.forWrite);
                this.transactionContext = new TransactionContext(execute.transactionId);
                this.transaction = execute.dataScanner.getTransaction();
                this.current = execute.dataScanner;
                this.fetchNext();
            }
        }

        @Override
        public boolean hasNext() throws DataScannerException {
            return this.next != null;
        }

        @Override
        public DataAccessor next() throws DataScannerException {
            DataAccessor current = this.next;
            this.fetchNext();
            return current;
        }

        @Override
        public void close() throws DataScannerException {
            this.current.close();
            super.close();
        }
    }
}

