/*
 * Decompiled with CFR 0.152.
 */
package herddb.model.planner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.core.MaterializedRecordSet;
import herddb.core.SimpleDataScanner;
import herddb.core.TableSpaceManager;
import herddb.model.Column;
import herddb.model.DataScanner;
import herddb.model.DataScannerException;
import herddb.model.ScanResult;
import herddb.model.StatementEvaluationContext;
import herddb.model.StatementExecutionException;
import herddb.model.StatementExecutionResult;
import herddb.model.Table;
import herddb.model.TransactionContext;
import herddb.model.TupleComparator;
import herddb.model.commands.ScanStatement;
import herddb.model.planner.BindableTableScanOp;
import herddb.model.planner.PlannerOp;
import herddb.model.planner.ProjectOp;
import herddb.model.planner.SortedBindableTableScanOp;
import herddb.model.planner.SortedTableScanOp;
import herddb.model.planner.TableScanOp;
import herddb.utils.DataAccessor;
import herddb.utils.SQLRecordPredicateFunctions;
import herddb.utils.Wrapper;
import java.util.Arrays;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class SortOp
implements PlannerOp,
TupleComparator {
    private final PlannerOp input;
    private final boolean[] directions;
    private final boolean[] nullLastDirections;
    private final int[] fields;
    private boolean onlyPrimaryKeyAndAscending;

    public SortOp(PlannerOp input, boolean[] directions, int[] fields, boolean[] nullLastDirections) {
        this.input = input.optimize();
        this.directions = directions;
        this.fields = fields;
        this.nullLastDirections = nullLastDirections;
    }

    @Override
    public String getTablespace() {
        return this.input.getTablespace();
    }

    @Override
    public StatementExecutionResult execute(TableSpaceManager tableSpaceManager, TransactionContext transactionContext, StatementEvaluationContext context, boolean lockRequired, boolean forWrite) throws StatementExecutionException {
        ScanResult scanResult;
        block9: {
            StatementExecutionResult input = this.input.execute(tableSpaceManager, transactionContext, context, lockRequired, forWrite);
            ScanResult downstreamScanResult = (ScanResult)input;
            DataScanner inputScanner = downstreamScanResult.dataScanner;
            DataScanner dataScanner = inputScanner;
            try {
                MaterializedRecordSet recordSet = tableSpaceManager.getDbmanager().getRecordSetFactory().createRecordSet(inputScanner.getFieldNames(), inputScanner.getSchema());
                while (dataScanner.hasNext()) {
                    DataAccessor row = dataScanner.next();
                    recordSet.add(row);
                }
                recordSet.writeFinished();
                recordSet.sort(this);
                SimpleDataScanner result = new SimpleDataScanner(downstreamScanResult.dataScanner.getTransaction(), recordSet);
                scanResult = new ScanResult(downstreamScanResult.transactionId, result);
                if (dataScanner == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (dataScanner != null) {
                        try {
                            dataScanner.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DataScannerException ex) {
                    throw new StatementExecutionException(ex);
                }
            }
            dataScanner.close();
        }
        return scanResult;
    }

    @Override
    public PlannerOp optimize() {
        if (this.input instanceof BindableTableScanOp) {
            Table tableDef;
            BindableTableScanOp op = (BindableTableScanOp)this.input;
            ScanStatement statement = op.getStatement();
            statement.setComparator(this);
            if (this.fields.length == 1 && this.directions[0] && (tableDef = statement.getTableDef()).getPrimaryKey().length == 1) {
                if (statement.getProjection() != null && statement.getProjection() instanceof ProjectOp.ZeroCopyProjection) {
                    ProjectOp.ZeroCopyProjection zeroCopyProjection = (ProjectOp.ZeroCopyProjection)statement.getProjection();
                    int index = zeroCopyProjection.mapPosition(this.fields[0]);
                    Column col = tableDef.resolveColumName(index);
                    if (col.name.equals(tableDef.getPrimaryKey()[0])) {
                        this.onlyPrimaryKeyAndAscending = true;
                    }
                } else if (statement.getProjection() != null && statement.getProjection() instanceof ProjectOp.IdentityProjection) {
                    Column col = tableDef.resolveColumName(this.fields[0]);
                    if (col.name.equals(tableDef.getPrimaryKey()[0])) {
                        this.onlyPrimaryKeyAndAscending = true;
                    }
                }
            }
            return new SortedBindableTableScanOp(statement);
        }
        if (this.input instanceof TableScanOp) {
            Table tableDef;
            TableScanOp op = (TableScanOp)this.input;
            ScanStatement statement = op.getStatement();
            statement.setComparator(this);
            if (this.fields.length == 1 && this.directions[0] && (tableDef = statement.getTableDef()).getPrimaryKey().length == 1) {
                if (statement.getProjection() != null && statement.getProjection() instanceof ProjectOp.ZeroCopyProjection) {
                    ProjectOp.ZeroCopyProjection zeroCopyProjection = (ProjectOp.ZeroCopyProjection)statement.getProjection();
                    int index = zeroCopyProjection.mapPosition(this.fields[0]);
                    Column col = tableDef.resolveColumName(index);
                    if (col.name.equals(tableDef.getPrimaryKey()[0])) {
                        this.onlyPrimaryKeyAndAscending = true;
                    }
                } else if (statement.getProjection() != null && statement.getProjection() instanceof ProjectOp.IdentityProjection) {
                    Column col = tableDef.resolveColumName(this.fields[0]);
                    if (col.name.equals(tableDef.getPrimaryKey()[0])) {
                        this.onlyPrimaryKeyAndAscending = true;
                    }
                }
            }
            return new SortedTableScanOp(statement);
        }
        return this;
    }

    @Override
    public boolean isOnlyPrimaryKeyAndAscending() {
        return this.onlyPrimaryKeyAndAscending;
    }

    @Override
    @SuppressFBWarnings(value={"RV_NEGATING_RESULT_OF_COMPARETO"})
    public int compare(DataAccessor o1, DataAccessor o2) {
        int i = 0;
        if (i < this.fields.length) {
            int index = this.fields[i];
            Object value1 = o1.get(index);
            Object value2 = o2.get(index);
            return this.compareValues(i, value1, value2);
        }
        return 0;
    }

    private int compareValues(int i, Object value1, Object value2) throws IllegalStateException {
        boolean nullLastDirection = this.nullLastDirections[i];
        if (nullLastDirection) {
            int result = SQLRecordPredicateFunctions.compare((Object)value1, (Object)value2);
            if (result != 0) {
                if (this.directions[i]) {
                    return result;
                }
                if (result > 0) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
        SQLRecordPredicateFunctions.CompareResult resWithNull = SQLRecordPredicateFunctions.compareConsiderNull((Object)value1, (Object)value2);
        if (this.directions[i]) {
            switch (resWithNull) {
                case EQUALS: {
                    return 0;
                }
                case NULL: {
                    return -1;
                }
                case GREATER: {
                    return 1;
                }
                case MINOR: {
                    return -1;
                }
            }
            throw new IllegalStateException(resWithNull + "");
        }
        switch (resWithNull) {
            case EQUALS: {
                return 0;
            }
            case NULL: {
                return 1;
            }
            case GREATER: {
                return -1;
            }
            case MINOR: {
                return 1;
            }
        }
        throw new IllegalStateException(resWithNull + "");
    }

    public <T> T unwrap(Class<T> clazz) {
        Object unwrapped = this.input.unwrap(clazz);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        return (T)Wrapper.unwrap((Object)this, clazz);
    }

    public String toString() {
        return "SortOp{fields=" + Arrays.toString(this.fields) + ",dirs=" + Arrays.toString(this.directions) + ",nullDirs=" + Arrays.toString(this.nullLastDirections) + ",onlyPrimaryKeyAndAscending=" + this.onlyPrimaryKeyAndAscending + "\ninput=" + this.input + '}';
    }

    @Override
    public Column[] getOutputSchema() {
        return this.input.getOutputSchema();
    }

    public PlannerOp getInput() {
        return this.input;
    }
}

